/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.animation.DynamicAnimControl;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.bullet.control.GhostControl;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.control.VehicleControl;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MyControl;
import jme3utilities.Validate;
import jme3utilities.minie.MyPco;

public final class MyControlP {
    public static final Logger logger = Logger.getLogger(MyControlP.class.getName());

    private MyControlP() {
    }

    public static boolean canApplyPhysicsLocal(Control sgc) {
        boolean result;
        boolean bl = result = sgc instanceof AbstractPhysicsControl || sgc instanceof GhostControl || sgc instanceof RigidBodyControl || sgc instanceof VehicleControl;
        if (sgc instanceof DynamicAnimControl) {
            result = false;
        }
        return result;
    }

    public static boolean canDisable(Control sgc) {
        boolean result = MyControl.canDisable((Control)sgc) || sgc instanceof PhysicsControl;
        return result;
    }

    public static String describe(Control sgc) {
        String result;
        if (sgc instanceof RigidBodyControl) {
            StringBuilder builder = new StringBuilder(60);
            String type = MyControl.describeType((Control)sgc);
            builder.append(type);
            RigidBodyControl rigidBodyControl = (RigidBodyControl)sgc;
            builder.append('[');
            String desc = MyPco.describe(rigidBodyControl);
            builder.append(desc);
            builder.append(' ');
            if (!rigidBodyControl.isInWorld()) {
                builder.append("NOT");
            }
            builder.append("inWorld,");
            if (!rigidBodyControl.isActive()) {
                builder.append("NOT");
            }
            builder.append("active,");
            if (!rigidBodyControl.isApplyScale()) {
                builder.append("NOT");
            }
            builder.append("applyScale,");
            if (!rigidBodyControl.isApplyPhysicsLocal()) {
                builder.append("NOT");
            }
            builder.append("applyLocal]");
            result = builder.toString();
        } else if (sgc instanceof DynamicAnimControl) {
            StringBuilder builder = new StringBuilder(60);
            String type = MyControl.describeType((Control)sgc);
            builder.append(type);
            DynamicAnimControl dac = (DynamicAnimControl)sgc;
            builder.append('[');
            int numLinks = dac.countLinks();
            builder.append(numLinks);
            builder.append(']');
            result = builder.toString();
        } else if (sgc instanceof GhostControl) {
            StringBuilder builder = new StringBuilder(60);
            String type = MyControl.describeType((Control)sgc);
            builder.append(type);
            GhostControl ghostControl = (GhostControl)sgc;
            builder.append('[');
            if (!ghostControl.isApplyScale()) {
                builder.append("NOT");
            }
            builder.append("applyScale,");
            if (!ghostControl.isApplyPhysicsLocal()) {
                builder.append("NOT");
            }
            builder.append("applyLocal]");
            result = builder.toString();
        } else {
            result = MyControl.describe((Control)sgc);
        }
        return result;
    }

    public static void disablePhysicsControls(Spatial subtree) {
        int numControls = subtree.getNumControls();
        for (int controlI = 0; controlI < numControls; ++controlI) {
            Control control = subtree.getControl(controlI);
            if (!(control instanceof PhysicsControl)) continue;
            MyControlP.setEnabled(control, false);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MyControlP.disablePhysicsControls(child);
            }
        }
    }

    public static void enablePhysicsControls(Spatial subtree, PhysicsSpace space) {
        int numControls = subtree.getNumControls();
        for (int controlI = 0; controlI < numControls; ++controlI) {
            Control control = subtree.getControl(controlI);
            if (!(control instanceof PhysicsControl)) continue;
            PhysicsControl pc = (PhysicsControl)control;
            pc.setPhysicsSpace(space);
            pc.setEnabled(true);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MyControlP.enablePhysicsControls(child, space);
            }
        }
    }

    public static RigidBodyControl findEnabledRbc(Spatial spatial) {
        RigidBodyControl result = null;
        int numControls = spatial.getNumControls();
        for (int controlI = 0; controlI < numControls; ++controlI) {
            RigidBodyControl rbc;
            Control control = spatial.getControl(controlI);
            if (!(control instanceof RigidBodyControl) || !(rbc = (RigidBodyControl)control).isEnabled()) continue;
            result = rbc;
            break;
        }
        return result;
    }

    public static boolean isApplyPhysicsLocal(Control sgc) {
        boolean result;
        Validate.nonNull((Object)sgc, (String)"control");
        if (sgc instanceof AbstractPhysicsControl) {
            AbstractPhysicsControl apc = (AbstractPhysicsControl)sgc;
            result = apc.isApplyPhysicsLocal();
        } else if (sgc instanceof GhostControl) {
            GhostControl gc = (GhostControl)sgc;
            result = gc.isApplyPhysicsLocal();
        } else if (sgc instanceof RigidBodyControl) {
            RigidBodyControl rbc = (RigidBodyControl)sgc;
            result = rbc.isApplyPhysicsLocal();
        } else if (sgc instanceof VehicleControl) {
            VehicleControl vc = (VehicleControl)sgc;
            result = vc.isApplyPhysicsLocal();
        } else {
            String typeName = sgc.getClass().getCanonicalName();
            String message = typeName + " does not support local physics.";
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    public static boolean isEnabled(Control sgc) {
        boolean result;
        Validate.nonNull((Object)sgc, (String)"control");
        if (sgc instanceof PhysicsControl) {
            PhysicsControl physicsControl = (PhysicsControl)sgc;
            result = physicsControl.isEnabled();
        } else {
            result = MyControl.isEnabled((Control)sgc);
        }
        return result;
    }

    public static boolean isPhysical(Spatial spatial) {
        Control rigidBodyControl = spatial.getControl(RigidBodyControl.class);
        boolean result = rigidBodyControl != null;
        return result;
    }

    public static float mass(Spatial spatial) {
        Validate.nonNull((Object)spatial, (String)"spatial");
        RigidBodyControl rigidBodyControl = MyControlP.findEnabledRbc(spatial);
        float mass = rigidBodyControl.getMass();
        assert (mass >= 0.0f) : mass;
        return mass;
    }

    public static void removeNonPhysicsControls(Spatial subtree) {
        int numControls = subtree.getNumControls();
        for (int controlI = numControls - 1; controlI >= 0; --controlI) {
            Control control = subtree.getControl(controlI);
            if (control instanceof PhysicsControl) continue;
            subtree.removeControl(control);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MyControlP.removeNonPhysicsControls(child);
            }
        }
    }

    public static void setApplyPhysicsLocal(Control sgc, boolean newSetting) {
        if (sgc instanceof AbstractPhysicsControl) {
            AbstractPhysicsControl apc = (AbstractPhysicsControl)sgc;
            apc.setApplyPhysicsLocal(newSetting);
        } else if (sgc instanceof GhostControl) {
            GhostControl gc = (GhostControl)sgc;
            gc.setApplyPhysicsLocal(newSetting);
        } else if (sgc instanceof RigidBodyControl) {
            RigidBodyControl rbc = (RigidBodyControl)sgc;
            rbc.setApplyPhysicsLocal(newSetting);
        } else if (sgc instanceof VehicleControl) {
            VehicleControl vc = (VehicleControl)sgc;
            vc.setApplyPhysicsLocal(newSetting);
        } else {
            String typeName = sgc.getClass().getCanonicalName();
            String msg = typeName + " does not support local physics.";
            throw new IllegalArgumentException(msg);
        }
    }

    public static void setEnabled(Control sgc, boolean newState) {
        if (sgc instanceof PhysicsControl) {
            PhysicsControl physicsControl = (PhysicsControl)sgc;
            physicsControl.setEnabled(newState);
        } else {
            MyControl.setEnabled((Control)sgc, (boolean)newState);
        }
    }
}

