/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsVehicle;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;

public final class MyPco {
    public static final Logger logger = Logger.getLogger(MyPco.class.getName());

    private MyPco() {
    }

    public static String describe(PhysicsRigidBody body) {
        String result;
        if (body.isStatic()) {
            result = "Sta";
        } else if (body.isKinematic()) {
            result = "Kin";
        } else {
            float mass = body.getMass();
            String massText = MyString.describe((float)mass);
            String activeText = body.isActive() ? "" : "/inactive";
            result = String.format("Dyn(mass=%s)%s", massText, activeText);
        }
        if (!body.isContactResponse()) {
            result = result + "/NOresponse";
        }
        if (!body.isInWorld()) {
            result = result + "/NOspace";
        }
        return result;
    }

    public static String objectName(PhysicsCollisionObject pco) {
        String name;
        Validate.nonNull((Object)pco, (String)"physics object");
        long id = pco.nativeId();
        if (pco instanceof PhysicsCharacter) {
            name = String.format("chara%d", id);
        } else if (pco instanceof PhysicsGhostObject) {
            name = String.format("ghost%d", id);
        } else if (pco instanceof PhysicsVehicle) {
            name = String.format("vehic%d", id);
        } else if (pco instanceof PhysicsRigidBody) {
            name = String.format("rigid%d", id);
        } else {
            String typeName = pco.getClass().getCanonicalName();
            String msg = "Unknown type of collision object: " + typeName;
            throw new IllegalArgumentException(msg);
        }
        return name;
    }

    public static long parseId(String name) {
        Validate.nonEmpty((String)name, (String)"name");
        if (name.length() <= 5) {
            throw new IllegalArgumentException("name=" + MyString.quote((CharSequence)name));
        }
        String decimal = name.substring(5);
        long result = Long.parseLong(decimal);
        return result;
    }
}

