/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.ConeCollisionShape;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.CylinderCollisionShape;
import com.jme3.bullet.collision.shapes.EmptyShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.MultiSphere;
import com.jme3.bullet.collision.shapes.SimplexCollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.math.Vector3f;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public final class MyShape {
    public static final Logger logger = Logger.getLogger(MyShape.class.getName());

    private MyShape() {
    }

    public static String describeType(CollisionShape shape) {
        String description = shape.getClass().getSimpleName();
        if (description.endsWith("Shape")) {
            description = MyString.removeSuffix((String)description, (String)"Shape");
        }
        if (description.endsWith("Collision")) {
            description = MyString.removeSuffix((String)description, (String)"Collision");
        }
        return description;
    }

    public static Vector3f halfExtents(CollisionShape shape, Vector3f storeResult) {
        Vector3f result;
        Validate.nonNull((Object)shape, (String)"shape");
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (shape instanceof BoxCollisionShape) {
            BoxCollisionShape box = (BoxCollisionShape)shape;
            box.getHalfExtents(result);
        } else if (shape instanceof CapsuleCollisionShape) {
            CapsuleCollisionShape capsule = (CapsuleCollisionShape)shape;
            float height = capsule.getHeight();
            float radius = capsule.getRadius();
            float axisHalfExtent = height / 2.0f + radius;
            int axisIndex = capsule.getAxis();
            switch (axisIndex) {
                case 0: {
                    result.set(axisHalfExtent, radius, radius);
                    break;
                }
                case 1: {
                    result.set(radius, axisHalfExtent, radius);
                    break;
                }
                case 2: {
                    result.set(radius, radius, axisHalfExtent);
                    break;
                }
                default: {
                    String message = "axisIndex = " + axisIndex;
                    throw new IllegalArgumentException(message);
                }
            }
        } else if (shape instanceof ConeCollisionShape) {
            ConeCollisionShape cone = (ConeCollisionShape)shape;
            float height = cone.getHeight();
            float radius = cone.getRadius();
            float axisHalfExtent = height / 2.0f;
            int axisIndex = cone.getAxis();
            switch (axisIndex) {
                case 0: {
                    result.set(axisHalfExtent, radius, radius);
                    break;
                }
                case 1: {
                    result.set(radius, axisHalfExtent, radius);
                    break;
                }
                case 2: {
                    result.set(radius, radius, axisHalfExtent);
                    break;
                }
                default: {
                    String message = "axisIndex = " + axisIndex;
                    throw new IllegalArgumentException(message);
                }
            }
        } else if (shape instanceof CylinderCollisionShape) {
            CylinderCollisionShape cylinder = (CylinderCollisionShape)shape;
            cylinder.getHalfExtents(result);
        } else if (shape instanceof HullCollisionShape) {
            HullCollisionShape hull = (HullCollisionShape)shape;
            hull.getHalfExtents(result);
        } else if (shape instanceof MultiSphere) {
            MultiSphere multiSphere = (MultiSphere)shape;
            if (multiSphere.countSpheres() == 1) {
                float radius = multiSphere.getRadius(0);
                result.set(radius, radius, radius);
            }
        } else if (shape instanceof SimplexCollisionShape) {
            SimplexCollisionShape simplex = (SimplexCollisionShape)shape;
            simplex.getHalfExtents(result);
        } else if (shape instanceof SphereCollisionShape) {
            SphereCollisionShape sphere = (SphereCollisionShape)shape;
            float radius = sphere.getRadius();
            result.set(radius, radius, radius);
        } else {
            String typeName = shape.getClass().getCanonicalName();
            String message = typeName + " lacks half extents.";
            throw new IllegalArgumentException(message);
        }
        assert (MyVector3f.isAllNonNegative((Vector3f)result)) : result;
        return result;
    }

    public static float height(CollisionShape shape) {
        Validate.nonNull((Object)shape, (String)"shape");
        float result = Float.NaN;
        if (shape instanceof CapsuleCollisionShape) {
            CapsuleCollisionShape capsule = (CapsuleCollisionShape)shape;
            result = capsule.getHeight();
        } else if (shape instanceof ConeCollisionShape) {
            ConeCollisionShape cone = (ConeCollisionShape)shape;
            result = cone.getHeight();
        } else if (shape instanceof CylinderCollisionShape) {
            CylinderCollisionShape cylinder = (CylinderCollisionShape)shape;
            Vector3f halfExtents = cylinder.getHalfExtents(null);
            int axisIndex = cylinder.getAxis();
            result = 2.0f * halfExtents.get(axisIndex);
        } else if (shape instanceof MultiSphere) {
            MultiSphere multiSphere = (MultiSphere)shape;
            if (multiSphere.countSpheres() == 1) {
                result = 2.0f * multiSphere.getRadius(0);
            }
        } else if (shape instanceof SphereCollisionShape) {
            SphereCollisionShape sphere = (SphereCollisionShape)shape;
            result = 2.0f * sphere.getRadius();
        }
        assert (Float.isNaN(result) || result >= 0.0f) : result;
        return result;
    }

    public static float[] listVolumes(CompoundCollisionShape shape) {
        ChildCollisionShape[] children = shape.listChildren();
        int numChildren = children.length;
        float[] result = new float[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            CollisionShape childShape = children[i].getShape();
            result[i] = MyShape.volume(childShape);
        }
        return result;
    }

    public static int mainAxisIndex(CollisionShape shape) {
        int result = -1;
        if (shape instanceof CapsuleCollisionShape) {
            CapsuleCollisionShape capsule = (CapsuleCollisionShape)shape;
            result = capsule.getAxis();
        } else if (shape instanceof ConeCollisionShape) {
            ConeCollisionShape cone = (ConeCollisionShape)shape;
            result = cone.getAxis();
        } else if (shape instanceof CylinderCollisionShape) {
            CylinderCollisionShape cylinder = (CylinderCollisionShape)shape;
            result = cylinder.getAxis();
        }
        return result;
    }

    public static long parseNativeId(String string) {
        Validate.nonEmpty((String)string, (String)"string");
        String[] parts = string.split("#");
        if (parts.length != 2) {
            String message = "string = " + MyString.quote((CharSequence)string);
            throw new IllegalArgumentException(message);
        }
        String hexadecimal = parts[1];
        long result = Long.parseLong(hexadecimal, 16);
        return result;
    }

    public static float radius(CollisionShape shape) {
        Validate.nonNull((Object)shape, (String)"shape");
        float result = Float.NaN;
        if (shape instanceof CapsuleCollisionShape) {
            CapsuleCollisionShape capsule = (CapsuleCollisionShape)shape;
            result = capsule.getRadius();
        } else if (shape instanceof ConeCollisionShape) {
            ConeCollisionShape cone = (ConeCollisionShape)shape;
            result = cone.getRadius();
        } else if (shape instanceof CylinderCollisionShape) {
            float r2;
            float r1;
            Vector3f halfExtents = MyShape.halfExtents(shape, null);
            int axisIndex = MyShape.mainAxisIndex(shape);
            switch (axisIndex) {
                case 0: {
                    r1 = halfExtents.y;
                    r2 = halfExtents.z;
                    break;
                }
                case 1: {
                    r1 = halfExtents.x;
                    r2 = halfExtents.z;
                    break;
                }
                case 2: {
                    r1 = halfExtents.x;
                    r2 = halfExtents.y;
                    break;
                }
                default: {
                    String message = "axisIndex = " + axisIndex;
                    throw new IllegalArgumentException(message);
                }
            }
            if (r1 == r2) {
                result = r1;
            }
        } else if (shape instanceof MultiSphere) {
            MultiSphere multiSphere = (MultiSphere)shape;
            if (multiSphere.countSpheres() == 1) {
                result = multiSphere.getRadius(0);
            }
        } else if (shape instanceof SphereCollisionShape) {
            result = ((SphereCollisionShape)shape).getRadius();
        }
        assert (Float.isNaN(result) || result >= 0.0f) : result;
        return result;
    }

    public static CollisionShape setHalfExtents(CollisionShape oldShape, Vector3f newHalfExtents) {
        int axisIndex;
        Object result;
        Validate.nonNull((Object)oldShape, (String)"old shape");
        Validate.nonNegative((Vector3f)newHalfExtents, (String)"new half extents");
        if (oldShape instanceof BoxCollisionShape) {
            result = new BoxCollisionShape(newHalfExtents);
        } else if (oldShape instanceof CapsuleCollisionShape || oldShape instanceof ConeCollisionShape) {
            float radius2;
            float radius1;
            float axisHalfExtent;
            axisIndex = MyShape.mainAxisIndex(oldShape);
            switch (axisIndex) {
                case 0: {
                    axisHalfExtent = newHalfExtents.x;
                    radius1 = newHalfExtents.y;
                    radius2 = newHalfExtents.z;
                    break;
                }
                case 1: {
                    axisHalfExtent = newHalfExtents.y;
                    radius1 = newHalfExtents.x;
                    radius2 = newHalfExtents.z;
                    break;
                }
                case 2: {
                    axisHalfExtent = newHalfExtents.z;
                    radius1 = newHalfExtents.x;
                    radius2 = newHalfExtents.y;
                    break;
                }
                default: {
                    String message = "axisIndex = " + axisIndex;
                    throw new IllegalArgumentException(message);
                }
            }
            if (radius1 != radius2) {
                result = null;
            } else if (oldShape instanceof CapsuleCollisionShape) {
                float height = 2.0f * (axisHalfExtent - radius1);
                result = new CapsuleCollisionShape(radius1, height, axisIndex);
            } else {
                assert (oldShape instanceof ConeCollisionShape);
                float height = 2.0f * axisHalfExtent;
                result = new ConeCollisionShape(radius1, height, axisIndex);
            }
        } else if (oldShape instanceof CylinderCollisionShape) {
            axisIndex = MyShape.mainAxisIndex(oldShape);
            result = new CylinderCollisionShape(newHalfExtents, axisIndex);
        } else {
            result = oldShape instanceof SphereCollisionShape ? (!MyVector3f.isScaleUniform((Vector3f)newHalfExtents) ? null : new SphereCollisionShape(newHalfExtents.x)) : null;
        }
        if (result != null) {
            boolean enable = oldShape.isContactFilterEnabled();
            ((CollisionShape)result).setContactFilterEnabled(enable);
            if (!(result instanceof CapsuleCollisionShape) && !(result instanceof SphereCollisionShape)) {
                float margin = oldShape.getMargin();
                ((CollisionShape)result).setMargin(margin);
            }
        }
        return result;
    }

    public static CollisionShape setHeight(CollisionShape oldShape, float newHeight) {
        int axisIndex;
        float radius;
        CollisionShape result;
        Validate.nonNull((Object)oldShape, (String)"old shape");
        Validate.nonNegative((float)newHeight, (String)"new height");
        if (oldShape instanceof BoxCollisionShape) {
            result = MyShape.setRadius(oldShape, newHeight / 2.0f);
        } else if (oldShape instanceof CapsuleCollisionShape) {
            radius = MyShape.radius(oldShape);
            axisIndex = MyShape.mainAxisIndex(oldShape);
            result = new CapsuleCollisionShape(radius, newHeight, axisIndex);
        } else if (oldShape instanceof ConeCollisionShape) {
            radius = MyShape.radius(oldShape);
            axisIndex = MyShape.mainAxisIndex(oldShape);
            result = new ConeCollisionShape(radius, newHeight, axisIndex);
        } else if (oldShape instanceof CylinderCollisionShape) {
            radius = MyShape.radius(oldShape);
            axisIndex = MyShape.mainAxisIndex(oldShape);
            result = new CylinderCollisionShape(radius, newHeight, axisIndex);
        } else {
            result = oldShape instanceof SphereCollisionShape ? MyShape.setRadius(oldShape, newHeight / 2.0f) : null;
        }
        if (result != null) {
            boolean enable = oldShape.isContactFilterEnabled();
            result.setContactFilterEnabled(enable);
            if (!(result instanceof CapsuleCollisionShape) && !(result instanceof SphereCollisionShape)) {
                float margin = oldShape.getMargin();
                result.setMargin(margin);
            }
        }
        return result;
    }

    public static CollisionShape setRadius(CollisionShape oldShape, float newRadius) {
        float height;
        int axisIndex;
        ConvexShape result;
        Validate.nonNull((Object)oldShape, (String)"old shape");
        Validate.nonNegative((float)newRadius, (String)"new radius");
        if (oldShape instanceof BoxCollisionShape) {
            result = new BoxCollisionShape(newRadius);
        } else if (oldShape instanceof CapsuleCollisionShape) {
            axisIndex = MyShape.mainAxisIndex(oldShape);
            height = MyShape.height(oldShape);
            result = new CapsuleCollisionShape(newRadius, height, axisIndex);
        } else if (oldShape instanceof ConeCollisionShape) {
            axisIndex = MyShape.mainAxisIndex(oldShape);
            height = MyShape.height(oldShape);
            result = new ConeCollisionShape(newRadius, height, axisIndex);
        } else if (oldShape instanceof CylinderCollisionShape) {
            axisIndex = MyShape.mainAxisIndex(oldShape);
            height = MyShape.height(oldShape);
            result = new CylinderCollisionShape(newRadius, height, axisIndex);
        } else {
            result = oldShape instanceof SphereCollisionShape ? new SphereCollisionShape(newRadius) : null;
        }
        if (result != null) {
            boolean enable = oldShape.isContactFilterEnabled();
            result.setContactFilterEnabled(enable);
            if (!(result instanceof CapsuleCollisionShape) && !(result instanceof SphereCollisionShape)) {
                float margin = oldShape.getMargin();
                result.setMargin(margin);
            }
        }
        return result;
    }

    public static float volume(CollisionShape shape) {
        Vector3f scale = shape.getScale(null);
        float volume = scale.x * scale.y * scale.z;
        if (shape instanceof BoxCollisionShape) {
            volume *= ((BoxCollisionShape)shape).unscaledVolume();
        } else if (shape instanceof CapsuleCollisionShape) {
            volume *= ((CapsuleCollisionShape)shape).unscaledVolume();
        } else if (shape instanceof CompoundCollisionShape) {
            CompoundCollisionShape compound = (CompoundCollisionShape)shape;
            volume = 0.0f;
            for (ChildCollisionShape child : compound.listChildren()) {
                float childVolume = MyShape.volume(child.getShape());
                volume += childVolume;
            }
        } else if (shape instanceof ConeCollisionShape) {
            ConeCollisionShape cone = (ConeCollisionShape)shape;
            volume *= cone.unscaledVolume();
        } else if (shape instanceof CylinderCollisionShape) {
            CylinderCollisionShape cylinder = (CylinderCollisionShape)shape;
            volume *= cylinder.unscaledVolume();
        } else if (shape instanceof EmptyShape) {
            volume = 0.0f;
        } else if (shape instanceof HullCollisionShape) {
            HullCollisionShape hull = (HullCollisionShape)shape;
            volume = hull.scaledVolume();
        } else if (shape instanceof MultiSphere) {
            MultiSphere multiSphere = (MultiSphere)shape;
            volume = multiSphere.scaledVolume();
        } else if (shape instanceof SimplexCollisionShape) {
            SimplexCollisionShape simplex = (SimplexCollisionShape)shape;
            volume *= simplex.unscaledVolume();
        } else if (shape instanceof SphereCollisionShape) {
            SphereCollisionShape sphere = (SphereCollisionShape)shape;
            volume *= sphere.unscaledVolume();
        } else {
            logger.log(Level.SEVERE, "shape={0}", shape.getClass());
            throw new IllegalArgumentException("Shape must be closed!");
        }
        assert (volume >= 0.0f) : volume;
        return volume;
    }
}

