/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bullet.MultiBody;
import com.jme3.bullet.SoftBodyWorldInfo;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.Box2dShape;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.ConeCollisionShape;
import com.jme3.bullet.collision.shapes.Convex2dShape;
import com.jme3.bullet.collision.shapes.CylinderCollisionShape;
import com.jme3.bullet.collision.shapes.GImpactCollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.collision.shapes.MultiSphere;
import com.jme3.bullet.collision.shapes.PlaneCollisionShape;
import com.jme3.bullet.collision.shapes.SimplexCollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.joints.Anchor;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.New6Dof;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.joints.SoftAngularJoint;
import com.jme3.bullet.joints.SoftLinearJoint;
import com.jme3.bullet.joints.SoftPhysicsJoint;
import com.jme3.bullet.joints.motors.MotorParam;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.objects.infos.Aero;
import com.jme3.bullet.objects.infos.ConfigFlag;
import com.jme3.bullet.objects.infos.Sbcp;
import com.jme3.bullet.objects.infos.SoftBodyConfig;
import com.jme3.bullet.objects.infos.SoftBodyMaterial;
import com.jme3.material.Material;
import com.jme3.math.Plane;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.debug.Describer;
import jme3utilities.math.MyVector3f;
import jme3utilities.minie.MyControlP;
import jme3utilities.minie.MyShape;

public class PhysicsDescriber
extends Describer {
    public static final Logger logger = Logger.getLogger(PhysicsDescriber.class.getName());

    public String describe(CollisionShape shape) {
        Validate.nonNull((Object)shape, (String)"shape");
        StringBuilder result = new StringBuilder(80);
        String desc = MyShape.describeType(shape);
        result.append(desc);
        if (shape instanceof Box2dShape) {
            Vector3f he = ((Box2dShape)shape).getHalfExtents(null);
            desc = this.describeHalfExtents(he);
            result.append(desc);
        } else if (shape instanceof BoxCollisionShape) {
            Vector3f he = ((BoxCollisionShape)shape).getHalfExtents(null);
            desc = this.describeHalfExtents(he);
            result.append(desc);
        } else if (shape instanceof CapsuleCollisionShape) {
            CapsuleCollisionShape capsule = (CapsuleCollisionShape)shape;
            int axis = capsule.getAxis();
            desc = MyString.axisName((int)axis);
            result.append(desc);
            float height = capsule.getHeight();
            float radius = capsule.getRadius();
            desc = this.describeHeightAndRadius(height, radius);
            result.append(desc);
        } else if (shape instanceof CompoundCollisionShape) {
            CompoundCollisionShape compound = (CompoundCollisionShape)shape;
            int numChildren = compound.countChildren();
            desc = String.format("[%d]", numChildren);
            result.append(desc);
        } else if (shape instanceof ConeCollisionShape) {
            ConeCollisionShape cone = (ConeCollisionShape)shape;
            int axis = cone.getAxis();
            desc = MyString.axisName((int)axis);
            result.append(desc);
            float height = cone.getHeight();
            float radius = cone.getRadius();
            desc = this.describeHeightAndRadius(height, radius);
            result.append(desc);
        } else if (shape instanceof Convex2dShape) {
            CollisionShape child = ((Convex2dShape)shape).getBaseShape();
            desc = this.describe(child);
            result.append('[');
            result.append(desc);
            result.append(']');
        } else if (shape instanceof CylinderCollisionShape) {
            CylinderCollisionShape cylinder = (CylinderCollisionShape)shape;
            int axis = cylinder.getAxis();
            desc = MyString.axisName((int)axis);
            result.append(desc);
            Vector3f he = cylinder.getHalfExtents(null);
            desc = this.describeHalfExtents(he);
            result.append(desc);
        } else if (shape instanceof GImpactCollisionShape) {
            int numV = ((GImpactCollisionShape)shape).countMeshVertices();
            desc = String.format("[%d]", numV);
            result.append(desc);
        } else if (shape instanceof HeightfieldCollisionShape) {
            int numV = ((HeightfieldCollisionShape)shape).countMeshVertices();
            desc = String.format("[%d]", numV);
            result.append(desc);
        } else if (shape instanceof HullCollisionShape) {
            int numV = ((HullCollisionShape)shape).countHullVertices();
            desc = String.format("[%d]", numV);
            result.append(desc);
        } else if (shape instanceof MeshCollisionShape) {
            int numV = ((MeshCollisionShape)shape).countMeshVertices();
            desc = String.format("[%d]", numV);
            result.append(desc);
        } else if (shape instanceof MultiSphere) {
            MultiSphere multiSphere = (MultiSphere)shape;
            result.append(" r[");
            int numSpheres = multiSphere.countSpheres();
            for (int sphereIndex = 0; sphereIndex < numSpheres; ++sphereIndex) {
                if (sphereIndex > 0) {
                    result.append(' ');
                }
                float radius = multiSphere.getRadius(sphereIndex);
                result.append(MyString.describe((float)radius));
            }
            result.append(']');
        } else if (shape instanceof PlaneCollisionShape) {
            Plane plane = ((PlaneCollisionShape)shape).getPlane();
            result.append(" normal[");
            Vector3f normal = plane.getNormal();
            result.append(MyVector3f.describe((Vector3f)normal));
            result.append("] constant=");
            float constant = plane.getConstant();
            result.append(MyString.describe((float)constant));
        } else if (shape instanceof SimplexCollisionShape) {
            int numV = ((SimplexCollisionShape)shape).countMeshVertices();
            desc = String.format("[%d]", numV);
            result.append(desc);
        } else if (shape instanceof SphereCollisionShape) {
            SphereCollisionShape sphere = (SphereCollisionShape)shape;
            result.append(" r=");
            float radius = sphere.getRadius();
            result.append(MyString.describe((float)radius));
        } else {
            result.append('?');
        }
        if (shape instanceof HeightfieldCollisionShape || shape instanceof MeshCollisionShape) {
            result.append(' ');
            if (!shape.isContactFilterEnabled()) {
                result.append("UN");
            }
            result.append("filtered");
        }
        result.append(" marg=");
        float margin = shape.getMargin();
        result.append(MyString.describe((float)margin));
        return result.toString();
    }

    public String describe(PhysicsJoint joint) {
        StringBuilder result = new StringBuilder(40);
        String type = joint.getClass().getSimpleName();
        if (type.endsWith("Joint")) {
            type = MyString.removeSuffix((String)type, (String)"Joint");
        }
        result.append(type);
        if (!joint.isEnabled()) {
            result.append(" DISABLED");
        }
        return result.toString();
    }

    public String describe(RotationalLimitMotor motor) {
        StringBuilder result = new StringBuilder(80);
        if (motor.isEnableMotor()) {
            float angle = motor.getAngle();
            result.append(angle);
            float lo = motor.getLowerLimit();
            float hi = motor.getUpperLimit();
            if (hi < lo) {
                result.append(" unlimited");
            } else {
                result.append(" lo=");
                result.append(MyString.describe((float)lo));
                result.append(" hi=");
                result.append(MyString.describe((float)hi));
            }
            result.append(" tgtV=");
            float targetV = motor.getTargetVelocity();
            result.append(MyString.describe((float)targetV));
            result.append(" cfm=");
            float cfm = motor.getNormalCFM();
            result.append(MyString.describe((float)cfm));
            result.append(" damp=");
            float damping = motor.getDamping();
            result.append(MyString.describe((float)damping));
            result.append(" maxMF=");
            float maxMF = motor.getMaxMotorForce();
            result.append(MyString.describe((float)maxMF));
            if (hi >= lo) {
                result.append(" lim[cfm=");
                cfm = motor.getStopCFM();
                result.append(MyString.describe((float)cfm));
                result.append(" erp=");
                float erp = motor.getERP();
                result.append(MyString.describe((float)erp));
                result.append(" maxMF=");
                maxMF = motor.getMaxLimitForce();
                result.append(MyString.describe((float)maxMF));
                result.append(" rest=");
                float rest = motor.getRestitution();
                result.append(MyString.describe((float)rest));
                result.append(" soft=");
                float soft = motor.getLimitSoftness();
                result.append(MyString.describe((float)soft));
                result.append(']');
            }
        } else {
            result.append(" DISABLED");
        }
        return result.toString();
    }

    public String describe(SoftBodyMaterial material) {
        String result = String.format("Material stiffness[ang=%s lin=%s vol=%s]", MyString.describe((float)material.angularStiffness()), MyString.describe((float)material.linearStiffness()), MyString.describe((float)material.volumeStiffness()));
        return result;
    }

    public String describe(SoftBodyWorldInfo info) {
        StringBuilder result = new StringBuilder(40);
        result.append("SbwInfo grav[");
        Vector3f grav = info.copyGravity(null);
        String description = MyVector3f.describe((Vector3f)grav);
        result.append(description);
        result.append("] offset=");
        float offset = info.waterOffset();
        description = MyString.describe((float)offset);
        result.append(description);
        result.append(" norm[");
        Vector3f norm = info.copyWaterNormal(null);
        description = MyVector3f.describe((Vector3f)norm);
        result.append(description);
        result.append("] water=");
        float water = info.waterDensity();
        description = MyString.describe((float)water);
        result.append(description);
        result.append(" air=");
        float air = info.airDensity();
        description = MyString.describe((float)air);
        result.append(description);
        result.append(" maxDisp=");
        float maxDisp = info.maxDisplacement();
        description = MyString.describe((float)maxDisp);
        result.append(description);
        return result.toString();
    }

    public String describe(TranslationalLimitMotor motor, int axisIndex) {
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        StringBuilder result = new StringBuilder(80);
        Vector3f tmpVector = new Vector3f();
        if (motor.isEnabled(axisIndex)) {
            float offset = motor.getOffset(tmpVector).get(axisIndex);
            result.append(offset);
            float lo = motor.getLowerLimit(tmpVector).get(axisIndex);
            float hi = motor.getUpperLimit(tmpVector).get(axisIndex);
            if (hi < lo) {
                result.append(" unlimited");
            } else {
                result.append(" lo=");
                result.append(MyString.describe((float)lo));
                result.append(" hi=");
                result.append(MyString.describe((float)hi));
            }
            result.append(" tgtV=");
            float targetV = motor.getTargetVelocity(tmpVector).get(axisIndex);
            result.append(MyString.describe((float)targetV));
            result.append(" cfm=");
            float cfm = motor.getNormalCFM(tmpVector).get(axisIndex);
            result.append(MyString.describe((float)cfm));
            result.append(" damp=");
            float damping = motor.getDamping();
            result.append(MyString.describe((float)damping));
            result.append(" maxMF=");
            float maxMF = motor.getMaxMotorForce(tmpVector).get(axisIndex);
            result.append(MyString.describe((float)maxMF));
            if (hi >= lo) {
                result.append(" lim[cfm=");
                cfm = motor.getStopCFM(tmpVector).get(axisIndex);
                result.append(MyString.describe((float)cfm));
                result.append(" erp=");
                float erp = motor.getERP(tmpVector).get(axisIndex);
                result.append(MyString.describe((float)erp));
                result.append(" rest=");
                float rest = motor.getRestitution();
                result.append(MyString.describe((float)rest));
                result.append(" soft=");
                float softness = motor.getLimitSoftness();
                result.append(MyString.describe((float)softness));
                result.append(']');
            }
        } else {
            result.append(" DISABLED");
        }
        return result.toString();
    }

    public String describe(VehicleWheel wheel) {
        StringBuilder result = new StringBuilder(80);
        boolean isFront = wheel.isFrontWheel();
        if (isFront) {
            result.append("frnt");
        } else {
            result.append("rear");
        }
        result.append(" r=");
        float r = wheel.getRadius();
        result.append(MyString.describe((float)r));
        result.append(" loc[");
        Vector3f loc = wheel.getLocation(null);
        result.append(MyVector3f.describe((Vector3f)loc));
        result.append("] axleDir[");
        Vector3f axleDir = wheel.getAxle(null);
        result.append(MyVector3f.describe((Vector3f)axleDir));
        result.append("] fSlip=");
        float fSlip = wheel.getFrictionSlip();
        result.append(MyString.describe((float)fSlip));
        result.append(" rollInf=");
        float rollInf = wheel.getRollInfluence();
        result.append(MyString.describe((float)rollInf));
        result.append(" sus[damp[co=");
        float co = wheel.getWheelsDampingCompression();
        result.append(MyString.describe((float)co));
        result.append(" re=");
        float re = wheel.getWheelsDampingRelaxation();
        result.append(MyString.describe((float)re));
        result.append("] down[");
        Vector3f down = wheel.getDirection(null);
        result.append(MyVector3f.describe((Vector3f)down));
        result.append("] maxF=");
        float maxF = wheel.getMaxSuspensionForce();
        result.append(MyString.describe((float)maxF));
        result.append("] maxTrav=");
        float maxTrav = wheel.getMaxSuspensionTravelCm();
        result.append(MyString.describe((float)maxTrav));
        result.append(" restL=");
        float restL = wheel.getRestLength();
        result.append(MyString.describe((float)restL));
        result.append(" stiff=");
        float stiff = wheel.getSuspensionStiffness();
        result.append(MyString.describe((float)stiff));
        result.append(']');
        return result.toString();
    }

    public String describe1(SoftBodyConfig config) {
        StringBuilder result = new StringBuilder(120);
        result.append("Config aero=");
        Aero aeroModel = config.aerodynamics();
        String description = aeroModel.toString();
        result.append(description);
        result.append(" flags=");
        int collisionFlags = config.collisionFlags();
        description = ConfigFlag.describe(collisionFlags);
        result.append(description);
        description = String.format(" maxVolRatio=%s timeScale=%s velCorr=%s", MyString.describe((float)config.get(Sbcp.MaxVolumeRatio)), MyString.describe((float)config.get(Sbcp.TimeScale)), MyString.describe((float)config.get(Sbcp.VelocityCorrection)));
        result.append(description);
        description = String.format("  coef[damp=%s drag=%s fric=%s lift=%s pose=%s pres=%s volCons=%s]", MyString.describe((float)config.get(Sbcp.Damping)), MyString.describe((float)config.get(Sbcp.Drag)), MyString.describe((float)config.get(Sbcp.DynamicFriction)), MyString.describe((float)config.get(Sbcp.Lift)), MyString.describe((float)config.get(Sbcp.PoseMatching)), MyString.describe((float)config.get(Sbcp.Pressure)), MyString.describe((float)config.get(Sbcp.VolumeConservation)));
        result.append(description);
        return result.toString();
    }

    public String describe2(SoftBodyConfig config) {
        StringBuilder result = new StringBuilder(120);
        String description = String.format(" hardness[a=%s clk=%s clr=%s cls=%s k=%s r=%s s=%s]", MyString.describe((float)config.get(Sbcp.AnchorHardness)), MyString.describe((float)config.get(Sbcp.ClusterKineticHardness)), MyString.describe((float)config.get(Sbcp.ClusterRigidHardness)), MyString.describe((float)config.get(Sbcp.ClusterSoftHardness)), MyString.describe((float)config.get(Sbcp.KineticHardness)), MyString.describe((float)config.get(Sbcp.RigidHardness)), MyString.describe((float)config.get(Sbcp.SoftHardness)));
        result.append(description);
        description = String.format("  impSplit[clk=%s clr=%s cls=%s]", MyString.describe((float)config.get(Sbcp.ClusterKineticSplit)), MyString.describe((float)config.get(Sbcp.ClusterRigidSplit)), MyString.describe((float)config.get(Sbcp.ClusterSoftSplit)));
        result.append(description);
        description = String.format("  iters[cl=%d drift=%d pos=%d vel=%d]", config.clusterIterations(), config.driftIterations(), config.positionIterations(), config.velocityIterations());
        result.append(description);
        return result.toString();
    }

    public String describe2(VehicleWheel wheel) {
        StringBuilder result = new StringBuilder(120);
        result.append(" brake=");
        float brake = wheel.getBrake();
        result.append(MyString.describe((float)brake));
        result.append(" engF=");
        float engF = wheel.getEngineForce();
        result.append(MyString.describe((float)engF));
        result.append(" steer=");
        float steer = wheel.getSteerAngle();
        result.append(MyString.describe((float)steer));
        result.append(" susLen=");
        float susLen = wheel.getSuspensionLength();
        result.append(MyString.describe((float)susLen));
        return result.toString();
    }

    public String describeAngular(SixDofJoint joint) {
        StringBuilder result = new StringBuilder(80);
        result.append("angles[");
        Vector3f angles = joint.getAngles(new Vector3f());
        result.append(MyVector3f.describe((Vector3f)angles));
        result.append("] lo[");
        Vector3f lower = joint.getAngularLowerLimit(new Vector3f());
        result.append(MyVector3f.describe((Vector3f)lower));
        result.append("] hi[");
        Vector3f upper = joint.getAngularUpperLimit(new Vector3f());
        result.append(MyVector3f.describe((Vector3f)upper));
        result.append(']');
        return result.toString();
    }

    public String describeApplicationData(PhysicsCollisionObject pco) {
        Validate.nonNull((Object)pco, (String)"collision object");
        String result = "";
        Object aData = pco.getApplicationData();
        if (aData != null) {
            StringBuilder builder = new StringBuilder(64);
            builder.append(" aData=");
            this.appendObjectDescription(builder, aData);
            result = builder.toString();
        }
        return result;
    }

    public String describeDof(New6Dof constraint, int dofIndex) {
        float erp;
        float cfm;
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        StringBuilder result = new StringBuilder(80);
        float lo = constraint.get(MotorParam.LowerLimit, dofIndex);
        float hi = constraint.get(MotorParam.UpperLimit, dofIndex);
        if (hi < lo) {
            result.append(" free");
        } else if (hi == lo) {
            result.append(" locked=");
            result.append(MyString.describe((float)lo));
        } else {
            result.append(" lo=");
            result.append(MyString.describe((float)lo));
            result.append(" hi=");
            result.append(MyString.describe((float)hi));
        }
        result.append(" motor[");
        if (constraint.isMotorEnabled(dofIndex)) {
            if (constraint.isServoEnabled(dofIndex)) {
                result.append("servo target=");
                float target = constraint.get(MotorParam.ServoTarget, dofIndex);
                result.append(MyString.describe((float)target));
                result.append(" ");
            }
            result.append("tgtV=");
            float tgtV = constraint.get(MotorParam.TargetVelocity, dofIndex);
            result.append(MyString.describe((float)tgtV));
            result.append(" cfm=");
            cfm = constraint.get(MotorParam.MotorCfm, dofIndex);
            result.append(MyString.describe((float)cfm));
            result.append(" erp=");
            erp = constraint.get(MotorParam.MotorErp, dofIndex);
            result.append(MyString.describe((float)erp));
            result.append(" maxF=");
            float maxF = constraint.get(MotorParam.MaxMotorForce, dofIndex);
            result.append(MyString.describe((float)maxF));
        } else {
            result.append("off");
        }
        result.append(']');
        if (hi >= lo) {
            result.append(" lim[bounce=");
            float bounce = constraint.get(MotorParam.Bounce, dofIndex);
            result.append(MyString.describe((float)bounce));
            result.append(" cfm=");
            cfm = constraint.get(MotorParam.StopCfm, dofIndex);
            result.append(MyString.describe((float)cfm));
            result.append(" erp=");
            erp = constraint.get(MotorParam.StopErp, dofIndex);
            result.append(MyString.describe((float)erp));
            result.append(']');
        }
        result.append(" spring[");
        if (constraint.isSpringEnabled(dofIndex)) {
            result.append("eq=");
            float eq = constraint.get(MotorParam.Equilibrium, dofIndex);
            result.append(MyString.describe((float)eq));
            result.append(" stif=");
            float stif = constraint.get(MotorParam.Stiffness, dofIndex);
            result.append(MyString.describe((float)stif));
            result.append(" damp=");
            float damp = constraint.get(MotorParam.Damping, dofIndex);
            result.append(MyString.describe((float)damp));
        } else {
            result.append("off");
        }
        result.append(']');
        return result.toString();
    }

    String describeGroups(MultiBody multiBody) {
        int groupMask;
        StringBuilder result = new StringBuilder(40);
        int group = multiBody.collisionGroup();
        if (group != 1) {
            result.append(" group=0x");
            result.append(Integer.toString(group, 16));
        }
        if ((groupMask = multiBody.collideWithGroups()) != 1) {
            result.append(" gMask=0x");
            result.append(Integer.toString(groupMask, 16));
        }
        return result.toString();
    }

    public String describeGroups(PhysicsCollisionObject pco) {
        int groupMask;
        StringBuilder result = new StringBuilder(40);
        int group = pco.getCollisionGroup();
        if (group != 1) {
            result.append(" group=0x");
            result.append(Integer.toString(group, 16));
        }
        if ((groupMask = pco.getCollideWithGroups()) != 1) {
            result.append(" gMask=0x");
            result.append(Integer.toString(groupMask, 16));
        }
        return result.toString();
    }

    public String describeJointInBody(PhysicsJoint joint, PhysicsBody body, boolean forceId) {
        Constraint constraint;
        PhysicsBody otherBody;
        StringBuilder result = new StringBuilder(80);
        String desc = this.describe(joint);
        result.append(desc);
        Vector3f pivot = null;
        if (joint.getBody(JointEnd.A) == body) {
            otherBody = joint.getBody(JointEnd.B);
            if (joint instanceof Constraint) {
                constraint = (Constraint)joint;
                pivot = constraint.getPivotA(null);
            }
        } else {
            assert (joint.getBody(JointEnd.B) == body);
            otherBody = joint.getBody(JointEnd.A);
            if (joint instanceof Constraint) {
                constraint = (Constraint)joint;
                pivot = constraint.getPivotB(null);
            }
        }
        if (otherBody == null) {
            result.append(" single-ended");
        } else {
            result.append(" to:");
            this.appendPco(result, otherBody, forceId);
        }
        if (pivot != null) {
            result.append(" piv[");
            result.append(MyVector3f.describe((Vector3f)pivot));
            result.append(']');
        } else if (joint instanceof SoftAngularJoint) {
            SoftAngularJoint saj = (SoftAngularJoint)joint;
            result.append(" axis[");
            Vector3f axis = saj.copyAxis(null);
            result.append(MyVector3f.describe((Vector3f)axis));
            result.append(']');
        } else if (joint instanceof SoftLinearJoint) {
            SoftLinearJoint slj = (SoftLinearJoint)joint;
            result.append(" loc[");
            Vector3f loc = slj.copyLocation(null);
            result.append(MyVector3f.describe((Vector3f)loc));
            result.append(']');
        }
        return result.toString();
    }

    public String describeJointInSpace(PhysicsJoint joint, boolean forceIds) {
        String result = joint instanceof Anchor ? this.describeAnchorInSpace((Anchor)joint, forceIds) : (joint instanceof Constraint ? this.describeConstraintInSpace((Constraint)joint, forceIds) : this.describeSoftJointInSpace((SoftPhysicsJoint)joint, forceIds));
        return result;
    }

    public String describeLinear(SixDofJoint joint) {
        StringBuilder result = new StringBuilder(80);
        result.append("offset[");
        Vector3f offset = joint.getPivotOffset(new Vector3f());
        result.append(MyVector3f.describe((Vector3f)offset));
        result.append("] lo[");
        Vector3f lo = joint.getLinearLowerLimit(new Vector3f());
        result.append(MyVector3f.describe((Vector3f)lo));
        result.append("] hi[");
        Vector3f hi = joint.getLinearUpperLimit(new Vector3f());
        result.append(MyVector3f.describe((Vector3f)hi));
        result.append(']');
        return result.toString();
    }

    String describePco(PhysicsCollisionObject pco, boolean forceId) {
        StringBuilder result = new StringBuilder(80);
        this.appendPco(result, pco, forceId);
        return result.toString();
    }

    public String describeUser(PhysicsCollisionObject pco) {
        Validate.nonNull((Object)pco, (String)"collision object");
        String result = "";
        Object user = pco.getUserObject();
        if (user != null) {
            StringBuilder builder = new StringBuilder(64);
            builder.append(" user=");
            this.appendObjectDescription(builder, user);
            result = builder.toString();
        }
        return result;
    }

    public PhysicsDescriber clone() throws CloneNotSupportedException {
        PhysicsDescriber clone = (PhysicsDescriber)super.clone();
        return clone;
    }

    protected String describe(Control control) {
        Validate.nonNull((Object)control, (String)"control");
        String result = MyControlP.describe(control);
        return result;
    }

    protected boolean isControlEnabled(Control control) {
        Validate.nonNull((Object)control, (String)"control");
        boolean result = !MyControlP.canDisable(control) || MyControlP.isEnabled(control);
        return result;
    }

    private void appendObjectDescription(StringBuilder builder, Object subject) {
        String desc;
        String className = subject.getClass().getSimpleName();
        if (subject instanceof Material) {
            builder.append(className);
            desc = ((Material)subject).getName();
        } else if (subject instanceof PhysicsLink) {
            builder.append(className);
            desc = ((PhysicsLink)subject).boneName();
        } else if (subject instanceof Spatial) {
            builder.append(className);
            desc = ((Spatial)subject).getName();
        } else if (subject instanceof String) {
            builder.append("String");
            desc = (String)subject;
        } else {
            desc = subject.toString();
        }
        if (desc != null) {
            if (desc.length() > 50) {
                desc = desc.substring(0, 47) + "...";
            }
            builder.append(MyString.quote((CharSequence)desc));
        }
    }

    private void appendPco(StringBuilder builder, PhysicsCollisionObject pco, boolean forceId) {
        if (pco.getApplicationData() == null && pco.getUserObject() == null) {
            String desc = pco.toString();
            builder.append(desc);
        } else {
            String desc;
            builder.append('[');
            if (forceId) {
                desc = pco.toString();
                builder.append(desc);
            } else {
                desc = pco.getClass().getSimpleName();
                desc = desc.replace("Control", "C");
                desc = desc.replace("Physics", "");
                desc = desc.replace("Object", "");
                builder.append(desc);
            }
            desc = this.describeApplicationData(pco);
            builder.append(desc);
            desc = this.describeUser(pco);
            builder.append(desc);
            builder.append(']');
        }
        if (!pco.isInWorld()) {
            builder.append("_NOT_IN_WORLD");
        }
    }

    private String describeAnchorInSpace(Anchor anchor, boolean forceIds) {
        StringBuilder result = new StringBuilder(80);
        String desc = this.describe(anchor);
        result.append(desc);
        result.append(" a=");
        PhysicsSoftBody a = anchor.getSoftBody();
        this.appendPco(result, a, forceIds);
        result.append(" [");
        int nodeIndex = anchor.nodeIndex();
        result.append(nodeIndex);
        result.append(']');
        result.append(" b=");
        PhysicsRigidBody b = anchor.getRigidBody();
        this.appendPco(result, b, forceIds);
        result.append(" piv[");
        Vector3f piv = anchor.copyPivot(null);
        result.append(MyVector3f.describe((Vector3f)piv));
        result.append(']');
        result.append(" infl=");
        float infl = anchor.influence();
        result.append(MyString.describe((float)infl));
        return result.toString();
    }

    private String describeConstraintInSpace(Constraint constraint, boolean forceIds) {
        float bit;
        PhysicsRigidBody b;
        int iters;
        StringBuilder result = new StringBuilder(80);
        String desc = this.describe(constraint);
        result.append(desc);
        if (constraint.countEnds() == 2) {
            boolean endsCollide = constraint.isCollisionBetweenLinkedBodies();
            if (endsCollide) {
                result.append(" collide");
            } else {
                result.append(" NOcollide");
            }
        }
        if ((iters = constraint.getOverrideIterations()) != -1) {
            result.append(" iters=");
            result.append(iters);
        }
        int numDyn = 0;
        PhysicsRigidBody a = constraint.getBodyA();
        if (a != null) {
            result.append(" a:");
            this.appendPco(result, a, forceIds);
            if (a.isDynamic()) {
                ++numDyn;
            }
        }
        if ((b = constraint.getBodyB()) != null) {
            result.append(" b:");
            this.appendPco(result, b, forceIds);
            if (b.isDynamic()) {
                ++numDyn;
            }
        }
        if (numDyn == 0) {
            result.append(" NO_DYNAMIC_END");
        }
        if (constraint.isFeedback()) {
            float impulse = constraint.getAppliedImpulse();
            result.append(" impulse=");
            result.append(impulse);
        }
        if ((bit = constraint.getBreakingImpulseThreshold()) != Float.MAX_VALUE) {
            result.append(" bit=");
            result.append(MyString.describe((float)bit));
        }
        return result.toString();
    }

    private String describeHeightAndRadius(float height, float radius) {
        String hText = MyString.describe((float)height);
        String rText = MyString.describe((float)radius);
        String result = String.format(" h=%s r=%s", hText, rText);
        return result;
    }

    private String describeSoftJointInSpace(SoftPhysicsJoint joint, boolean forceIds) {
        StringBuilder result = new StringBuilder(80);
        String desc = this.describe(joint);
        result.append(desc);
        PhysicsSoftBody a = joint.getSoftBodyA();
        result.append(" a=");
        this.appendPco(result, a, forceIds);
        result.append(" [");
        int clusterIndex = joint.clusterIndexA();
        result.append(clusterIndex);
        result.append(']');
        PhysicsBody b = joint.getBody(JointEnd.B);
        result.append(" b=");
        this.appendPco(result, b, forceIds);
        if (joint.isSoftSoft()) {
            result.append(" [");
            clusterIndex = joint.clusterIndexB();
            result.append(clusterIndex);
            result.append(']');
        }
        result.append(" cfm=");
        float cfm = joint.getCFM();
        result.append(MyString.describe((float)cfm));
        result.append(" erp=");
        float erp = joint.getERP();
        result.append(MyString.describe((float)erp));
        result.append(" split=");
        float split = joint.getSplit();
        result.append(MyString.describe((float)split));
        return result.toString();
    }
}

