/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import java.util.logging.Logger;

public class UserFilter
implements BulletDebugAppState.DebugAppStateFilter {
    private static final Logger logger = Logger.getLogger(UserFilter.class.getName());
    private final Object userObject;

    public UserFilter(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public boolean displayObject(Object physicsObject) {
        boolean result = false;
        if (physicsObject instanceof PhysicsCollisionObject) {
            PhysicsCollisionObject pco = (PhysicsCollisionObject)physicsObject;
            if (pco.getUserObject() == this.userObject) {
                result = true;
            }
        } else if (physicsObject instanceof PhysicsJoint) {
            PhysicsJoint joint = (PhysicsJoint)physicsObject;
            PhysicsBody a = joint.getBody(JointEnd.A);
            if (a != null && a.getUserObject() == this.userObject) {
                result = true;
            } else {
                PhysicsBody b = joint.getBody(JointEnd.B);
                if (b != null && b.getUserObject() == this.userObject) {
                    result = true;
                }
            }
        }
        return result;
    }
}

