/*
 * Decompiled with CFR 0.152.
 */
package vhacd;

import com.jme3.bullet.NativePhysicsObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import jme3utilities.Validate;
import vhacd.ACDMode;

public class VHACDParameters
extends NativePhysicsObject
implements Cloneable {
    public static final Logger logger = Logger.getLogger(VHACDParameters.class.getName());
    private boolean debug;

    public VHACDParameters() {
        long objectId = VHACDParameters.create();
        super.setNativeId(objectId);
        VHACDParameters.setConcavity(objectId, 0.0025);
        VHACDParameters.setMaxNumVerticesPerCH(objectId, 32);
    }

    public void fromInputStream(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        this.setMaxConcavity(dis.readDouble());
        this.setAlpha(dis.readDouble());
        this.setBeta(dis.readDouble());
        this.setMinVolumePerHull(dis.readDouble());
        this.setVoxelResolution(dis.readInt());
        this.setMaxVerticesPerHull(dis.readInt());
        this.setPlaneDownSampling(dis.readInt());
        this.setConvexHullDownSampling(dis.readInt());
        this.setPCA(dis.readInt() != 0);
        this.setACDMode(ACDMode.values()[dis.readInt()]);
        this.setConvexHullApproximation(dis.readInt());
        this.setOclAcceleration(dis.readInt());
    }

    public ACDMode getACDMode() {
        long objectId = this.nativeId();
        int ordinal = VHACDParameters.getMode(objectId);
        ACDMode result = ACDMode.values()[ordinal];
        return result;
    }

    public double getAlpha() {
        long objectId = this.nativeId();
        double result = VHACDParameters.getAlpha(objectId);
        return result;
    }

    public double getBeta() {
        long objectId = this.nativeId();
        double result = VHACDParameters.getBeta(objectId);
        return result;
    }

    public int getConvexHullDownSampling() {
        long objectId = this.nativeId();
        int result = VHACDParameters.getConvexhullDownsampling(objectId);
        return result;
    }

    public boolean getDebugEnabled() {
        return this.debug;
    }

    public double getMaxConcavity() {
        long objectId = this.nativeId();
        double result = VHACDParameters.getConcavity(objectId);
        return result;
    }

    public int getMaxVerticesPerHull() {
        long objectId = this.nativeId();
        int result = VHACDParameters.getMaxNumVerticesPerCH(objectId);
        return result;
    }

    public double getMinVolumePerHull() {
        long objectId = this.nativeId();
        double result = VHACDParameters.getMinVolumePerCH(objectId);
        return result;
    }

    public boolean getPCA() {
        long objectId = this.nativeId();
        boolean result = VHACDParameters.getPca(objectId);
        return result;
    }

    public int getPlaneDownSampling() {
        long objectId = this.nativeId();
        int result = VHACDParameters.getPlaneDownsampling(objectId);
        return result;
    }

    public int getVoxelResolution() {
        long objectId = this.nativeId();
        int result = VHACDParameters.getResolution(objectId);
        return result;
    }

    public void setACDMode(ACDMode mode) {
        long objectId = this.nativeId();
        VHACDParameters.setMode(objectId, mode.ordinal());
    }

    public void setAlpha(double v) {
        Validate.fraction((double)v, (String)"alpha");
        long objectId = this.nativeId();
        VHACDParameters.setAlpha(objectId, v);
    }

    public void setBeta(double v) {
        Validate.fraction((double)v, (String)"beta");
        long objectId = this.nativeId();
        VHACDParameters.setBeta(objectId, v);
    }

    public void setConvexHullDownSampling(int v) {
        Validate.inRange((int)v, (String)"precision", (int)1, (int)16);
        long objectId = this.nativeId();
        VHACDParameters.setConvexhullDownsampling(objectId, v);
    }

    public void setDebugEnabled(boolean d) {
        this.debug = d;
    }

    public void setMaxConcavity(double v) {
        Validate.fraction((double)v, (String)"depth");
        long objectId = this.nativeId();
        VHACDParameters.setConcavity(objectId, v);
    }

    public void setMaxVerticesPerHull(int v) {
        Validate.inRange((int)v, (String)"max vertices", (int)4, (int)1024);
        long objectId = this.nativeId();
        VHACDParameters.setMaxNumVerticesPerCH(objectId, v);
    }

    public void setMinVolumePerHull(double v) {
        Validate.inRange((double)v, (String)"min volume", (double)0.0, (double)0.01);
        long objectId = this.nativeId();
        VHACDParameters.setMinVolumePerCH(objectId, v);
    }

    public void setPCA(boolean v) {
        long objectId = this.nativeId();
        VHACDParameters.setPca(objectId, v);
    }

    public void setPlaneDownSampling(int v) {
        Validate.inRange((int)v, (String)"granularity", (int)1, (int)16);
        long objectId = this.nativeId();
        VHACDParameters.setPlaneDownsampling(objectId, v);
    }

    public void setVoxelResolution(int v) {
        Validate.inRange((int)v, (String)"maxVoxels", (int)10000, (int)64000000);
        long objectId = this.nativeId();
        VHACDParameters.setResolution(objectId, v);
    }

    public void toOutputStream(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeDouble(this.getMaxConcavity());
        dos.writeDouble(this.getAlpha());
        dos.writeDouble(this.getBeta());
        dos.writeDouble(this.getMinVolumePerHull());
        dos.writeInt(this.getVoxelResolution());
        dos.writeInt(this.getMaxVerticesPerHull());
        dos.writeInt(this.getPlaneDownSampling());
        dos.writeInt(this.getConvexHullDownSampling());
        dos.writeInt(this.getPCA() ? 1 : 0);
        dos.writeInt(this.getACDMode().ordinal());
        dos.writeInt(this.getConvexHullApproximation());
        dos.writeInt(this.getOclAcceleration());
    }

    public VHACDParameters clone() {
        try {
            VHACDParameters clone = (VHACDParameters)super.clone();
            long objectId = VHACDParameters.create();
            clone.reassignNativeId(objectId);
            clone.setACDMode(this.getACDMode());
            clone.setAlpha(this.getAlpha());
            clone.setBeta(this.getBeta());
            clone.setConvexHullApproximation(this.getConvexHullApproximation());
            clone.setConvexHullDownSampling(this.getConvexHullDownSampling());
            clone.setMaxConcavity(this.getMaxConcavity());
            clone.setMaxVerticesPerHull(this.getMaxVerticesPerHull());
            clone.setMinVolumePerHull(this.getMinVolumePerHull());
            clone.setOclAcceleration(this.getOclAcceleration());
            clone.setPCA(this.getPCA());
            clone.setPlaneDownSampling(this.getPlaneDownSampling());
            clone.setVoxelResolution(this.getVoxelResolution());
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            VHACDParameters other = (VHACDParameters)otherObject;
            int cha = other.getConvexHullApproximation();
            int chds = other.getConvexHullDownSampling();
            double maxConcavity = other.getMaxConcavity();
            double mvph = other.getMinVolumePerHull();
            result = this.getACDMode() == other.getACDMode() && Double.compare(this.getAlpha(), other.getAlpha()) == 0 && Double.compare(this.getBeta(), other.getBeta()) == 0 && this.getConvexHullApproximation() == cha && this.getConvexHullDownSampling() == chds && this.getDebugEnabled() == other.getDebugEnabled() && Double.compare(this.getMaxConcavity(), maxConcavity) == 0 && this.getMaxVerticesPerHull() == other.getMaxVerticesPerHull() && Double.compare(this.getMinVolumePerHull(), mvph) == 0 && this.getOclAcceleration() == other.getOclAcceleration() && this.getPCA() == other.getPCA() && this.getPlaneDownSampling() == other.getPlaneDownSampling() && this.getVoxelResolution() == other.getVoxelResolution();
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + (this.debug ? 1 : 0);
        hash = 83 * hash + this.getACDMode().hashCode();
        hash = 83 * hash + Double.hashCode(this.getAlpha());
        hash = 83 * hash + Double.hashCode(this.getBeta());
        hash = 83 * hash + this.getConvexHullApproximation();
        hash = 83 * hash + this.getConvexHullDownSampling();
        hash = 83 * hash + Double.hashCode(this.getMaxConcavity());
        hash = 83 * hash + this.getMaxVerticesPerHull();
        hash = 83 * hash + Double.hashCode(this.getMinVolumePerHull());
        hash = 83 * hash + this.getOclAcceleration();
        hash = 83 * hash + Boolean.hashCode(this.getPCA());
        hash = 83 * hash + this.getPlaneDownSampling();
        hash = 83 * hash + this.getVoxelResolution();
        return hash;
    }

    private static void freeNativeObject(long objectId) {
        assert (objectId != 0L);
        VHACDParameters.finalizeNative(objectId);
    }

    private int getConvexHullApproximation() {
        long objectId = this.nativeId();
        return VHACDParameters.getConvexhullApproximation(objectId);
    }

    private int getOclAcceleration() {
        long objectId = this.nativeId();
        return VHACDParameters.getOclAcceleration(objectId);
    }

    private void setConvexHullApproximation(int value) {
        long objectId = this.nativeId();
        VHACDParameters.setConvexhullApproximation(objectId, value);
    }

    private void setOclAcceleration(int value) {
        long objectId = this.nativeId();
        VHACDParameters.setOclAcceleration(objectId, value);
    }

    private static native long create();

    private static native void finalizeNative(long var0);

    private static native double getAlpha(long var0);

    private static native double getBeta(long var0);

    private static native double getConcavity(long var0);

    private static native int getConvexhullApproximation(long var0);

    private static native int getConvexhullDownsampling(long var0);

    private static native int getMaxNumVerticesPerCH(long var0);

    private static native double getMinVolumePerCH(long var0);

    private static native int getMode(long var0);

    private static native int getOclAcceleration(long var0);

    private static native boolean getPca(long var0);

    private static native int getPlaneDownsampling(long var0);

    private static native int getResolution(long var0);

    private static native void setAlpha(long var0, double var2);

    private static native void setBeta(long var0, double var2);

    private static native void setConcavity(long var0, double var2);

    private static native void setConvexhullApproximation(long var0, int var2);

    private static native void setConvexhullDownsampling(long var0, int var2);

    private static native void setMaxNumVerticesPerCH(long var0, int var2);

    private static native void setMinVolumePerCH(long var0, double var2);

    private static native void setMode(long var0, int var2);

    private static native void setOclAcceleration(long var0, int var2);

    private static native void setPca(long var0, boolean var2);

    private static native void setPlaneDownsampling(long var0, int var2);

    private static native void setResolution(long var0, int var2);
}

