/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.bullet.CollisionConfiguration;
import com.jme3.bullet.CollisionSpace;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.SolverType;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.DebugConfiguration;
import com.jme3.bullet.debug.DebugInitListener;
import com.jme3.bullet.util.NativeLibrary;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class BulletAppState
extends AbstractAppState
implements PhysicsTickListener {
    public static final Logger logger = Logger.getLogger(BulletAppState.class.getName());
    private AppStateManager stateManager;
    private volatile boolean isRunning = false;
    private PhysicsSpace.BroadphaseType broadphaseType = PhysicsSpace.BroadphaseType.DBVT;
    private BulletDebugAppState debugAppState;
    private final Callable<Boolean> parallelPhysicsUpdate = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            PhysicsSpace pSpace = BulletAppState.this.debugConfig.getSpace();
            pSpace.update(BulletAppState.this.isEnabled() ? BulletAppState.this.tpf * BulletAppState.this.speed : 0.0f);
            return true;
        }
    };
    private CollisionConfiguration collisionConfiguration = new CollisionConfiguration();
    private final DebugConfiguration debugConfig = new DebugConfiguration();
    private float speed = 1.0f;
    private float tpf;
    private Future physicsFuture;
    private int numSolvers = NativeLibrary.countThreads();
    private ScheduledThreadPoolExecutor executor;
    private SolverType solverType = SolverType.SI;
    private ThreadingType threadingType = ThreadingType.SEQUENTIAL;
    private final Vector3f worldMax = new Vector3f(10000.0f, 10000.0f, 10000.0f);
    private final Vector3f worldMin = new Vector3f(-10000.0f, -10000.0f, -10000.0f);

    public BulletAppState() {
    }

    public BulletAppState(PhysicsSpace.BroadphaseType broadphaseType) {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), broadphaseType);
    }

    public BulletAppState(Vector3f worldMin, Vector3f worldMax) {
        this(worldMin, worldMax, PhysicsSpace.BroadphaseType.AXIS_SWEEP_3);
    }

    public BulletAppState(Vector3f worldMin, Vector3f worldMax, PhysicsSpace.BroadphaseType broadphaseType) {
        Validate.finite((Vector3f)worldMin, (String)"world min");
        Validate.finite((Vector3f)worldMax, (String)"world max");
        Validate.nonNull((Object)((Object)broadphaseType), (String)"broadphase type");
        this.worldMin.set(worldMin);
        this.worldMax.set(worldMax);
        this.broadphaseType = broadphaseType;
    }

    public int countSolvers() {
        return this.numSolvers;
    }

    public float debugAxisLength() {
        float result = this.debugConfig.axisArrowLength();
        return result;
    }

    public float debugAxisLineWidth() {
        float result = this.debugConfig.axisLineWidth();
        return result;
    }

    public PhysicsSpace.BroadphaseType getBroadphaseType() {
        return this.broadphaseType;
    }

    public CollisionConfiguration getCollisionConfiguration() {
        assert (this.collisionConfiguration != null);
        return this.collisionConfiguration;
    }

    public Camera getDebugCamera() {
        Camera result = this.debugConfig.getCamera();
        return result;
    }

    public PhysicsSpace getPhysicsSpace() {
        PhysicsSpace result = this.debugConfig.getSpace();
        return result;
    }

    public SolverType getSolverType() {
        assert (this.solverType != null);
        return this.solverType;
    }

    public float getSpeed() {
        assert (this.speed >= 0.0f) : this.speed;
        return this.speed;
    }

    public ThreadingType getThreadingType() {
        assert (this.threadingType != null);
        return this.threadingType;
    }

    public boolean isDebugEnabled() {
        boolean result = this.debugConfig.isEnabled();
        return result;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setBroadphaseType(PhysicsSpace.BroadphaseType broadphaseType) {
        Validate.nonNull((Object)((Object)broadphaseType), (String)"broadphase type");
        assert (!this.isRunning);
        this.broadphaseType = broadphaseType;
    }

    public void setCollisionConfiguration(CollisionConfiguration configuration) {
        Validate.nonNull((Object)configuration, (String)"configuration");
        assert (!this.isRunning);
        this.collisionConfiguration = configuration;
    }

    public void setDebugAngularVelocityFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        if (this.debugAppState == null) {
            this.debugConfig.setAngularVelocityFilter(filter);
        } else {
            this.debugAppState.setAngularVelocityFilter(filter);
        }
    }

    public void setDebugAxisLength(float length) {
        Validate.nonNegative((float)length, (String)"length");
        this.debugConfig.setAxisArrowLength(length);
    }

    public void setDebugAxisLineWidth(float width) {
        Validate.inRange((float)width, (String)"width", (float)0.0f, (float)Float.MAX_VALUE);
        this.debugConfig.setAxisLineWidth(width);
    }

    public void setDebugBoundingBoxFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        if (this.debugAppState == null) {
            this.debugConfig.setBoundingBoxFilter(filter);
        } else {
            this.debugAppState.setBoundingBoxFilter(filter);
        }
    }

    public void setDebugCamera(Camera camera) {
        this.debugConfig.setCamera(camera);
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugConfig.setEnabled(debugEnabled);
    }

    public void setDebugFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.debugConfig.setFilter(filter);
    }

    public void setDebugGravityVectorFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        if (this.debugAppState == null) {
            this.debugConfig.setGravityVectorFilter(filter);
        } else {
            this.debugAppState.setGravityVectorFilter(filter);
        }
    }

    public void setDebugInitListener(DebugInitListener listener) {
        this.debugConfig.setInitListener(listener);
    }

    public void setDebugJointLineWidth(float width) {
        Validate.inRange((float)width, (String)"width", (float)1.0f, (float)Float.MAX_VALUE);
        if (this.debugAppState == null) {
            this.debugConfig.setJointLineWidth(width);
        } else {
            this.debugAppState.setJointLineWidth(width);
        }
    }

    public void setDebugShadowMode(RenderQueue.ShadowMode mode) {
        Validate.nonNull((Object)mode, (String)"mode");
        if (this.debugAppState != null) {
            Node node = this.debugAppState.getRootNode();
            node.setShadowMode(mode);
        }
        this.debugConfig.setShadowMode(mode);
    }

    public void setDebugSweptSphereFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        if (this.debugAppState == null) {
            this.debugConfig.setSweptSphereFilter(filter);
        } else {
            this.debugAppState.setSweptSphereFilter(filter);
        }
    }

    public void setDebugVelocityVectorFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        if (this.debugAppState == null) {
            this.debugConfig.setVelocityVectorFilter(filter);
        } else {
            this.debugAppState.setVelocityVectorFilter(filter);
        }
    }

    public void setDebugViewPorts(ViewPort ... viewPorts) {
        Validate.nonNull((Object)viewPorts, (String)"view ports");
        this.debugConfig.setViewPorts(viewPorts);
    }

    public void setNumSolvers(int numSolvers) {
        Validate.inRange((int)numSolvers, (String)"number of solvers", (int)1, (int)64);
        assert (!this.isRunning());
        this.numSolvers = numSolvers;
    }

    public void setSolverType(SolverType solver) {
        Validate.nonNull((Object)((Object)solver), (String)"solver");
        assert (!this.isRunning());
        this.solverType = solver;
    }

    public void setSpeed(float speed) {
        Validate.nonNegative((float)speed, (String)"speed");
        this.speed = speed;
    }

    public void setThreadingType(ThreadingType threadingType) {
        assert (!this.isRunning);
        this.threadingType = threadingType;
    }

    public void setTransformSpatial(Spatial spatial) {
        this.debugConfig.setTransformSpatial(spatial);
    }

    public void setWorldMax(Vector3f worldMax) {
        Validate.finite((Vector3f)this.worldMin, (String)"world max");
        assert (!this.isRunning);
        this.worldMax.set(worldMax);
    }

    public void setWorldMin(Vector3f worldMin) {
        Validate.finite((Vector3f)worldMin, (String)"world min");
        assert (!this.isRunning);
        this.worldMin.set(worldMin);
    }

    public void startPhysics() {
        if (this.isRunning) {
            return;
        }
        switch (this.threadingType) {
            case PARALLEL: {
                boolean success = this.startPhysicsOnExecutor();
                assert (success);
                PhysicsSpace pSpace = this.debugConfig.getSpace();
                assert (pSpace != null);
                break;
            }
            case SEQUENTIAL: {
                PhysicsSpace pSpace = this.createPhysicsSpace(this.worldMin, this.worldMax, this.broadphaseType);
                this.debugConfig.setSpace(pSpace);
                pSpace.addTickListener(this);
                break;
            }
            default: {
                throw new IllegalStateException(this.threadingType.toString());
            }
        }
        this.setRunning(true);
    }

    public void stopPhysics() {
        if (!this.isRunning) {
            return;
        }
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        PhysicsSpace pSpace = this.debugConfig.getSpace();
        pSpace.removeTickListener(this);
        this.setPhysicsSpace(null);
        this.setRunning(false);
    }

    public Vector3f worldMax() {
        Vector3f result = this.worldMax.clone();
        return result;
    }

    public Vector3f worldMin() {
        Vector3f result = this.worldMin.clone();
        return result;
    }

    protected BulletDebugAppState createDebugAppState() {
        BulletDebugAppState appState = new BulletDebugAppState(this.debugConfig);
        return appState;
    }

    protected PhysicsSpace createPhysicsSpace(Vector3f min, Vector3f max, PhysicsSpace.BroadphaseType type) {
        PhysicsSpace result;
        if (this.solverType == SolverType.SI) {
            result = new PhysicsSpace(min, max, type, this.numSolvers, this.collisionConfiguration);
        } else if (this.numSolvers == 1) {
            result = new PhysicsSpace(min, max, type, this.solverType, this.collisionConfiguration);
        } else {
            String message = String.format("num=%d, type=%s", new Object[]{this.numSolvers, this.solverType});
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    protected BulletDebugAppState getDebugAppState() {
        return this.debugAppState;
    }

    protected DebugConfiguration getDebugConfiguration() {
        assert (this.debugConfig != null);
        return this.debugConfig;
    }

    protected void setPhysicsSpace(PhysicsSpace newSpace) {
        this.debugConfig.setSpace(newSpace);
    }

    protected void setRunning(boolean desiredSetting) {
        this.isRunning = desiredSetting;
    }

    protected boolean startPhysicsOnExecutor() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = new ScheduledThreadPoolExecutor(1);
        final BulletAppState appState = this;
        Callable<Boolean> call = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                PhysicsSpace pSpace = BulletAppState.this.createPhysicsSpace(BulletAppState.this.worldMin, BulletAppState.this.worldMax, BulletAppState.this.broadphaseType);
                BulletAppState.this.debugConfig.setSpace(pSpace);
                pSpace.addTickListener(appState);
                return true;
            }
        };
        try {
            boolean success = this.executor.submit(call).get();
            return success;
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.log(Level.SEVERE, null, exception);
            return false;
        }
    }

    public void cleanup() {
        super.cleanup();
        if (this.debugAppState != null) {
            this.stateManager.detach((AppState)this.debugAppState);
            this.debugAppState = null;
        }
        this.stopPhysics();
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.debugConfig.initialize(app);
        this.startPhysics();
    }

    public void postRender() {
        super.postRender();
        if (this.physicsFuture != null) {
            try {
                this.physicsFuture.get();
                this.physicsFuture = null;
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public void render(RenderManager rm) {
        assert (this.isRunning);
        super.render(rm);
        if (this.threadingType == ThreadingType.PARALLEL) {
            this.physicsFuture = this.executor.submit(this.parallelPhysicsUpdate);
        } else if (this.threadingType == ThreadingType.SEQUENTIAL) {
            PhysicsSpace pSpace = this.debugConfig.getSpace();
            pSpace.update(this.isEnabled() ? this.tpf * this.speed : 0.0f);
        }
    }

    public void stateAttached(AppStateManager stateManager) {
        super.stateAttached(stateManager);
        this.stateManager = stateManager;
        if (!this.isRunning) {
            this.startPhysics();
        }
        if (this.threadingType == ThreadingType.PARALLEL) {
            PhysicsSpace pSpace = this.debugConfig.getSpace();
            CollisionSpace.setLocalThreadPhysicsSpace(pSpace);
        }
    }

    public void update(float tpf) {
        super.update(tpf);
        this.tpf = tpf;
        boolean enable = this.debugConfig.isEnabled();
        if (enable && this.debugAppState == null) {
            this.debugAppState = this.createDebugAppState();
            this.stateManager.attach((AppState)this.debugAppState);
        } else if (!enable && this.debugAppState != null) {
            this.stateManager.detach((AppState)this.debugAppState);
            this.debugAppState = null;
        }
        PhysicsSpace pSpace = this.debugConfig.getSpace();
        pSpace.distributeEvents();
    }

    @Override
    public void physicsTick(PhysicsSpace space, float timeStep) {
    }

    @Override
    public void prePhysicsTick(PhysicsSpace space, float timeStep) {
    }

    public static enum ThreadingType {
        SEQUENTIAL,
        PARALLEL;

    }
}

