/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.NativePhysicsObject;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class CollisionConfiguration
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(CollisionConfiguration.class.getName());

    public CollisionConfiguration() {
        this(4096, 1);
    }

    public CollisionConfiguration(int maxManifolds, int penetrationDepthSolver) {
        Validate.positive((int)maxManifolds, (String)"max manifolds");
        Validate.inRange((int)penetrationDepthSolver, (String)"penetration depth solver", (int)0, (int)1);
        long configurationId = CollisionConfiguration.createNative(maxManifolds, penetrationDepthSolver);
        super.setNativeId(configurationId);
    }

    public int maxManifolds() {
        long configurationId = this.nativeId();
        int result = CollisionConfiguration.maxManifolds(configurationId);
        return result;
    }

    public int penetrationDepthSolver() {
        long configurationId = this.nativeId();
        int result = CollisionConfiguration.penetrationDepthSolver(configurationId);
        return result;
    }

    private static void freeNativeObject(long configurationId) {
        assert (configurationId != 0L);
        CollisionConfiguration.finalizeNative(configurationId);
    }

    private static native long createNative(int var0, int var1);

    private static native void finalizeNative(long var0);

    private static native int maxManifolds(long var0);

    private static native int penetrationDepthSolver(long var0);
}

