/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.CollisionConfiguration;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionGroupListener;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.PhysicsRayTestResult;
import com.jme3.bullet.collision.PhysicsSweepTestResult;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class CollisionSpace
extends NativePhysicsObject {
    public static final Logger loggerC = Logger.getLogger(CollisionSpace.class.getName());
    private final PhysicsSpace.BroadphaseType broadphaseType;
    private final CollisionConfiguration collisionConfiguration;
    private static final Comparator<PhysicsRayTestResult> hitFractionComparator = new Comparator<PhysicsRayTestResult>(){

        @Override
        public int compare(PhysicsRayTestResult r1, PhysicsRayTestResult r2) {
            float r1Fraction = r1.getHitFraction();
            float r2Fraction = r2.getHitFraction();
            int result = Float.compare(r1Fraction, r2Fraction);
            return result;
        }
    };
    private final int numSolvers;
    private int rayTestFlags = 4;
    private final Map<Integer, PhysicsCollisionGroupListener> cgListeners = new ConcurrentHashMap<Integer, PhysicsCollisionGroupListener>(20);
    private final Map<Long, PhysicsGhostObject> ghostMap = new ConcurrentHashMap<Long, PhysicsGhostObject>(64);
    private static final ThreadLocal<CollisionSpace> physicsSpaceTL = new ThreadLocal();
    private final Vector3f worldMax = new Vector3f(10000.0f, 10000.0f, 10000.0f);
    private final Vector3f worldMin = new Vector3f(-10000.0f, -10000.0f, -10000.0f);

    public CollisionSpace(Vector3f worldMin, Vector3f worldMax, PhysicsSpace.BroadphaseType broadphaseType) {
        this(worldMin, worldMax, broadphaseType, 1);
    }

    protected CollisionSpace(Vector3f worldMin, Vector3f worldMax, PhysicsSpace.BroadphaseType broadphaseType, int numSolvers) {
        this(worldMin, worldMax, broadphaseType, numSolvers, new CollisionConfiguration());
    }

    protected CollisionSpace(Vector3f worldMin, Vector3f worldMax, PhysicsSpace.BroadphaseType broadphaseType, int numSolvers, CollisionConfiguration configuration) {
        Validate.finite((Vector3f)worldMin, (String)"world min");
        Validate.finite((Vector3f)worldMax, (String)"world max");
        Validate.nonNull((Object)((Object)broadphaseType), (String)"broadphase type");
        Validate.inRange((int)numSolvers, (String)"number of solvers", (int)1, (int)64);
        Validate.nonNull((Object)configuration, (String)"configuration");
        this.worldMin.set(worldMin);
        this.worldMax.set(worldMax);
        this.broadphaseType = broadphaseType;
        this.numSolvers = numSolvers;
        this.collisionConfiguration = configuration;
        this.create();
    }

    public void add(Object object) {
        Validate.nonNull((Object)object, (String)"object");
        if (!(object instanceof PhysicsCollisionObject)) {
            String typeName = object.getClass().getCanonicalName();
            String msg = "Cannot add a " + typeName + " to a collision space.";
            throw new IllegalArgumentException(msg);
        }
        this.addCollisionObject((PhysicsCollisionObject)object);
    }

    public void addCollisionGroupListener(PhysicsCollisionGroupListener listener, int collisionGroup) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (!this.cgListeners.containsKey(collisionGroup));
        Validate.require((Integer.bitCount(collisionGroup) == 1 ? 1 : 0) != 0, (String)"exactly one bit set");
        this.cgListeners.put(collisionGroup, listener);
    }

    public void addCollisionObject(PhysicsCollisionObject pco) {
        Validate.nonNull((Object)pco, (String)"collision object");
        if (!(pco instanceof PhysicsGhostObject)) {
            String typeName = pco.getClass().getCanonicalName();
            String msg = "Unknown type of collision object: " + typeName;
            throw new IllegalArgumentException(msg);
        }
        this.addGhostObject((PhysicsGhostObject)pco);
    }

    public int contactTest(PhysicsCollisionObject pco, PhysicsCollisionListener listener) {
        long spaceId = this.nativeId();
        long pcoId = pco.nativeId();
        int result = CollisionSpace.contactTest(spaceId, pcoId, listener);
        return result;
    }

    public boolean contains(PhysicsCollisionObject pco) {
        long pcoId = pco.nativeId();
        if (!(pco instanceof PhysicsGhostObject)) {
            String typeName = pco.getClass().getCanonicalName();
            String msg = "Unknown type of collision object: " + typeName;
            throw new IllegalArgumentException(msg);
        }
        boolean result = this.ghostMap.containsKey(pcoId);
        return result;
    }

    public int countCollisionGroupListeners() {
        int count = this.cgListeners.size();
        return count;
    }

    public int countCollisionObjects() {
        long spaceId = this.nativeId();
        int count = CollisionSpace.getNumCollisionObjects(spaceId);
        return count;
    }

    public int countSolvers() {
        assert (this.numSolvers >= 1) : this.numSolvers;
        assert (this.numSolvers <= 64) : this.numSolvers;
        return this.numSolvers;
    }

    public void destroy() {
        for (PhysicsGhostObject character : this.ghostMap.values()) {
            this.removeGhostObject(character);
        }
    }

    public PhysicsSpace.BroadphaseType getBroadphaseType() {
        return this.broadphaseType;
    }

    public static CollisionSpace getCollisionSpace() {
        CollisionSpace result = physicsSpaceTL.get();
        return result;
    }

    public CollisionConfiguration getConfiguration() {
        return this.collisionConfiguration;
    }

    public Collection<PhysicsGhostObject> getGhostObjectList() {
        Collection<PhysicsGhostObject> result = this.ghostMap.values();
        result = Collections.unmodifiableCollection(result);
        return result;
    }

    public Collection<PhysicsCollisionObject> getPcoList() {
        TreeSet<PhysicsCollisionObject> result = new TreeSet<PhysicsCollisionObject>();
        result.addAll(this.ghostMap.values());
        return result;
    }

    public int getRayTestFlags() {
        return this.rayTestFlags;
    }

    public Vector3f getWorldMax(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.worldMax.clone() : storeResult.set(this.worldMax);
        return result;
    }

    public Vector3f getWorldMin(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.worldMin.clone() : storeResult.set(this.worldMin);
        return result;
    }

    public boolean hasClosest(CollisionShape shape0, CollisionShape shape1) {
        long spaceId = this.nativeId();
        int shape0Type = shape0.getShapeType();
        int shape1Type = shape1.getShapeType();
        boolean result = CollisionSpace.hasClosest(spaceId, shape0Type, shape1Type);
        return result;
    }

    public boolean hasContact(CollisionShape shape0, CollisionShape shape1) {
        long spaceId = this.nativeId();
        int shape0Type = shape0.getShapeType();
        int shape1Type = shape1.getShapeType();
        boolean result = CollisionSpace.hasContact(spaceId, shape0Type, shape1Type);
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.ghostMap.isEmpty();
        return result;
    }

    public boolean isForceUpdateAllAabbs() {
        long spaceId = this.nativeId();
        return CollisionSpace.isForceUpdateAllAabbs(spaceId);
    }

    public boolean isUsingDeterministicDispatch() {
        long spaceId = this.nativeId();
        boolean result = CollisionSpace.getDeterministicOverlappingPairs(spaceId);
        return result;
    }

    public long jniEnvId() {
        long spaceId = this.nativeId();
        long result = CollisionSpace.getJniEnvId(spaceId);
        return result;
    }

    public boolean needsCollision(PhysicsCollisionObject pcoA, PhysicsCollisionObject pcoB) {
        PhysicsCollisionGroupListener listenerA = this.cgListeners.get(pcoA.getCollisionGroup());
        PhysicsCollisionGroupListener listenerB = this.cgListeners.get(pcoB.getCollisionGroup());
        boolean result = true;
        if (listenerA != null) {
            result = listenerA.collide(pcoA, pcoB);
        }
        if (listenerB != null && pcoA.getCollisionGroup() != pcoB.getCollisionGroup()) {
            result = listenerB.collide(pcoA, pcoB) && result;
        }
        return result;
    }

    public int pairTest(PhysicsCollisionObject pcoA, PhysicsCollisionObject pcoB, PhysicsCollisionListener listener) {
        long spaceId = this.nativeId();
        long aId = pcoA.nativeId();
        long bId = pcoB.nativeId();
        int result = CollisionSpace.pairTest(spaceId, aId, bId, listener);
        return result;
    }

    public List<PhysicsRayTestResult> rayTest(Vector3f from, Vector3f to) {
        ArrayList<PhysicsRayTestResult> results = new ArrayList<PhysicsRayTestResult>(10);
        this.rayTest(from, to, results);
        return results;
    }

    public List<PhysicsRayTestResult> rayTest(Vector3f from, Vector3f to, List<PhysicsRayTestResult> results) {
        results.clear();
        long spaceId = this.nativeId();
        CollisionSpace.rayTestNative(from, to, spaceId, results, this.rayTestFlags);
        results.sort(hitFractionComparator);
        return results;
    }

    public List<PhysicsRayTestResult> rayTestDp(Vec3d from, Vec3d to, List<PhysicsRayTestResult> results) {
        results.clear();
        long spaceId = this.nativeId();
        CollisionSpace.rayTestNativeDp(from, to, spaceId, results, this.rayTestFlags);
        results.sort(hitFractionComparator);
        return results;
    }

    public List<PhysicsRayTestResult> rayTestRaw(Vector3f from, Vector3f to) {
        ArrayList<PhysicsRayTestResult> results = new ArrayList<PhysicsRayTestResult>(10);
        this.rayTestRaw(from, to, results);
        return results;
    }

    public List<PhysicsRayTestResult> rayTestRaw(Vector3f from, Vector3f to, List<PhysicsRayTestResult> results) {
        results.clear();
        long spaceId = this.nativeId();
        CollisionSpace.rayTestNative(from, to, spaceId, results, this.rayTestFlags);
        return results;
    }

    public void remove(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof PhysicsCollisionObject)) {
            String typeName = object.getClass().getCanonicalName();
            String msg = "Cannot remove a " + typeName + " from a collision space.";
            throw new IllegalArgumentException(msg);
        }
        this.removeCollisionObject((PhysicsCollisionObject)object);
    }

    public void removeCollisionGroupListener(int collisionGroup) {
        assert (this.cgListeners.containsKey(collisionGroup));
        Validate.require((Integer.bitCount(collisionGroup) == 1 ? 1 : 0) != 0, (String)"exactly one bit set");
        this.cgListeners.remove(collisionGroup);
    }

    public void removeCollisionObject(PhysicsCollisionObject pco) {
        Validate.nonNull((Object)pco, (String)"collision object");
        if (!(pco instanceof PhysicsGhostObject)) {
            String typeName = pco.getClass().getCanonicalName();
            String msg = "Unknown type of collision object: " + typeName;
            throw new IllegalArgumentException(msg);
        }
        this.removeGhostObject((PhysicsGhostObject)pco);
    }

    public void setForceUpdateAllAabbs(boolean desiredSetting) {
        long spaceId = this.nativeId();
        CollisionSpace.setForceUpdateAllAabbs(spaceId, desiredSetting);
    }

    public static void setLocalThreadPhysicsSpace(CollisionSpace space) {
        physicsSpaceTL.set(space);
    }

    public void setRayTestFlags(int flags) {
        this.rayTestFlags = flags;
    }

    public List<PhysicsSweepTestResult> sweepTest(ConvexShape shape, Transform start, Transform end) {
        LinkedList<PhysicsSweepTestResult> results = new LinkedList<PhysicsSweepTestResult>();
        this.sweepTest(shape, start, end, results);
        return results;
    }

    public List<PhysicsSweepTestResult> sweepTest(ConvexShape shape, Transform start, Transform end, List<PhysicsSweepTestResult> results) {
        List<PhysicsSweepTestResult> result = this.sweepTest(shape, start, end, results, 0.0f);
        return result;
    }

    public List<PhysicsSweepTestResult> sweepTest(ConvexShape shape, Transform start, Transform end, List<PhysicsSweepTestResult> results, float allowedCcdPenetration) {
        Validate.nonNull((Object)start, (String)"start");
        Validate.nonNull((Object)end, (String)"end");
        Validate.nonNull(results, (String)"results");
        long shapeId = shape.nativeId();
        long spaceId = this.nativeId();
        results.clear();
        CollisionSpace.sweepTestNative(shapeId, start, end, spaceId, results, allowedCcdPenetration);
        return results;
    }

    public void useDeterministicDispatch(boolean desiredSetting) {
        long spaceId = this.nativeId();
        CollisionSpace.setDeterministicOverlappingPairs(spaceId, desiredSetting);
    }

    protected void create() {
        assert (this.numSolvers == 1) : this.numSolvers;
        int broadphase = this.getBroadphaseType().ordinal();
        long configurationId = this.collisionConfiguration.nativeId();
        long spaceId = this.createCollisionSpace(this.worldMin.x, this.worldMin.y, this.worldMin.z, this.worldMax.x, this.worldMax.y, this.worldMax.z, broadphase, configurationId);
        assert (spaceId != 0L);
        this.initThread(spaceId);
        loggerC.log(Level.FINE, "Created {0}.", this);
    }

    protected void initThread(long spaceId) {
        this.setNativeId(spaceId);
        physicsSpaceTL.set(this);
    }

    private void addGhostObject(PhysicsGhostObject ghost) {
        if (this.contains(ghost)) {
            loggerC.log(Level.WARNING, "{0} is already added to {1}.", new Object[]{ghost, this});
            return;
        }
        assert (!ghost.isInWorld());
        if (loggerC.isLoggable(Level.FINE)) {
            loggerC.log(Level.FINE, "Adding {0} to {1}.", new Object[]{ghost, this});
        }
        long ghostId = ghost.nativeId();
        this.ghostMap.put(ghostId, ghost);
        long spaceId = this.nativeId();
        CollisionSpace.addCollisionObject(spaceId, ghostId);
    }

    private static void freeNativeObject(long spaceId) {
        Validate.nonZero((long)spaceId, (String)"space ID");
        CollisionSpace.finalizeNative(spaceId);
    }

    private boolean notifyCollisionGroupListeners(PhysicsCollisionObject pcoA, PhysicsCollisionObject pcoB) {
        boolean result = this.needsCollision(pcoA, pcoB);
        return result;
    }

    private void removeGhostObject(PhysicsGhostObject ghost) {
        long ghostId = ghost.nativeId();
        if (!this.ghostMap.containsKey(ghostId)) {
            loggerC.log(Level.WARNING, "{0} does not exist in {1}.", new Object[]{ghost, this});
            return;
        }
        this.ghostMap.remove(ghostId);
        if (loggerC.isLoggable(Level.FINE)) {
            loggerC.log(Level.FINE, "Removing {0} from {1}.", new Object[]{ghost, this});
        }
        long spaceId = this.nativeId();
        CollisionSpace.removeCollisionObject(spaceId, ghostId);
    }

    private static native void addCollisionObject(long var0, long var2);

    private static native int contactTest(long var0, long var2, PhysicsCollisionListener var4);

    private native long createCollisionSpace(float var1, float var2, float var3, float var4, float var5, float var6, int var7, long var8);

    private static native void finalizeNative(long var0);

    private static native boolean getDeterministicOverlappingPairs(long var0);

    private static native long getJniEnvId(long var0);

    private static native int getNumCollisionObjects(long var0);

    private static native boolean hasClosest(long var0, int var2, int var3);

    private static native boolean hasContact(long var0, int var2, int var3);

    private static native boolean isForceUpdateAllAabbs(long var0);

    private static native int pairTest(long var0, long var2, long var4, PhysicsCollisionListener var6);

    private static native void rayTestNative(Vector3f var0, Vector3f var1, long var2, List<PhysicsRayTestResult> var4, int var5);

    private static native void rayTestNativeDp(Vec3d var0, Vec3d var1, long var2, List<PhysicsRayTestResult> var4, int var5);

    private static native void removeCollisionObject(long var0, long var2);

    private static native void setDeterministicOverlappingPairs(long var0, boolean var2);

    private static native void setForceUpdateAllAabbs(long var0, boolean var2);

    private static native void sweepTestNative(long var0, Transform var2, Transform var3, long var4, List<PhysicsSweepTestResult> var6, float var7);
}

