/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.ContactManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.ContactListener;
import com.jme3.bullet.collision.PersistentManifolds;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class DefaultContactManager
implements ContactManager {
    private static final int invokeEnded = 2;
    private static final int invokeProcessed = 16;
    private static final int invokeStarted = 128;
    static final Logger logger = Logger.getLogger(DefaultContactManager.class.getName());
    private boolean doEnded = false;
    private boolean doProcessed = false;
    private boolean doStarted = false;
    private final Collection<PhysicsCollisionListener> ongoingListeners = new ArrayList<PhysicsCollisionListener>(4);
    private final Collection<PhysicsCollisionListener> startedListeners = new ArrayList<PhysicsCollisionListener>(4);
    private final Deque<PhysicsCollisionEvent> ongoingEvents = new ArrayDeque<PhysicsCollisionEvent>(99);
    private final Deque<PhysicsCollisionEvent> startedEvents = new ArrayDeque<PhysicsCollisionEvent>(99);
    private final List<ContactListener> immediateListeners = new ArrayList<ContactListener>(4);
    private final List<Integer> immediateListenerFlags = new ArrayList<Integer>(4);
    private final PhysicsSpace space;

    public DefaultContactManager(PhysicsSpace space) {
        Validate.nonNull((Object)space, (String)"space");
        this.space = space;
    }

    @Override
    public synchronized void addCollisionListener(PhysicsCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (listener != this);
        assert (listener != this.space);
        assert (!this.startedListeners.contains(listener));
        this.startedListeners.add(listener);
        this.doStarted = true;
    }

    @Override
    public synchronized void addContactListener(ContactListener listener, boolean doEnded, boolean doProcessed, boolean doStarted) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (listener != this);
        assert (listener != this.space);
        assert (!this.immediateListeners.contains(listener));
        this.immediateListeners.add(listener);
        int encodedFlags = (doEnded ? 2 : 0) | (doProcessed ? 16 : 0) | (doStarted ? 128 : 0);
        this.immediateListenerFlags.add(encodedFlags);
        if (doEnded) {
            this.doEnded = true;
        }
        if (doProcessed) {
            this.doProcessed = true;
        }
        if (doStarted) {
            this.doStarted = true;
        }
    }

    @Override
    public synchronized void addOngoingCollisionListener(PhysicsCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (listener != this);
        assert (listener != this.space);
        assert (!this.ongoingListeners.contains(listener));
        this.ongoingListeners.add(listener);
        this.doProcessed = true;
    }

    @Override
    public synchronized int countCollisionListeners() {
        int result = this.ongoingListeners.size() + this.startedListeners.size();
        return result;
    }

    @Override
    public synchronized void distributeEvents() {
        PhysicsCollisionEvent event;
        while (!this.startedEvents.isEmpty()) {
            event = this.startedEvents.pop();
            for (PhysicsCollisionListener listener : this.startedListeners) {
                listener.collision(event);
            }
        }
        while (!this.ongoingEvents.isEmpty()) {
            event = this.ongoingEvents.pop();
            for (PhysicsCollisionListener listener : this.ongoingListeners) {
                listener.collision(event);
            }
        }
    }

    @Override
    public synchronized void removeCollisionListener(PhysicsCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        boolean success = this.startedListeners.remove(listener);
        assert (success);
        this.updateFlags();
    }

    @Override
    public synchronized void removeContactListener(ContactListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        int index = this.immediateListeners.indexOf(listener);
        assert (index >= 0) : index;
        this.immediateListeners.remove(index);
        this.immediateListenerFlags.remove(index);
        this.updateFlags();
    }

    @Override
    public synchronized void removeOngoingCollisionListener(PhysicsCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        boolean success = this.ongoingListeners.remove(listener);
        assert (success);
        this.updateFlags();
    }

    @Override
    public void update(float timeInterval, int maxSteps) {
        assert (Validate.nonNegative((float)timeInterval, (String)"time interval"));
        assert (Validate.nonNegative((int)maxSteps, (String)"max steps"));
        this.space.update(timeInterval, maxSteps, this.doEnded, this.doProcessed, this.doStarted);
    }

    @Override
    public void onContactEnded(long manifoldId) {
        int numImmediateListeners = this.immediateListeners.size();
        for (int i = 0; i < numImmediateListeners; ++i) {
            int flags = this.immediateListenerFlags.get(i);
            if ((flags & 2) == 0) continue;
            ContactListener listener = this.immediateListeners.get(i);
            listener.onContactEnded(manifoldId);
        }
    }

    @Override
    public void onContactProcessed(PhysicsCollisionObject pcoA, PhysicsCollisionObject pcoB, long pointId) {
        int numImmediateListeners = this.immediateListeners.size();
        for (int i = 0; i < numImmediateListeners; ++i) {
            int flags = this.immediateListenerFlags.get(i);
            if ((flags & 0x10) == 0) continue;
            ContactListener listener = this.immediateListeners.get(i);
            listener.onContactProcessed(pcoA, pcoB, pointId);
        }
        if (!this.ongoingListeners.isEmpty()) {
            PhysicsCollisionEvent event = new PhysicsCollisionEvent(pcoA, pcoB, pointId);
            this.ongoingEvents.add(event);
        }
    }

    @Override
    public void onContactStarted(long manifoldId) {
        int numImmediateListeners = this.immediateListeners.size();
        for (int i = 0; i < numImmediateListeners; ++i) {
            int flags = this.immediateListenerFlags.get(i);
            if ((flags & 0x80) == 0) continue;
            ContactListener listener = this.immediateListeners.get(i);
            listener.onContactStarted(manifoldId);
        }
        if (this.startedListeners.isEmpty()) {
            return;
        }
        int numPoints = PersistentManifolds.countPoints(manifoldId);
        if (numPoints == 0) {
            return;
        }
        long bodyAId = PersistentManifolds.getBodyAId(manifoldId);
        PhysicsCollisionObject pcoA = PhysicsCollisionObject.findInstance(bodyAId);
        long bodyBId = PersistentManifolds.getBodyBId(manifoldId);
        PhysicsCollisionObject pcoB = PhysicsCollisionObject.findInstance(bodyBId);
        for (int i = 0; i < numPoints; ++i) {
            long pointId = PersistentManifolds.getPointId(manifoldId, i);
            PhysicsCollisionEvent event = new PhysicsCollisionEvent(pcoA, pcoB, pointId);
            this.startedEvents.add(event);
        }
    }

    private void updateFlags() {
        int union = 0;
        for (int flags : this.immediateListenerFlags) {
            union |= flags;
        }
        this.doEnded = (union & 2) != 0;
        this.doProcessed = (union & 0x10) != 0 || !this.ongoingListeners.isEmpty();
        this.doStarted = (union & 0x80) != 0 || !this.startedListeners.isEmpty();
    }
}

