/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.MultiBody;
import com.jme3.bullet.MultiBodyJointType;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.MultiBodyCollider;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MultiBodyLink
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(MultiBodyLink.class.getName());
    private static final String tagCollider = "collider";
    private static final String tagLinkIndex = "linkIndex";
    private static final String tagMultiBody = "multiBody";
    private static final String tagNumDofs = "numDofs";
    private static final String tagParentLink = "parentLink";
    private int linkIndex;
    private int numDofs;
    private long multiBodyId;
    private MultiBody multiBody;
    private MultiBodyCollider collider = null;
    private MultiBodyLink parentLink;

    protected MultiBodyLink() {
    }

    MultiBodyLink(MultiBody multiBody, int index) {
        Validate.nonNull((Object)multiBody, (String)"multibody");
        Validate.nonNegative((int)index, (String)"index");
        this.linkIndex = index;
        this.multiBody = multiBody;
        this.multiBodyId = multiBody.nativeId();
        long linkId = MultiBodyLink.getLinkId(this.multiBodyId, index);
        super.setNativeIdNotTracked(linkId);
        this.numDofs = MultiBodyLink.getDofCount(linkId);
        int parentIndex = MultiBodyLink.getParentIndex(linkId);
        this.parentLink = parentIndex == -1 ? null : multiBody.getLink(parentIndex);
    }

    public MultiBodyCollider addCollider(CollisionShape shape) {
        Validate.nonNull((Object)shape, (String)"shape");
        assert (this.collider == null) : this.collider;
        this.collider = new MultiBodyCollider(this.multiBody, this.linkIndex);
        long linkId = this.nativeId();
        long colliderId = this.collider.nativeId();
        MultiBodyLink.setCollider(linkId, colliderId);
        this.collider.attachShape(shape);
        return this.collider;
    }

    public void addConstraintForce(Vector3f force) {
        Validate.finite((Vector3f)force, (String)"force");
        long linkId = this.nativeId();
        MultiBodyLink.addConstraintForce(linkId, force);
    }

    public void addConstraintTorque(Vector3f torque) {
        Validate.finite((Vector3f)torque, (String)"torque");
        long linkId = this.nativeId();
        MultiBodyLink.addConstraintTorque(linkId, torque);
    }

    public void addForce(Vector3f force) {
        Validate.finite((Vector3f)force, (String)"force");
        long linkId = this.nativeId();
        MultiBodyLink.addForce(linkId, force);
    }

    public void addJointTorque(int dofIndex, float torque) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)(this.numDofs - 1));
        long linkId = this.nativeId();
        MultiBodyLink.addJointTorque(linkId, dofIndex, torque);
    }

    public void addTorque(Vector3f torque) {
        Validate.finite((Vector3f)torque, (String)"torque");
        long linkId = this.nativeId();
        MultiBodyLink.addTorque(linkId, torque);
    }

    public Vector3f appliedForce(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getAppliedForce(linkId, result);
        return result;
    }

    public Vector3f appliedTorque(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getAppliedTorque(linkId, result);
        return result;
    }

    public Vector3f axis(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        MultiBodyJointType jointType = this.jointType();
        long linkId = this.nativeId();
        switch (jointType) {
            case Planar: 
            case Revolute: {
                MultiBodyLink.getAxisTop(linkId, 0, result);
                break;
            }
            case Prismatic: {
                MultiBodyLink.getAxisBottom(linkId, 0, result);
                break;
            }
            default: {
                throw new IllegalStateException("jointType = " + (Object)((Object)jointType));
            }
        }
        return result;
    }

    public Vector3f constraintForce(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getConstraintForce(linkId, result);
        return result;
    }

    public Vector3f constraintTorque(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getConstraintTorque(linkId, result);
        return result;
    }

    public int countDofs() {
        assert (this.numDofs == MultiBodyLink.getDofCount(this.nativeId()));
        return this.numDofs;
    }

    public int countPositionVariables() {
        long linkId = this.nativeId();
        int result = MultiBodyLink.getPosVarCount(linkId);
        return result;
    }

    public MultiBodyCollider getCollider() {
        if (this.collider == null ? !$assertionsDisabled && MultiBodyLink.getCollider(this.multiBodyId, this.linkIndex) != 0L : !$assertionsDisabled && MultiBodyLink.getCollider(this.multiBodyId, this.linkIndex) != this.collider.nativeId()) {
            throw new AssertionError();
        }
        return this.collider;
    }

    public MultiBody getMultiBody() {
        assert (this.multiBody != null);
        return this.multiBody;
    }

    public MultiBodyLink getParentLink() {
        return this.parentLink;
    }

    public int index() {
        assert (this.linkIndex >= 0) : this.linkIndex;
        return this.linkIndex;
    }

    public Vector3f inertia(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getInertiaLocal(linkId, result);
        return result;
    }

    public boolean isCollisionWithParent() {
        int disableCollisionWithParentFlag;
        long linkId = this.nativeId();
        int flags = MultiBodyLink.getFlags(linkId);
        return (flags & (disableCollisionWithParentFlag = 1)) == 0;
    }

    public float jointPosition(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)(this.numDofs - 1));
        long linkId = this.nativeId();
        float result = MultiBodyLink.getJointPos(linkId, dofIndex);
        return result;
    }

    public float jointTorque(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)(this.numDofs - 1));
        long linkId = this.nativeId();
        float result = MultiBodyLink.getJointTorque(linkId, dofIndex);
        return result;
    }

    public MultiBodyJointType jointType() {
        long linkId = this.nativeId();
        int ordinal = MultiBodyLink.getJointType(linkId);
        MultiBodyJointType result = MultiBodyJointType.values()[ordinal];
        return result;
    }

    public float jointVelocity(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)(this.numDofs - 1));
        float result = MultiBodyLink.getJointVel(this.multiBodyId, this.linkIndex, dofIndex);
        return result;
    }

    public Vector3f location(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult.zero();
        MultiBodyLink.localPosToWorld(this.multiBodyId, this.linkIndex, result);
        return result;
    }

    public float mass() {
        long linkId = this.nativeId();
        float result = MultiBodyLink.getMass(linkId);
        return result;
    }

    public Quaternion orientation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getQ0Parent2LinkRotation(linkId, result);
        return result;
    }

    public Vector3f parent2Link(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.jointType() == MultiBodyJointType.Planar);
        long linkId = this.nativeId();
        MultiBodyLink.getEVector(linkId, result);
        return result;
    }

    public Vector3f parent2Pivot(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.jointType() != MultiBodyJointType.Planar);
        long linkId = this.nativeId();
        MultiBodyLink.getEVector(linkId, result);
        return result;
    }

    public Vector3f pivot2Link(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.jointType() != MultiBodyJointType.Planar);
        long linkId = this.nativeId();
        MultiBodyLink.getDVector(linkId, result);
        return result;
    }

    public void setJointPosition(int dofIndex, float position) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)(this.numDofs - 1));
        MultiBodyLink.setJointPos(this.multiBodyId, this.linkIndex, dofIndex, position);
    }

    public void setJointVelocity(int dofIndex, float velocity) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)(this.numDofs - 1));
        MultiBodyLink.setJointVel(this.multiBodyId, this.linkIndex, dofIndex, velocity);
    }

    public Transform worldTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getWorldTransform(linkId, result);
        return result;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.multiBody = (MultiBody)cloner.clone((Object)this.multiBody);
        this.multiBodyId = this.multiBody.nativeId();
        this.parentLink = (MultiBodyLink)cloner.clone((Object)this.parentLink);
        long linkId = MultiBodyLink.getLinkId(this.multiBodyId, this.linkIndex);
        this.reassignNativeId(linkId);
        this.collider = (MultiBodyCollider)cloner.clone((Object)this.collider);
    }

    public MultiBodyLink jmeClone() {
        try {
            MultiBodyLink clone = (MultiBodyLink)this.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.collider = (MultiBodyCollider)capsule.readSavable(tagCollider, null);
        this.linkIndex = capsule.readInt(tagLinkIndex, -1);
        this.multiBody = (MultiBody)capsule.readSavable(tagMultiBody, null);
        this.numDofs = capsule.readInt(tagNumDofs, 0);
        this.parentLink = (MultiBodyLink)capsule.readSavable(tagParentLink, null);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.collider, tagCollider, null);
        capsule.write(this.linkIndex, tagLinkIndex, -1);
        capsule.write((Savable)this.multiBody, tagMultiBody, null);
        capsule.write(this.numDofs, tagNumDofs, 0);
        capsule.write((Savable)this.parentLink, tagParentLink, null);
    }

    private static native void addConstraintForce(long var0, Vector3f var2);

    private static native void addConstraintTorque(long var0, Vector3f var2);

    private static native void addForce(long var0, Vector3f var2);

    private static native void addJointTorque(long var0, int var2, float var3);

    private static native void addTorque(long var0, Vector3f var2);

    private static native void getAppliedForce(long var0, Vector3f var2);

    private static native void getAppliedTorque(long var0, Vector3f var2);

    private static native void getAxisBottom(long var0, int var2, Vector3f var3);

    private static native void getAxisTop(long var0, int var2, Vector3f var3);

    private static native long getCollider(long var0, int var2);

    private static native void getConstraintForce(long var0, Vector3f var2);

    private static native void getConstraintTorque(long var0, Vector3f var2);

    private static native int getDofCount(long var0);

    private static native void getDVector(long var0, Vector3f var2);

    private static native void getEVector(long var0, Vector3f var2);

    private static native int getFlags(long var0);

    private static native void getInertiaLocal(long var0, Vector3f var2);

    private static native float getJointPos(long var0, int var2);

    private static native float getJointTorque(long var0, int var2);

    private static native int getJointType(long var0);

    private static native float getJointVel(long var0, int var2, int var3);

    private static native long getLinkId(long var0, int var2);

    private static native float getMass(long var0);

    private static native void getParent2LinkRotation(long var0, Quaternion var2);

    private static native int getParentIndex(long var0);

    private static native int getPosVarCount(long var0);

    private static native void getQ0Parent2LinkRotation(long var0, Quaternion var2);

    private static native void getWorldTransform(long var0, Transform var2);

    private static native void localFrameToWorld(long var0, int var2, Matrix3f var3);

    private static native void localPosToWorld(long var0, int var2, Vector3f var3);

    private static native void setCollider(long var0, long var2);

    private static native void setJointPos(long var0, int var2, int var3, float var4);

    private static native void setJointVel(long var0, int var2, int var3, float var4);

    private static native void worldPosToLocal(long var0, int var2, Vector3f var3);
}

