/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SoftBodyWorldInfo
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(SoftBodyWorldInfo.class.getName());
    private static final String tagAirDensity = "airDensity";
    private static final String tagGravity = "gravity";
    private static final String tagMaxDisplacement = "maxDisplacement";
    private static final String tagWaterDensity = "waterDensity";
    private static final String tagWaterNormal = "waterNormal";
    private static final String tagWaterOffset = "waterOffset";

    public SoftBodyWorldInfo() {
        long infoId = SoftBodyWorldInfo.createSoftBodyWorldInfo();
        super.setNativeId(infoId);
    }

    public SoftBodyWorldInfo(long nativeId) {
        Validate.nonZero((long)nativeId, (String)"native ID");
        super.setNativeIdNotTracked(nativeId);
    }

    public float airDensity() {
        long infoId = this.nativeId();
        float result = SoftBodyWorldInfo.getAirDensity(infoId);
        return result;
    }

    public void copyAll(SoftBodyWorldInfo source) {
        long thisId = this.nativeId();
        long sourceId = source.nativeId();
        SoftBodyWorldInfo.setSoftBodyWorldInfo(thisId, sourceId);
    }

    public Vector3f copyGravity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long infoId = this.nativeId();
        SoftBodyWorldInfo.getGravity(infoId, result);
        return result;
    }

    public Vector3f copyWaterNormal(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long infoId = this.nativeId();
        SoftBodyWorldInfo.getWaterNormal(infoId, result);
        return result;
    }

    public float maxDisplacement() {
        long infoId = this.nativeId();
        float result = SoftBodyWorldInfo.getMaxDisplacement(infoId);
        return result;
    }

    public void setAirDensity(float density) {
        long infoId = this.nativeId();
        SoftBodyWorldInfo.setAirDensity(infoId, density);
    }

    public void setGravity(Vector3f acceleration) {
        long infoId = this.nativeId();
        SoftBodyWorldInfo.setGravity(infoId, acceleration);
    }

    public void setMaxDisplacement(float maxDisplacement) {
        Validate.positive((float)maxDisplacement, (String)"max displacement");
        long infoId = this.nativeId();
        SoftBodyWorldInfo.setMaxDisplacement(infoId, maxDisplacement);
    }

    public void setWaterDensity(float density) {
        long infoId = this.nativeId();
        SoftBodyWorldInfo.setWaterDensity(infoId, density);
    }

    public void setWaterNormal(Vector3f normalDirection) {
        long infoId = this.nativeId();
        SoftBodyWorldInfo.setWaterNormal(infoId, normalDirection);
    }

    public void setWaterOffset(float offset) {
        long infoId = this.nativeId();
        SoftBodyWorldInfo.setWaterOffset(infoId, offset);
    }

    public float waterDensity() {
        long infoId = this.nativeId();
        float result = SoftBodyWorldInfo.getWaterDensity(infoId);
        return result;
    }

    public float waterOffset() {
        long infoId = this.nativeId();
        float result = SoftBodyWorldInfo.getWaterOffset(infoId);
        return result;
    }

    public void cloneFields(Cloner cloner, Object original) {
        long infoId = SoftBodyWorldInfo.createSoftBodyWorldInfo();
        this.reassignNativeId(infoId);
        this.copyAll((SoftBodyWorldInfo)original);
    }

    public SoftBodyWorldInfo jmeClone() {
        try {
            SoftBodyWorldInfo clone = (SoftBodyWorldInfo)this.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.setAirDensity(capsule.readFloat(tagAirDensity, 1.2f));
        this.setGravity((Vector3f)capsule.readSavable(tagGravity, (Savable)new Vector3f(0.0f, -10.0f, 0.0f)));
        this.setMaxDisplacement(capsule.readFloat(tagMaxDisplacement, 1000.0f));
        this.setWaterDensity(capsule.readFloat(tagWaterDensity, 0.0f));
        this.setWaterNormal((Vector3f)capsule.readSavable(tagWaterNormal, (Savable)new Vector3f(0.0f, 0.0f, 0.0f)));
        this.setWaterOffset(capsule.readFloat(tagWaterOffset, 0.0f));
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.airDensity(), tagAirDensity, 1.2f);
        capsule.write((Savable)this.copyGravity(null), tagGravity, null);
        capsule.write(this.maxDisplacement(), tagMaxDisplacement, 1000.0f);
        capsule.write(this.waterDensity(), tagWaterDensity, 0.0f);
        capsule.write((Savable)this.copyWaterNormal(null), tagWaterNormal, null);
        capsule.write(this.waterOffset(), tagWaterOffset, 0.0f);
    }

    private static void freeNativeObject(long infoId) {
        assert (infoId != 0L);
        SoftBodyWorldInfo.finalizeNative(infoId);
    }

    private static native long createSoftBodyWorldInfo();

    private static native void finalizeNative(long var0);

    private static native float getAirDensity(long var0);

    private static native void getGravity(long var0, Vector3f var2);

    private static native float getMaxDisplacement(long var0);

    private static native float getWaterDensity(long var0);

    private static native void getWaterNormal(long var0, Vector3f var2);

    private static native float getWaterOffset(long var0);

    private static native void setAirDensity(long var0, float var2);

    private static native void setGravity(long var0, Vector3f var2);

    private static native void setMaxDisplacement(long var0, float var2);

    private static native void setSoftBodyWorldInfo(long var0, long var2);

    private static native void setWaterDensity(long var0, float var2);

    private static native void setWaterNormal(long var0, Vector3f var2);

    private static native void setWaterOffset(long var0, float var2);
}

