/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Joint;
import com.jme3.animation.Bone;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.RotationOrder;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.LinkConfig;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.RangeOfMotion;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.New6Dof;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Heart;
import jme3utilities.MySkeleton;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyQuaternion;

public class AttachmentLink
extends PhysicsLink {
    public static final Logger logger2 = Logger.getLogger(AttachmentLink.class.getName());
    private static final Matrix3f matrixIdentity = new Matrix3f();
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final String tagAttachedModel = "attachedModel";
    private static final String tagEndModelTransform = "endModelTransform";
    private static final String tagStartModelTransform = "startModelTransform";
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private Spatial attachedModel;
    private Transform endModelTransform = null;
    private Transform startModelTransform = new Transform();

    protected AttachmentLink() {
    }

    AttachmentLink(DacLinks control, Bone associatedBone, PhysicsLink manager, Spatial attachModel, CollisionShape collisionShape, LinkConfig linkConfig, Vector3f localOffset) {
        super(control, associatedBone, collisionShape, linkConfig, localOffset);
        assert (manager != null);
        assert (attachModel != null);
        this.attachedModel = attachModel;
        this.setParent(manager);
        PhysicsRigidBody managerBody = manager.getRigidBody();
        Transform managerToWorld = manager.physicsTransform(null);
        Transform worldToManager = managerToWorld.invert();
        Transform attachToWorld = this.physicsTransform(null);
        Transform attachToManager = MyMath.combine((Transform)attachToWorld, (Transform)worldToManager, null);
        Vector3f pivotMesh = associatedBone.getModelSpacePosition();
        Spatial transformer = control.getTransformer();
        Vector3f pivotWorld = transformer.localToWorld(pivotMesh, null);
        managerToWorld.setScale(1.0f);
        Vector3f pivotManager = MyMath.transformInverse((Transform)managerToWorld, (Vector3f)pivotWorld, null);
        attachToWorld.setScale(1.0f);
        Vector3f pivot = MyMath.transformInverse((Transform)attachToWorld, (Vector3f)pivotWorld, null);
        Matrix3f rotManager = attachToManager.getRotation().toRotationMatrix();
        Matrix3f rot = matrixIdentity;
        RotationOrder rotationOrder = linkConfig.rotationOrder();
        Constraint constraint = rotationOrder == null ? new SixDofJoint(managerBody, this.getRigidBody(), pivotManager, pivot, rotManager, rot, true) : new New6Dof(managerBody, this.getRigidBody(), pivotManager, pivot, rotManager, rot, rotationOrder);
        this.setJoint(constraint);
        RangeOfMotion rangeOfMotion = new RangeOfMotion();
        rangeOfMotion.setup(constraint, false, false, false);
    }

    AttachmentLink(DacLinks control, Joint associatedJoint, PhysicsLink manager, Spatial attachModel, CollisionShape collisionShape, LinkConfig linkConfig, Vector3f localOffset) {
        super(control, associatedJoint, collisionShape, linkConfig, localOffset);
        assert (manager != null);
        assert (attachModel != null);
        this.attachedModel = attachModel;
        this.setParent(manager);
        PhysicsRigidBody managerBody = manager.getRigidBody();
        Transform managerToWorld = manager.physicsTransform(null);
        Transform worldToManager = managerToWorld.invert();
        Transform attachToWorld = this.physicsTransform(null);
        Transform attachToManager = MyMath.combine((Transform)attachToWorld, (Transform)worldToManager, null);
        Vector3f pivotMesh = associatedJoint.getModelTransform().getTranslation();
        Spatial transformer = control.getTransformer();
        Vector3f pivotWorld = transformer.localToWorld(pivotMesh, null);
        managerToWorld.setScale(1.0f);
        Vector3f pivotManager = MyMath.transformInverse((Transform)managerToWorld, (Vector3f)pivotWorld, null);
        attachToWorld.setScale(1.0f);
        Vector3f pivot = MyMath.transformInverse((Transform)attachToWorld, (Vector3f)pivotWorld, null);
        Matrix3f rotManager = attachToManager.getRotation().toRotationMatrix();
        Matrix3f rot = matrixIdentity;
        RotationOrder rotationOrder = linkConfig.rotationOrder();
        Constraint constraint = rotationOrder == null ? new SixDofJoint(managerBody, this.getRigidBody(), pivotManager, pivot, rotManager, rot, true) : new New6Dof(managerBody, this.getRigidBody(), pivotManager, pivot, rotManager, rot, rotationOrder);
        this.setJoint(constraint);
        RangeOfMotion rangeOfMotion = new RangeOfMotion();
        rangeOfMotion.setup(constraint, false, false, false);
    }

    public void blendToKinematicMode(float blendInterval, Transform endModelTransform) {
        Validate.nonNegative((float)blendInterval, (String)"blend interval");
        if (this.isReleased()) {
            throw new IllegalStateException("Cannot change modes once released.");
        }
        this.blendToKinematicMode(blendInterval);
        this.endModelTransform = endModelTransform;
        if (endModelTransform != null) {
            Transform current = this.attachedModel.getLocalTransform();
            this.startModelTransform.set(current);
        }
    }

    public Spatial getAttachedModel() {
        assert (this.attachedModel != null);
        return this.attachedModel;
    }

    public void release() {
        if (this.isKinematic()) {
            throw new IllegalStateException("Cannot release an attachment in kinematic mode.");
        }
        if (this.isReleased()) {
            throw new IllegalStateException("Cannot release the same attachment twice.");
        }
        PhysicsJoint joint = this.getJoint();
        joint.destroy();
        PhysicsSpace space = this.getControl().getPhysicsSpace();
        space.removeJoint(joint);
        this.setJoint(null);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.attachedModel = (Spatial)cloner.clone((Object)this.attachedModel);
        this.endModelTransform = (Transform)cloner.clone((Object)this.endModelTransform);
        this.startModelTransform = (Transform)cloner.clone((Object)this.startModelTransform);
    }

    @Override
    protected void dynamicUpdate() {
        assert (!this.getRigidBody().isKinematic());
        Transform transform = this.localModelTransform(null);
        this.attachedModel.setLocalTransform(transform);
    }

    @Override
    public void freeze(boolean forceKinematic) {
        if (forceKinematic || this.isKinematic()) {
            this.blendToKinematicMode(0.0f, null);
        } else {
            this.setDynamic(translateIdentity);
        }
    }

    @Override
    public boolean isReleased() {
        PhysicsJoint joint = this.getJoint();
        return joint == null;
    }

    @Override
    protected void kinematicUpdate(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        assert (this.getRigidBody().isKinematic());
        Transform transform = new Transform();
        if (this.endModelTransform != null) {
            Quaternion endQuat;
            Quaternion startQuat = this.startModelTransform.getRotation();
            if (startQuat.dot(endQuat = this.endModelTransform.getRotation()) < 0.0f) {
                endQuat.multLocal(-1.0f);
            }
            MyMath.slerp((float)this.kinematicWeight(), (Transform)this.startModelTransform, (Transform)this.endModelTransform, (Transform)transform);
            this.attachedModel.setLocalTransform(transform);
        }
        super.kinematicUpdate(tpf);
    }

    @Override
    public String name() {
        String result = "Attachment:" + this.boneName();
        return result;
    }

    @Override
    public final Transform physicsTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        result.setTranslation(this.localOffset(null));
        result.setRotation(rotateIdentity);
        result.setScale(1.0f);
        Transform tmp = this.attachedModel.getLocalTransform();
        MyMath.combine((Transform)result, (Transform)tmp, (Transform)result);
        Bone bone = this.getBone();
        if (bone != null) {
            tmp = MySkeleton.copyMeshTransform((Bone)bone, null);
        } else {
            Joint armatureJoint = this.getArmatureJoint();
            tmp = armatureJoint.getModelTransform().clone();
        }
        MyMath.combine((Transform)result, (Transform)tmp, (Transform)result);
        this.getControl().meshTransform(tmp);
        MyMath.combine((Transform)result, (Transform)tmp, (Transform)result);
        return result;
    }

    void postRebuild(AttachmentLink oldLink) {
        assert (oldLink != null);
        this.postRebuildLink(oldLink);
        if (oldLink.isReleased()) {
            this.setDynamic(translateIdentity);
            this.release();
            PhysicsRigidBody newBody = this.getRigidBody();
            if (newBody.isInWorld()) {
                PhysicsSpace physicsSpace = this.getControl().getPhysicsSpace();
                physicsSpace.removeCollisionObject(newBody);
            }
            PhysicsRigidBody oldBody = oldLink.getRigidBody();
            this.setRigidBody(oldBody);
        }
        this.endModelTransform = (Transform)Heart.deepCopy((Object)oldLink.endModelTransform);
        this.startModelTransform.set(oldLink.startModelTransform);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.attachedModel = (Spatial)capsule.readSavable(tagAttachedModel, null);
        this.endModelTransform = (Transform)capsule.readSavable(tagEndModelTransform, (Savable)new Transform());
        this.startModelTransform = (Transform)capsule.readSavable(tagStartModelTransform, (Savable)new Transform());
    }

    @Override
    public void setRagdollMode() {
        String desiredAction = "put " + this.name() + " into ragdoll mode";
        this.getControl().verifyReadyForDynamicMode(desiredAction);
        Vector3f gravity = this.getControl().gravity(null);
        this.setDynamic(gravity);
        super.setRagdollMode();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.attachedModel, tagAttachedModel, null);
        capsule.write((Savable)this.endModelTransform, tagEndModelTransform, null);
        capsule.write((Savable)this.startModelTransform, tagStartModelTransform, null);
    }

    private Transform localModelTransform(Transform storeResult) {
        Transform boneToMesh;
        Transform result = storeResult == null ? new Transform() : storeResult;
        Vector3f location = result.getTranslation();
        Quaternion orientation = result.getRotation();
        Vector3f scale = result.getScale();
        this.getRigidBody().getTransform(result);
        Transform worldToMesh = this.getControl().meshTransform(null).invert();
        MyMath.combine((Transform)result, (Transform)worldToMesh, (Transform)result);
        Bone bone = this.getBone();
        if (bone != null) {
            boneToMesh = MySkeleton.copyMeshTransform((Bone)bone, null);
        } else {
            Joint armatureJoint = this.getArmatureJoint();
            boneToMesh = armatureJoint.getModelTransform();
        }
        Transform meshToBone = boneToMesh.invert();
        MyMath.combine((Transform)result, (Transform)meshToBone, (Transform)result);
        Vector3f modelOffset = this.localOffset(null);
        modelOffset.multLocal(scale);
        MyQuaternion.rotate((Quaternion)orientation, (Vector3f)modelOffset, (Vector3f)modelOffset);
        location.subtractLocal(modelOffset);
        return result;
    }
}

