/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.bounding.BoundingSphere;
import com.jme3.math.Vector3f;
import java.nio.FloatBuffer;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.VectorSet;

public final class CenterHeuristic
extends Enum<CenterHeuristic> {
    public static final /* enum */ CenterHeuristic AABB = new CenterHeuristic();
    public static final /* enum */ CenterHeuristic Joint = new CenterHeuristic();
    public static final /* enum */ CenterHeuristic Mean = new CenterHeuristic();
    public static final /* enum */ CenterHeuristic Sphere = new CenterHeuristic();
    private static final /* synthetic */ CenterHeuristic[] $VALUES;

    public static CenterHeuristic[] values() {
        return (CenterHeuristic[])$VALUES.clone();
    }

    public static CenterHeuristic valueOf(String name) {
        return Enum.valueOf(CenterHeuristic.class, name);
    }

    public Vector3f center(VectorSet locations, Vector3f storeResult) {
        int numVectors = locations.numVectors();
        assert (numVectors > 0) : numVectors;
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        switch (this) {
            case AABB: {
                Vector3f maxima = new Vector3f();
                Vector3f minima = new Vector3f();
                locations.maxMin(maxima, minima);
                MyVector3f.midpoint((Vector3f)maxima, (Vector3f)minima, (Vector3f)result);
                break;
            }
            case Mean: {
                locations.mean(result);
                break;
            }
            case Sphere: {
                BoundingSphere boundingSphere = new BoundingSphere();
                FloatBuffer buffer = locations.toBuffer();
                boundingSphere.computeFromPoints(buffer);
                boundingSphere.getCenter(result);
                break;
            }
            default: {
                String message = "heuristic = " + this.toString();
                throw new IllegalStateException(message);
            }
        }
        return result;
    }

    private static /* synthetic */ CenterHeuristic[] $values() {
        return new CenterHeuristic[]{AABB, Joint, Mean, Sphere};
    }

    static {
        $VALUES = CenterHeuristic.$values();
    }
}

