/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.bullet.animation.CenterHeuristic;
import com.jme3.bullet.animation.LinkConfig;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.animation.RangeOfMotion;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MySpatial;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public abstract class DacConfiguration
extends AbstractPhysicsControl {
    public static final Logger logger2 = Logger.getLogger(DacConfiguration.class.getName());
    private static final String tagAlConfigs = "alConfigs";
    private static final String tagAttachBoneNames = "attachBoneNames";
    private static final String tagAttachModels = "attachModels";
    private static final String tagBlConfigs = "blConfigs";
    private static final String tagDamping = "damping";
    private static final String tagEventDispatchImpulseThreshold = "eventDispatchImpulseThreshold";
    private static final String tagGravity = "gravity";
    private static final String tagIgnoredHops = "ignoredHops";
    private static final String tagLinkedBoneJoints = "linkedBoneJoints";
    private static final String tagLinkedBoneNames = "linkedBoneNames";
    private static final String tagMainBoneName = "mainBoneName";
    private static final String tagRelativeTolerance = "relativeTolerance";
    private static final String tagTorsoConfig = "torsoConfig";
    public static final String torsoName = "";
    private float damping = 0.6f;
    private float eventDispatchImpulseThreshold = 0.0f;
    private float relativeTolerance = 0.001f;
    private int ignoredHops = 1;
    private LinkConfig torsoConfig = new LinkConfig();
    private Map<String, LinkConfig> alConfigMap = new HashMap<String, LinkConfig>(5);
    private Map<String, LinkConfig> blConfigMap = new HashMap<String, LinkConfig>(50);
    private Map<String, RangeOfMotion> jointMap = new HashMap<String, RangeOfMotion>(50);
    private Map<String, Spatial> attachModelMap = new HashMap<String, Spatial>(5);
    private String mainBoneName = null;
    private Vector3f gravityVector = new Vector3f(0.0f, -9.8f, 0.0f);

    protected DacConfiguration() {
    }

    boolean areWithinTolerance(Vector3f scale1, Vector3f scale2) {
        boolean result = MyVector3f.areWithinTolerance((Vector3f)scale1, (Vector3f)scale2, (float)this.relativeTolerance);
        return result;
    }

    public void attach(String boneName, float mass, Spatial model) {
        Validate.nonEmpty((String)boneName, (String)"bone name");
        Validate.positive((float)mass, (String)"mass");
        RagUtils.validate(model);
        assert (MySpatial.isOrphan((Spatial)model));
        this.verifyNotAddedToSpatial("add an attachment");
        if (this.hasAttachmentLink(boneName)) {
            logger2.log(Level.WARNING, "Bone {0} already had an attachment.", MyString.quote((CharSequence)boneName));
        }
        this.attachModelMap.put(boneName, model);
        LinkConfig config = new LinkConfig(mass);
        this.alConfigMap.put(boneName, config);
    }

    public void attach(String boneName, LinkConfig config, Spatial model) {
        Validate.nonEmpty((String)boneName, (String)"bone name");
        Validate.nonNull((Object)config, (String)"configuration");
        if (config.centerHeuristic() == CenterHeuristic.Joint) {
            throw new IllegalArgumentException("Cannot center attachment on Joint.");
        }
        RagUtils.validate(model);
        assert (MySpatial.isOrphan((Spatial)model));
        this.verifyNotAddedToSpatial("add an attachment");
        if (this.hasAttachmentLink(boneName)) {
            logger2.log(Level.WARNING, "Bone {0} already had an attachment.", MyString.quote((CharSequence)boneName));
        }
        this.attachModelMap.put(boneName, model);
        this.alConfigMap.put(boneName, config);
    }

    public LinkConfig attachmentConfig(String boneName) {
        if (this.alConfigMap.containsKey(boneName)) {
            LinkConfig config = this.alConfigMap.get(boneName);
            assert (config != null);
            return config;
        }
        String msg = "No attachment link for " + MyString.quote((CharSequence)boneName);
        throw new IllegalArgumentException(msg);
    }

    public float attachmentMass(String boneName) {
        LinkConfig config = this.attachmentConfig(boneName);
        float mass = config.mass();
        return mass;
    }

    public LinkConfig config(String boneName) {
        LinkConfig result;
        if (torsoName.equals(boneName)) {
            result = this.torsoConfig;
        } else if (this.hasBoneLink(boneName)) {
            result = this.blConfigMap.get(boneName);
        } else {
            String msg = "No bone/torso named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        assert (result != null);
        return result;
    }

    public int countAttachments() {
        int count = this.alConfigMap.size();
        assert (count == this.attachModelMap.size());
        assert (count >= 0) : count;
        return count;
    }

    public int countLinkedBones() {
        int count = this.blConfigMap.size();
        assert (count == this.jointMap.size());
        assert (count >= 0) : count;
        return count;
    }

    public int countLinks() {
        int result = this.countLinkedBones() + this.countAttachments() + 1;
        return result;
    }

    public float damping() {
        assert (this.damping >= 0.0f) : this.damping;
        return this.damping;
    }

    public void detach(String boneName) {
        if (!this.hasAttachmentLink(boneName)) {
            String msg = "No attachment bone named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        this.verifyNotAddedToSpatial("unlink an attachment");
        this.alConfigMap.remove(boneName);
        this.attachModelMap.remove(boneName);
    }

    public float eventDispatchImpulseThreshold() {
        assert (this.eventDispatchImpulseThreshold >= 0.0f);
        return this.eventDispatchImpulseThreshold;
    }

    public Spatial getAttachmentModel(String boneName) {
        if (!this.attachModelMap.containsKey(boneName)) {
            String msg = "No attachment link for " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        Spatial model = this.attachModelMap.get(boneName);
        assert (model != null);
        assert (MySpatial.isOrphan((Spatial)model));
        return model;
    }

    public RangeOfMotion getJointLimits(String boneName) {
        if (!this.hasBoneLink(boneName)) {
            String msg = "No linked bone named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        RangeOfMotion result = this.jointMap.get(boneName);
        assert (result != null);
        return result;
    }

    public Vector3f gravity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.gravityVector);
        return result;
    }

    public boolean hasAttachmentLink(String boneName) {
        boolean result = boneName == null ? false : this.alConfigMap.containsKey(boneName);
        return result;
    }

    public boolean hasBoneLink(String boneName) {
        boolean result = boneName == null ? false : this.blConfigMap.containsKey(boneName);
        return result;
    }

    public int ignoredHops() {
        assert (this.ignoredHops >= 0) : this.ignoredHops;
        return this.ignoredHops;
    }

    public void link(String boneName, float mass, RangeOfMotion rom) {
        Validate.nonEmpty((String)boneName, (String)"bone name");
        Validate.positive((float)mass, (String)"mass");
        Validate.nonNull((Object)rom, (String)"range of motion");
        this.verifyNotAddedToSpatial("link a bone");
        if (this.hasBoneLink(boneName)) {
            logger2.log(Level.WARNING, "Bone {0} is already linked.", MyString.quote((CharSequence)boneName));
        }
        this.jointMap.put(boneName, rom);
        LinkConfig config = new LinkConfig(mass);
        this.blConfigMap.put(boneName, config);
    }

    public void link(String boneName, LinkConfig config, RangeOfMotion rom) {
        Validate.nonEmpty((String)boneName, (String)"bone name");
        Validate.nonNull((Object)config, (String)"configuration");
        Validate.nonNull((Object)rom, (String)"range of motion");
        this.verifyNotAddedToSpatial("link a bone");
        if (this.hasBoneLink(boneName)) {
            logger2.log(Level.WARNING, "Bone {0} is already linked.", MyString.quote((CharSequence)boneName));
        }
        this.jointMap.put(boneName, rom);
        this.blConfigMap.put(boneName, config);
    }

    public String[] listAttachmentBoneNames() {
        int size = this.countAttachments();
        String[] result = new String[size];
        Set<String> names = this.alConfigMap.keySet();
        names.toArray(result);
        return result;
    }

    public String[] listLinkedBoneNames() {
        int size = this.countLinkedBones();
        String[] result = new String[size];
        Set<String> names = this.blConfigMap.keySet();
        names.toArray(result);
        return result;
    }

    public String mainBoneName() {
        return this.mainBoneName;
    }

    public float mass(String boneName) {
        LinkConfig config = this.config(boneName);
        float mass = config.mass();
        return mass;
    }

    public float relativeTolerance() {
        assert (this.relativeTolerance >= 0.0f);
        return this.relativeTolerance;
    }

    public void setAttachmentConfig(String boneName, LinkConfig config) {
        Validate.nonNull((Object)config, (String)"configuration");
        if (!this.alConfigMap.containsKey(boneName)) {
            String msg = "No attachment link for " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        this.alConfigMap.put(boneName, config);
    }

    public void setAttachmentMass(String boneName, float mass) {
        Validate.positive((float)mass, (String)"mass");
        if (!this.alConfigMap.containsKey(boneName)) {
            String msg = "No attachment link for " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        LinkConfig config = this.alConfigMap.get(boneName);
        config = new LinkConfig(mass, config);
        this.alConfigMap.put(boneName, config);
    }

    public void setConfig(String boneName, LinkConfig config) {
        Validate.nonNull((Object)config, (String)"configuration");
        if (torsoName.equals(boneName)) {
            if (config.centerHeuristic() == CenterHeuristic.Joint) {
                throw new IllegalArgumentException("Cannot center torso on Joint.");
            }
            this.torsoConfig = config;
        } else if (this.hasBoneLink(boneName)) {
            this.blConfigMap.put(boneName, config);
        } else {
            String msg = "No bone/torso named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
    }

    public void setDamping(float dampingRatio) {
        Validate.nonNegative((float)dampingRatio, (String)"damping ratio");
        this.damping = dampingRatio;
    }

    public void setEventDispatchImpulseThreshold(float threshold) {
        Validate.nonNegative((float)threshold, (String)"threshold");
        this.eventDispatchImpulseThreshold = threshold;
    }

    public void setGravity(Vector3f gravity) {
        Validate.finite((Vector3f)gravity, (String)tagGravity);
        this.gravityVector.set(gravity);
    }

    public void setIgnoredHops(int numHops) {
        Validate.nonNegative((int)numHops, (String)"number of hops");
        this.verifyNotAddedToSpatial("alter ignored hops");
        this.ignoredHops = numHops;
    }

    public void setJointLimits(String boneName, RangeOfMotion rom) {
        Validate.nonNull((Object)rom, (String)"range of motion");
        if (!this.hasBoneLink(boneName)) {
            String msg = "No linked bone named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        this.jointMap.put(boneName, rom);
    }

    public void setMainBoneName(String boneName) {
        this.mainBoneName = boneName;
    }

    public void setMass(String boneName, float mass) {
        Validate.positive((float)mass, (String)"mass");
        if (torsoName.equals(boneName)) {
            this.torsoConfig = new LinkConfig(mass, this.torsoConfig);
        } else if (this.hasBoneLink(boneName)) {
            LinkConfig config = this.blConfigMap.get(boneName);
            config = new LinkConfig(mass, config);
            this.blConfigMap.put(boneName, config);
        } else {
            String msg = "No bone/torso named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
    }

    public void setRelativeTolerance(float newTolerance) {
        Validate.nonNegative((float)newTolerance, (String)"new tolerance");
        this.relativeTolerance = newTolerance;
    }

    public float totalMass() {
        float totalMass = this.torsoConfig.mass();
        for (LinkConfig config : this.blConfigMap.values()) {
            totalMass += config.mass();
        }
        for (LinkConfig config : this.alConfigMap.values()) {
            totalMass += config.mass();
        }
        return totalMass;
    }

    public void unlinkBone(String boneName) {
        if (!this.hasBoneLink(boneName)) {
            String msg = "No linked bone named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        this.verifyNotAddedToSpatial("unlink a bone");
        this.jointMap.remove(boneName);
        this.blConfigMap.remove(boneName);
    }

    protected void addUnlinkedDescendants(Bone startBone, Collection<Bone> addResult) {
        for (Bone child : startBone.getChildren()) {
            String childName = child.getName();
            if (this.hasBoneLink(childName)) continue;
            addResult.add(child);
            this.addUnlinkedDescendants(child, addResult);
        }
    }

    protected void addUnlinkedDescendants(Joint startJoint, Collection<Joint> addResult) {
        for (Joint child : startJoint.getChildren()) {
            String childName = child.getName();
            if (this.hasBoneLink(childName)) continue;
            addResult.add(child);
            this.addUnlinkedDescendants(child, addResult);
        }
    }

    protected String findManager(Bone startBone) {
        String managerName;
        block2: {
            Validate.nonNull((Object)startBone, (String)"start bone");
            Bone bone = startBone;
            do {
                String boneName;
                if (!this.hasBoneLink(boneName = bone.getName())) continue;
                managerName = boneName;
                break block2;
            } while ((bone = bone.getParent()) != null);
            managerName = torsoName;
        }
        assert (managerName != null);
        return managerName;
    }

    protected String findManager(Joint startJoint) {
        String managerName;
        block2: {
            Validate.nonNull((Object)startJoint, (String)"start joint");
            Joint joint = startJoint;
            do {
                String jointName;
                if (!this.hasBoneLink(jointName = joint.getName())) continue;
                managerName = jointName;
                break block2;
            } while ((joint = joint.getParent()) != null);
            managerName = torsoName;
        }
        assert (managerName != null);
        return managerName;
    }

    protected String[] managerMap(Armature armature) {
        int numJoints = armature.getJointCount();
        String[] managerMap = new String[numJoints];
        for (int jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            Joint joint = armature.getJoint(jointIndex);
            managerMap[jointIndex] = this.findManager(joint);
        }
        return managerMap;
    }

    protected String[] managerMap(Skeleton skeleton) {
        int numBones = skeleton.getBoneCount();
        String[] managerMap = new String[numBones];
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            Bone bone = skeleton.getBone(boneIndex);
            managerMap[boneIndex] = this.findManager(bone);
        }
        return managerMap;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.alConfigMap = (Map)cloner.clone(this.alConfigMap);
        this.blConfigMap = (Map)cloner.clone(this.blConfigMap);
        this.jointMap = (Map)cloner.clone(this.jointMap);
        this.attachModelMap = new HashMap<String, Spatial>(5);
        DacConfiguration originalDc = (DacConfiguration)original;
        for (Map.Entry<String, Spatial> entry : originalDc.attachModelMap.entrySet()) {
            String boneName = entry.getKey();
            Spatial spatial = entry.getValue();
            Spatial copySpatial = (Spatial)cloner.clone((Object)spatial);
            this.attachModelMap.put(boneName, copySpatial);
        }
        this.gravityVector = (Vector3f)cloner.clone((Object)this.gravityVector);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.ignoredHops = capsule.readInt(tagIgnoredHops, 1);
        this.damping = capsule.readFloat(tagDamping, 0.6f);
        this.eventDispatchImpulseThreshold = capsule.readFloat(tagEventDispatchImpulseThreshold, 0.0f);
        this.jointMap.clear();
        this.blConfigMap.clear();
        String[] linkedBoneNames = capsule.readStringArray(tagLinkedBoneNames, null);
        Savable[] linkedBoneJoints = capsule.readSavableArray(tagLinkedBoneJoints, null);
        Savable[] blConfigs = capsule.readSavableArray(tagBlConfigs, null);
        for (int i = 0; i < linkedBoneNames.length; ++i) {
            String boneName = linkedBoneNames[i];
            RangeOfMotion rom = (RangeOfMotion)linkedBoneJoints[i];
            this.jointMap.put(boneName, rom);
            this.blConfigMap.put(boneName, (LinkConfig)blConfigs[i]);
        }
        this.mainBoneName = capsule.readString(tagMainBoneName, null);
        this.attachModelMap.clear();
        this.alConfigMap.clear();
        String[] attachBoneNames = capsule.readStringArray(tagAttachBoneNames, null);
        Savable[] attachModels = capsule.readSavableArray(tagAttachModels, null);
        Savable[] alConfigs = capsule.readSavableArray(tagAlConfigs, null);
        for (int i = 0; i < attachBoneNames.length; ++i) {
            String boneName = attachBoneNames[i];
            Spatial model = (Spatial)attachModels[i];
            this.attachModelMap.put(boneName, model);
            this.alConfigMap.put(boneName, (LinkConfig)alConfigs[i]);
        }
        this.torsoConfig = (LinkConfig)capsule.readSavable(tagTorsoConfig, null);
        this.gravityVector = (Vector3f)capsule.readSavable(tagGravity, null);
        this.relativeTolerance = capsule.readFloat(tagRelativeTolerance, 0.001f);
    }

    @Override
    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        if (applyPhysicsLocal) {
            throw new UnsupportedOperationException("DynamicAnimControl does not support local physics.");
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.ignoredHops, tagIgnoredHops, 1);
        capsule.write(this.damping, tagDamping, 0.6f);
        capsule.write(this.eventDispatchImpulseThreshold, tagEventDispatchImpulseThreshold, 0.0f);
        int count = this.countLinkedBones();
        String[] linkedBoneNames = new String[count];
        Savable[] roms = new RangeOfMotion[count];
        Savable[] blConfigs = new LinkConfig[count];
        int i = 0;
        for (Map.Entry<String, LinkConfig> entry : this.blConfigMap.entrySet()) {
            linkedBoneNames[i] = entry.getKey();
            roms[i] = this.jointMap.get(entry.getKey());
            blConfigs[i] = entry.getValue();
            ++i;
        }
        capsule.write(linkedBoneNames, tagLinkedBoneNames, null);
        capsule.write(roms, tagLinkedBoneJoints, null);
        capsule.write(blConfigs, tagBlConfigs, null);
        capsule.write(this.mainBoneName, tagMainBoneName, null);
        count = this.countAttachments();
        String[] attachBoneNames = new String[count];
        Spatial[] attachModels = new Spatial[count];
        Savable[] alConfigs = new LinkConfig[count];
        i = 0;
        for (Map.Entry<String, LinkConfig> entry : this.alConfigMap.entrySet()) {
            attachBoneNames[i] = entry.getKey();
            attachModels[i] = this.attachModelMap.get(entry.getKey());
            alConfigs[i] = entry.getValue();
            ++i;
        }
        capsule.write(attachBoneNames, tagAttachBoneNames, null);
        capsule.write((Savable[])attachModels, tagAttachModels, null);
        capsule.write(alConfigs, tagAlConfigs, null);
        capsule.write((Savable)this.torsoConfig, tagTorsoConfig, null);
        capsule.write((Savable)this.gravityVector, tagGravity, null);
        capsule.write(this.relativeTolerance, tagRelativeTolerance, 0.001f);
    }

    private void verifyNotAddedToSpatial(String desiredAction) {
        assert (desiredAction != null);
        Spatial controlledSpatial = this.getSpatial();
        if (controlledSpatial != null) {
            String message = "Cannot " + desiredAction + " while the Control is added to a Spatial.";
            throw new IllegalStateException(message);
        }
    }
}

