/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.bullet.RotationOrder;
import com.jme3.bullet.animation.CenterHeuristic;
import com.jme3.bullet.animation.MassHeuristic;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.animation.ShapeHeuristic;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.MultiSphere;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Objects;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.RectangularSolid;
import jme3utilities.math.VectorSet;

public class LinkConfig
implements Comparable<LinkConfig>,
Savable {
    public static final Logger logger = Logger.getLogger(LinkConfig.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final String tagCenterHeuristic = "centerHeuristic";
    private static final String tagMassHeuristic = "massHeuristic";
    private static final String tagMassParameter = "massParameter";
    private static final String tagRotationOrder = "rotationOrder";
    private static final String tagShapeHeuristic = "shapeHeuristic";
    private static final String tagShapeScale = "shapeScale";
    private CenterHeuristic centerHeuristic;
    private float massParameter;
    private MassHeuristic massHeuristic;
    private RotationOrder rotationOrder;
    private ShapeHeuristic shapeHeuristic;
    private Vector3f shapeScale;

    public LinkConfig() {
        this.centerHeuristic = CenterHeuristic.Mean;
        this.massParameter = 1.0f;
        this.massHeuristic = MassHeuristic.Mass;
        this.rotationOrder = null;
        this.shapeHeuristic = ShapeHeuristic.VertexHull;
        this.shapeScale = new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public LinkConfig(float mass) {
        Validate.positive((float)mass, (String)"mass");
        this.centerHeuristic = CenterHeuristic.Mean;
        this.massParameter = mass;
        this.massHeuristic = MassHeuristic.Mass;
        this.rotationOrder = null;
        this.shapeHeuristic = ShapeHeuristic.VertexHull;
        this.shapeScale = new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public LinkConfig(float mass, LinkConfig oldConfig) {
        Validate.positive((float)mass, (String)"mass");
        Validate.nonNull((Object)oldConfig, (String)"old configuration");
        this.centerHeuristic = oldConfig.centerHeuristic();
        this.massParameter = mass;
        this.massHeuristic = MassHeuristic.Mass;
        this.rotationOrder = null;
        this.shapeHeuristic = oldConfig.shapeHeuristic();
        this.shapeScale = oldConfig.shapeScale(null);
    }

    public LinkConfig(float massParm, MassHeuristic massH, ShapeHeuristic shapeH, Vector3f sScale, CenterHeuristic centerH) {
        Validate.positive((float)massParm, (String)"mass parameter");
        Validate.nonNull((Object)((Object)massH), (String)"mass heuristic");
        Validate.nonNull((Object)((Object)shapeH), (String)"shape heuristic");
        Validate.nonNegative((Vector3f)sScale, (String)"shape scale");
        Validate.nonNull((Object)((Object)centerH), (String)"center heuristic");
        this.centerHeuristic = centerH;
        this.massParameter = massParm;
        this.massHeuristic = massH;
        this.rotationOrder = null;
        this.shapeHeuristic = shapeH;
        this.shapeScale = sScale.clone();
    }

    public LinkConfig(float massParm, MassHeuristic massH, ShapeHeuristic shapeH, Vector3f sScale, CenterHeuristic centerH, RotationOrder axisOrder) {
        Validate.positive((float)massParm, (String)"mass parameter");
        Validate.nonNull((Object)((Object)massH), (String)"mass heuristic");
        Validate.nonNull((Object)((Object)shapeH), (String)"shape heuristic");
        Validate.nonNegative((Vector3f)sScale, (String)"shape scale");
        Validate.nonNull((Object)((Object)centerH), (String)"center heuristic");
        this.centerHeuristic = centerH;
        this.massParameter = massParm;
        this.massHeuristic = massH;
        this.rotationOrder = axisOrder;
        this.shapeHeuristic = shapeH;
        this.shapeScale = sScale.clone();
    }

    public CenterHeuristic centerHeuristic() {
        assert (this.centerHeuristic != null);
        return this.centerHeuristic;
    }

    CollisionShape createShape(Transform vertexToShape, Vector3f center, VectorSet vertexLocations) {
        CollisionShape result;
        Validate.nonNull((Object)vertexToShape, (String)"transform");
        Validate.finite((Vector3f)center, (String)"center");
        int numVectors = vertexLocations.numVectors();
        assert (numVectors > 0) : numVectors;
        Vector3f tempLocation = new Vector3f();
        FloatBuffer buffer = vertexLocations.toBuffer();
        buffer.rewind();
        while (buffer.hasRemaining()) {
            buffer.mark();
            tempLocation.x = buffer.get();
            tempLocation.y = buffer.get();
            tempLocation.z = buffer.get();
            tempLocation.subtractLocal(center);
            MyMath.transform((Transform)vertexToShape, (Vector3f)tempLocation, (Vector3f)tempLocation);
            switch (this.shapeHeuristic) {
                case AABB: 
                case Sphere: 
                case VertexHull: {
                    tempLocation.multLocal(this.shapeScale);
                    break;
                }
            }
            buffer.reset();
            buffer.put(tempLocation.x);
            buffer.put(tempLocation.y);
            buffer.put(tempLocation.z);
        }
        switch (this.shapeHeuristic) {
            case AABB: {
                Vector3f maxima = new Vector3f();
                Vector3f minima = new Vector3f();
                vertexLocations.maxMin(maxima, minima);
                RectangularSolid solid = new RectangularSolid(minima, maxima, rotateIdentity);
                result = new HullCollisionShape(solid);
                break;
            }
            case Cylinder: {
                result = RagUtils.makeCylinder(vertexLocations, this.shapeScale);
                break;
            }
            case FourSphere: {
                RectangularSolid solid = RagUtils.makeRectangularSolid(vertexLocations, this.shapeScale);
                result = new MultiSphere(solid);
                break;
            }
            case MinBox: {
                RectangularSolid solid = RagUtils.makeRectangularSolid(vertexLocations, this.shapeScale);
                result = new HullCollisionShape(solid);
                break;
            }
            case Sphere: {
                float radius = vertexLocations.maxLength();
                result = new MultiSphere(radius);
                break;
            }
            case TwoSphere: {
                RectangularSolid solid = RagUtils.makeRectangularSolid(vertexLocations, this.shapeScale);
                result = new MultiSphere(solid, 0.5f);
                break;
            }
            case VertexHull: {
                result = new HullCollisionShape(buffer);
                break;
            }
            default: {
                String message = "heuristic = " + (Object)((Object)this.shapeHeuristic);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public float mass() {
        float result = Float.NaN;
        if (this.massHeuristic == MassHeuristic.Mass) {
            assert (this.massParameter > 0.0f) : this.massParameter;
            result = this.massParameter;
        }
        return result;
    }

    float mass(float volume) {
        float mass;
        Validate.nonNegative((float)volume, (String)"volume");
        switch (this.massHeuristic) {
            case Density: {
                if (volume == 0.0f) {
                    mass = 1.0E-6f;
                    break;
                }
                mass = this.massParameter * volume;
                break;
            }
            case Mass: {
                mass = this.massParameter;
                break;
            }
            default: {
                String message = "heuristic = " + (Object)((Object)this.massHeuristic);
                throw new IllegalArgumentException(message);
            }
        }
        assert (mass > 0.0f) : mass;
        return mass;
    }

    public MassHeuristic massHeuristic() {
        assert (this.massHeuristic != null);
        return this.massHeuristic;
    }

    public float massParameter() {
        assert (this.massParameter > 0.0f) : this.massParameter;
        return this.massParameter;
    }

    public RotationOrder rotationOrder() {
        return this.rotationOrder;
    }

    public ShapeHeuristic shapeHeuristic() {
        assert (this.shapeHeuristic != null);
        return this.shapeHeuristic;
    }

    public Vector3f shapeScale(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.shapeScale);
        return result;
    }

    @Override
    public int compareTo(LinkConfig other) {
        int result = this.centerHeuristic.compareTo(other.centerHeuristic());
        if (result != 0) {
            return result;
        }
        result = Float.compare(this.massParameter, other.massParameter());
        if (result != 0) {
            return result;
        }
        result = this.massHeuristic.compareTo(other.massHeuristic());
        if (result != 0) {
            return result;
        }
        RotationOrder otherOrder = other.rotationOrder();
        if (this.rotationOrder == null && otherOrder != null) {
            return 1;
        }
        if (otherOrder == null && this.rotationOrder != null) {
            return -1;
        }
        if (this.rotationOrder != null && otherOrder != null && (result = this.rotationOrder.compareTo(otherOrder)) != 0) {
            return result;
        }
        result = this.shapeHeuristic.compareTo(other.shapeHeuristic());
        if (result != 0) {
            return result;
        }
        result = Float.compare(this.shapeScale.x, other.shapeScale.x);
        if (result != 0) {
            return result;
        }
        result = Float.compare(this.shapeScale.y, other.shapeScale.y);
        if (result != 0) {
            return result;
        }
        result = Float.compare(this.shapeScale.z, other.shapeScale.z);
        return result;
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.centerHeuristic = (CenterHeuristic)capsule.readEnum(tagCenterHeuristic, CenterHeuristic.class, (Enum)CenterHeuristic.Mean);
        this.massParameter = capsule.readFloat(tagMassParameter, 1.0f);
        this.massHeuristic = (MassHeuristic)capsule.readEnum(tagMassHeuristic, MassHeuristic.class, (Enum)MassHeuristic.Mass);
        this.rotationOrder = (RotationOrder)capsule.readEnum(tagRotationOrder, RotationOrder.class, null);
        this.shapeHeuristic = (ShapeHeuristic)capsule.readEnum(tagShapeHeuristic, ShapeHeuristic.class, (Enum)ShapeHeuristic.VertexHull);
        this.shapeScale = (Vector3f)capsule.readSavable(tagShapeScale, null);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Enum)this.centerHeuristic, tagCenterHeuristic, (Enum)CenterHeuristic.Mean);
        capsule.write(this.massParameter, tagMassParameter, 1.0f);
        capsule.write((Enum)this.massHeuristic, tagMassHeuristic, (Enum)MassHeuristic.Mass);
        capsule.write((Enum)this.rotationOrder, tagRotationOrder, null);
        capsule.write((Enum)this.shapeHeuristic, tagShapeHeuristic, (Enum)ShapeHeuristic.VertexHull);
        capsule.write((Savable)this.shapeScale, tagShapeScale, null);
    }

    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            LinkConfig other = (LinkConfig)otherObject;
            float massP = other.massParameter();
            result = this.centerHeuristic == other.centerHeuristic() && Float.compare(this.massParameter, massP) == 0 && this.massHeuristic == other.massHeuristic() && this.rotationOrder == other.rotationOrder() && this.shapeHeuristic == other.shapeHeuristic() && this.shapeScale.equals((Object)other.shapeScale);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int hash = 17 + Objects.hashCode((Object)this.centerHeuristic);
        hash = 11 * hash + Float.floatToIntBits(this.massParameter);
        hash = 11 * hash + Objects.hashCode((Object)this.massHeuristic);
        hash = 11 * hash + Objects.hashCode((Object)this.rotationOrder);
        hash = 11 * hash + Objects.hashCode((Object)this.shapeHeuristic);
        hash = 11 * hash + Objects.hashCode(this.shapeScale);
        return hash;
    }
}

