/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Transform;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PreComposer
extends AbstractControl {
    public static final Logger logger = Logger.getLogger(PreComposer.class.getName());
    private static final String tagDac = "dac";
    private static final String tagHaveSaved = "haveSaved";
    private static final String tagSavedTransforms = "savedTransforms";
    private boolean haveSaved = false;
    private DacLinks dac;
    private Transform[] savedTransforms;

    protected PreComposer() {
    }

    PreComposer(DacLinks dac) {
        Validate.nonNull((Object)dac, (String)tagDac);
        this.dac = dac;
    }

    void saveArmature() {
        int jointIndex;
        Armature armature = this.dac.getArmature();
        int numJoints = armature.getJointCount();
        if (this.savedTransforms == null) {
            this.savedTransforms = new Transform[numJoints];
            for (jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
                this.savedTransforms[jointIndex] = new Transform();
            }
        } else assert (this.savedTransforms.length == numJoints) : numJoints;
        for (jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            Joint joint = armature.getJoint(jointIndex);
            Transform t = joint.getLocalTransform();
            this.savedTransforms[jointIndex].set(t);
        }
        this.haveSaved = true;
    }

    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.dac = (DacLinks)cloner.clone((Object)this.dac);
        this.savedTransforms = (Transform[])cloner.clone((Object)this.savedTransforms);
    }

    protected void controlUpdate(float tpf) {
        if (!this.haveSaved) {
            return;
        }
        Armature armature = this.dac.getArmature();
        int numJoints = armature.getJointCount();
        assert (this.savedTransforms.length == numJoints) : numJoints;
        for (int jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            Joint joint = armature.getJoint(jointIndex);
            Transform t = this.savedTransforms[jointIndex];
            joint.setLocalTransform(t);
        }
        this.haveSaved = false;
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.haveSaved = capsule.readBoolean(tagHaveSaved, false);
        this.dac = (DacLinks)capsule.readSavable(tagDac, null);
        this.savedTransforms = RagUtils.readTransformArray(capsule, tagSavedTransforms);
    }

    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.haveSaved, tagHaveSaved, false);
        capsule.write((Savable)this.dac, tagDac, null);
        capsule.write((Savable[])this.savedTransforms, tagSavedTransforms, null);
    }
}

