/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Joint;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.KinematicSubmode;
import com.jme3.bullet.animation.LinkConfig;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Heart;
import jme3utilities.MySkeleton;
import jme3utilities.MySpatial;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyQuaternion;

public class TorsoLink
extends PhysicsLink {
    public static final Logger logger2 = Logger.getLogger(TorsoLink.class.getName());
    private static final String tagEndBoneTransforms = "endBoneTransforms";
    private static final String tagEndModelTransform = "endModelTransform";
    private static final String tagManagedArmatureJoints = "managedArmatureJoints";
    private static final String tagManagedBones = "managedBones";
    private static final String tagMeshToModel = "meshToModel";
    private static final String tagPrevBoneTransforms = "prevBoneTransforms";
    private static final String tagStartBoneTransforms = "startBoneTransforms";
    private static final String tagStartModelTransform = "startModelTransform";
    private static final String tagSubmode = "submode";
    private Bone[] managedBones = null;
    private Joint[] managedArmatureJoints = null;
    private KinematicSubmode submode = KinematicSubmode.Animated;
    private Transform endModelTransform = null;
    private Transform meshToModel = null;
    private Transform startModelTransform = new Transform();
    private Transform[] endBoneTransforms = null;
    private Transform[] prevBoneTransforms = null;
    private Transform[] startBoneTransforms = null;

    protected TorsoLink() {
    }

    TorsoLink(DacLinks control, Bone mainRootBone, CollisionShape collisionShape, LinkConfig linkConfig, Transform meshToModel, Vector3f localOffset) {
        super(control, mainRootBone, collisionShape, linkConfig, localOffset);
        this.meshToModel = meshToModel.clone();
        this.managedBones = control.listManagedBones("");
        int numManaged = this.countManaged();
        this.startBoneTransforms = new Transform[numManaged];
        for (int i = 0; i < numManaged; ++i) {
            this.startBoneTransforms[i] = new Transform();
        }
    }

    TorsoLink(DacLinks control, Joint mainRootJoint, CollisionShape collisionShape, LinkConfig linkConfig, Transform meshToModel, Vector3f localOffset) {
        super(control, mainRootJoint, collisionShape, linkConfig, localOffset);
        this.meshToModel = meshToModel.clone();
        this.managedArmatureJoints = control.listManagedArmatureJoints("");
        int numManagedJoints = this.managedArmatureJoints.length;
        this.startBoneTransforms = new Transform[numManagedJoints];
        for (int i = 0; i < numManagedJoints; ++i) {
            this.startBoneTransforms[i] = new Transform();
        }
    }

    public void blendToKinematicMode(KinematicSubmode submode, float blendInterval, Transform endModelTransform) {
        Validate.nonNull((Object)((Object)submode), (String)tagSubmode);
        Validate.nonNegative((float)blendInterval, (String)"blend interval");
        this.blendToKinematicMode(blendInterval);
        this.submode = submode;
        this.endModelTransform = endModelTransform;
        if (endModelTransform != null) {
            Transform current = this.getControl().getSpatial().getLocalTransform();
            this.startModelTransform.set(current);
        }
        int numManaged = this.countManaged();
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            Transform transform = this.prevBoneTransforms == null ? this.copyManagedTransform(managedIndex, null) : this.prevBoneTransforms[managedIndex];
            this.startBoneTransforms[managedIndex].set(transform);
        }
        if (submode == KinematicSubmode.Animated) {
            this.setUserControl(false);
        } else {
            this.setUserControl(true);
        }
    }

    public int boneIndex(int managedIndex) {
        int result;
        int numManaged = this.countManaged();
        Validate.inRange((int)managedIndex, (String)"managed index", (int)0, (int)(numManaged - 1));
        if (this.managedBones != null) {
            Bone managed = this.managedBones[managedIndex];
            Skeleton skeleton = this.getControl().getSkeleton();
            result = skeleton.getBoneIndex(managed);
        } else {
            Joint managed = this.managedArmatureJoints[managedIndex];
            result = managed.getId();
        }
        assert (result >= 0) : result;
        return result;
    }

    public final int countManaged() {
        int result = this.managedBones != null ? this.managedBones.length : this.managedArmatureJoints.length;
        assert (result >= 1) : result;
        return result;
    }

    public void setEndBoneTransforms(Transform[] transforms) {
        Validate.nonNull((Object)transforms, (String)"transforms");
        int numManaged = this.countManaged();
        Validate.require((transforms.length == numManaged ? 1 : 0) != 0, (String)"one element for each managed bone");
        this.endBoneTransforms = transforms;
    }

    public void setLocalTransform(int mbIndex, Transform localTransform) {
        int numManaged = this.countManaged();
        Validate.inRange((int)mbIndex, (String)"index", (int)1, (int)(numManaged - 1));
        if (this.prevBoneTransforms != null) {
            this.prevBoneTransforms[mbIndex].set(localTransform);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.managedBones = (Bone[])cloner.clone((Object)this.managedBones);
        this.managedArmatureJoints = (Joint[])cloner.clone((Object)this.managedArmatureJoints);
        this.endModelTransform = (Transform)cloner.clone((Object)this.endModelTransform);
        this.meshToModel = (Transform)cloner.clone((Object)this.meshToModel);
        this.endBoneTransforms = (Transform[])cloner.clone((Object)this.endBoneTransforms);
        this.prevBoneTransforms = (Transform[])cloner.clone((Object)this.prevBoneTransforms);
        this.startBoneTransforms = (Transform[])cloner.clone((Object)this.startBoneTransforms);
        this.startModelTransform = (Transform)cloner.clone((Object)this.startModelTransform);
    }

    @Override
    protected void dynamicUpdate() {
        Transform worldToParent;
        assert (!this.getRigidBody().isKinematic());
        DacLinks control = this.getControl();
        Spatial spatial = control.getSpatial();
        Node parent = spatial.getParent();
        if (parent == null) {
            worldToParent = new Transform();
        } else {
            Transform parentToWorld = MySpatial.worldTransform((Spatial)parent, null);
            worldToParent = parentToWorld.invert();
        }
        Transform shapeToWorld = this.getRigidBody().getTransform(null);
        Transform transform = MyMath.combine((Transform)this.meshToModel, (Transform)shapeToWorld, null);
        MyMath.combine((Transform)transform, (Transform)worldToParent, (Transform)transform);
        spatial.setLocalTransform(transform);
        int numManaged = this.countManaged();
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            Transform t = this.prevBoneTransforms[managedIndex];
            this.setManagedTransform(managedIndex, t);
        }
        this.localBoneTransform(transform);
        if (this.managedBones != null) {
            MySkeleton.setLocalTransform((Bone)this.getBone(), (Transform)transform);
            for (Bone managed : this.managedBones) {
                managed.updateModelTransforms();
            }
        } else {
            this.getArmatureJoint().setLocalTransform(transform);
            for (Joint managed : this.managedArmatureJoints) {
                managed.updateModelTransforms();
            }
        }
    }

    @Override
    public void freeze(boolean forceKinematic) {
        this.blendToKinematicMode(KinematicSubmode.Frozen, 0.0f, null);
    }

    @Override
    protected void kinematicUpdate(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        assert (this.getRigidBody().isKinematic());
        Transform transform = new Transform();
        if (this.endModelTransform != null) {
            Quaternion startQuat = this.startModelTransform.getRotation();
            MyQuaternion.normalizeLocal((Quaternion)startQuat);
            Quaternion endQuat = this.endModelTransform.getRotation();
            if (startQuat.dot(endQuat) < 0.0f) {
                endQuat.multLocal(-1.0f);
            }
            MyQuaternion.normalizeLocal((Quaternion)endQuat);
            MyMath.slerp((float)this.kinematicWeight(), (Transform)this.startModelTransform, (Transform)this.endModelTransform, (Transform)transform);
            this.getControl().getSpatial().setLocalTransform(transform);
        }
        int numManaged = this.countManaged();
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            switch (this.submode) {
                case Amputated: {
                    int boneIndex = this.boneIndex(managedIndex);
                    this.getControl().copyBindTransform(boneIndex, transform);
                    transform.setScale(0.001f);
                    break;
                }
                case Animated: {
                    this.copyManagedTransform(managedIndex, transform);
                    break;
                }
                case Bound: {
                    int boneIndex = this.boneIndex(managedIndex);
                    this.getControl().copyBindTransform(boneIndex, transform);
                    break;
                }
                case Frozen: {
                    transform.set(this.prevBoneTransforms[managedIndex]);
                    break;
                }
                case Reset: {
                    transform.set(this.endBoneTransforms[managedIndex]);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.submode.toString());
                }
            }
            if (this.kinematicWeight() < 1.0f) {
                Transform start = this.startBoneTransforms[managedIndex];
                Quaternion startQuat = start.getRotation();
                MyQuaternion.normalizeLocal((Quaternion)startQuat);
                Quaternion endQuat = transform.getRotation();
                if (startQuat.dot(endQuat) < 0.0f) {
                    endQuat.multLocal(-1.0f);
                }
                MyQuaternion.normalizeLocal((Quaternion)endQuat);
                MyMath.slerp((float)this.kinematicWeight(), (Transform)start, (Transform)transform, (Transform)transform);
            } else {
                this.endModelTransform = null;
            }
            this.setManagedTransform(managedIndex, transform);
        }
        super.kinematicUpdate(tpf);
    }

    @Override
    public String name() {
        return "Torso:";
    }

    void postRebuild(TorsoLink oldLink) {
        int numManaged = this.countManaged();
        assert (oldLink.countManaged() == numManaged);
        this.postRebuildLink(oldLink);
        this.submode = oldLink.isKinematic() ? oldLink.submode : KinematicSubmode.Frozen;
        this.endModelTransform = (Transform)Heart.deepCopy((Object)oldLink.endModelTransform);
        this.startModelTransform.set(oldLink.startModelTransform);
        this.endBoneTransforms = (Transform[])Heart.deepCopy((Object)oldLink.endBoneTransforms);
        this.prevBoneTransforms = (Transform[])Heart.deepCopy((Object)oldLink.prevBoneTransforms);
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            Transform transform = oldLink.startBoneTransforms[managedIndex];
            this.startBoneTransforms[managedIndex].set(transform);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        int managedI;
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        Savable[] tmp = capsule.readSavableArray(tagManagedArmatureJoints, null);
        if (tmp != null) {
            this.managedArmatureJoints = new Joint[tmp.length];
            for (managedI = 0; managedI < tmp.length; ++managedI) {
                this.managedArmatureJoints[managedI] = (Joint)tmp[managedI];
            }
        }
        if ((tmp = capsule.readSavableArray(tagManagedBones, null)) != null) {
            this.managedBones = new Bone[tmp.length];
            for (managedI = 0; managedI < tmp.length; ++managedI) {
                this.managedBones[managedI] = (Bone)tmp[managedI];
            }
        }
        this.submode = (KinematicSubmode)capsule.readEnum(tagSubmode, KinematicSubmode.class, (Enum)KinematicSubmode.Animated);
        this.endModelTransform = (Transform)capsule.readSavable(tagEndModelTransform, (Savable)new Transform());
        this.meshToModel = (Transform)capsule.readSavable(tagMeshToModel, (Savable)new Transform());
        this.startModelTransform = (Transform)capsule.readSavable(tagStartModelTransform, (Savable)new Transform());
        this.endBoneTransforms = RagUtils.readTransformArray(capsule, tagEndBoneTransforms);
        this.prevBoneTransforms = RagUtils.readTransformArray(capsule, tagPrevBoneTransforms);
        this.startBoneTransforms = RagUtils.readTransformArray(capsule, tagStartBoneTransforms);
    }

    @Override
    public void setDynamic(Vector3f uniformAcceleration) {
        Validate.finite((Vector3f)uniformAcceleration, (String)"uniform acceleration");
        String desiredAction = "put " + this.name() + " into dynamic mode";
        this.getControl().verifyReadyForDynamicMode(desiredAction);
        super.setDynamic(uniformAcceleration);
        this.setUserControl(true);
    }

    @Override
    public void setRagdollMode() {
        String desiredAction = "put " + this.name() + " into ragdoll mode";
        this.getControl().verifyReadyForDynamicMode(desiredAction);
        Vector3f gravity = this.getControl().gravity(null);
        this.setDynamic(gravity);
        super.setRagdollMode();
    }

    @Override
    void update(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        int numManaged = this.countManaged();
        if (this.prevBoneTransforms == null) {
            this.prevBoneTransforms = new Transform[numManaged];
            for (int managedI = 0; managedI < numManaged; ++managedI) {
                Transform boneTransform;
                this.prevBoneTransforms[managedI] = boneTransform = this.copyManagedTransform(managedI, null);
            }
        }
        super.update(tpf);
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            Transform lastTransform = this.prevBoneTransforms[managedIndex];
            this.copyManagedTransform(managedIndex, lastTransform);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable[])this.managedArmatureJoints, tagManagedArmatureJoints, null);
        capsule.write((Savable[])this.managedBones, tagManagedBones, null);
        capsule.write((Enum)this.submode, tagSubmode, (Enum)KinematicSubmode.Animated);
        capsule.write((Savable)this.endModelTransform, tagEndModelTransform, (Savable)new Transform());
        capsule.write((Savable)this.meshToModel, tagMeshToModel, (Savable)new Transform());
        capsule.write((Savable)this.startModelTransform, tagStartModelTransform, (Savable)new Transform());
        capsule.write((Savable[])this.endBoneTransforms, tagEndBoneTransforms, null);
        capsule.write((Savable[])this.prevBoneTransforms, tagPrevBoneTransforms, (Savable[])new Transform[0]);
        capsule.write((Savable[])this.startBoneTransforms, tagStartBoneTransforms, (Savable[])new Transform[0]);
    }

    private Transform copyManagedTransform(int managedIndex, Transform storeResult) {
        Transform result;
        Transform transform = result = storeResult == null ? new Transform() : storeResult;
        if (this.managedBones != null) {
            Bone managed = this.managedBones[managedIndex];
            MySkeleton.copyLocalTransform((Bone)managed, (Transform)result);
        } else {
            Joint managed = this.managedArmatureJoints[managedIndex];
            Transform local = managed.getLocalTransform();
            result.set(local);
        }
        return result;
    }

    private Transform localBoneTransform(Transform storeResult) {
        Bone parent;
        Transform result = storeResult == null ? new Transform() : storeResult;
        Vector3f location = result.getTranslation();
        Quaternion orientation = result.getRotation();
        Vector3f scale = result.getScale();
        this.getRigidBody().getTransform(result);
        Transform worldToMesh = this.getControl().meshTransform(null).invert();
        MyMath.combine((Transform)result, (Transform)worldToMesh, (Transform)result);
        if (this.managedBones != null) {
            parent = this.getBone().getParent();
            if (parent != null) {
                RagUtils.meshToLocal(parent, result);
            }
        } else {
            parent = this.getArmatureJoint().getParent();
            if (parent != null) {
                RagUtils.meshToLocal((Joint)parent, result);
            }
        }
        Vector3f meshOffset = this.localOffset(null);
        meshOffset.multLocal(scale);
        MyQuaternion.rotate((Quaternion)orientation, (Vector3f)meshOffset, (Vector3f)meshOffset);
        location.subtractLocal(meshOffset);
        return result;
    }

    private void setManagedTransform(int managedIndex, Transform transform) {
        if (this.managedBones != null) {
            Bone managed = this.managedBones[managedIndex];
            MySkeleton.setLocalTransform((Bone)managed, (Transform)transform);
            managed.updateModelTransforms();
        } else {
            Joint managed = this.managedArmatureJoints[managedIndex];
            managed.setLocalTransform(transform);
            managed.updateModelTransforms();
        }
    }

    private void setUserControl(boolean wantUserControl) {
        if (this.managedBones != null) {
            for (Bone managed : this.managedBones) {
                managed.setUserControl(wantUserControl);
            }
        }
    }
}

