/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.CollisionSpace;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.debug.DebugMeshInitListener;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;
import jme3utilities.Validate;

public abstract class PhysicsCollisionObject
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final int COLLISION_GROUP_NONE = 0;
    public static final int COLLISION_GROUP_01 = 1;
    public static final int COLLISION_GROUP_02 = 2;
    public static final int COLLISION_GROUP_03 = 4;
    public static final int COLLISION_GROUP_04 = 8;
    public static final int COLLISION_GROUP_05 = 16;
    public static final int COLLISION_GROUP_06 = 32;
    public static final int COLLISION_GROUP_07 = 64;
    public static final int COLLISION_GROUP_08 = 128;
    public static final int COLLISION_GROUP_09 = 256;
    public static final int COLLISION_GROUP_10 = 512;
    public static final int COLLISION_GROUP_11 = 1024;
    public static final int COLLISION_GROUP_12 = 2048;
    public static final int COLLISION_GROUP_13 = 4096;
    public static final int COLLISION_GROUP_14 = 8192;
    public static final int COLLISION_GROUP_15 = 16384;
    public static final int COLLISION_GROUP_16 = 32768;
    public static final Logger logger = Logger.getLogger(PhysicsCollisionObject.class.getName());
    private static final String tagAnisotropicFrictionComponents = "anisotropicFrictionComponents";
    private static final String tagAnisotropicFrictionMode = "anisotropicFrictionMode";
    private static final String tagApplicationData = "applicationData";
    private static final String tagCcdMotionThreshold = "ccdMotionThreshold";
    private static final String tagCcdSweptSphereRadius = "ccdSweptSphereRadius";
    private static final String tagCollisionGroup = "collisionGroup";
    private static final String tagCollisionGroupsMask = "collisionGroupsMask";
    private static final String tagCollisionShape = "collisionShape";
    private static final String tagContactDamping = "contactDamping";
    private static final String tagContactProcessingThreshold = "contactProcessingThreshold";
    private static final String tagContactStiffness = "contactStiffness";
    private static final String tagDeactivationTime = "deactivationTime";
    private static final String tagDebugMaterial = "debugMaterial";
    private static final String tagDebugMeshNormals = "debugMeshNormals";
    private static final String tagDebugMeshResolution = "debugMeshResolution";
    private static final String tagHasCsd = "hasCsd";
    private static final String tagFriction = "friction";
    private static final String tagIgnoreList = "ignoreList";
    private static final String tagRestitution = "restitution";
    private static final String tagRollingFriction = "rollingFriction";
    private static final String tagSpinningFriction = "spinningFriction";
    private static final String tagUserIndex = "userIndex";
    private static final String tagUserIndex2 = "userIndex2";
    private static final String tagUserIndex3 = "userIndex3";
    private static final String tagUserObject = "userObject";
    private Collection<PhysicsCollisionObject> ignoreList;
    private CollisionShape collisionShape;
    private DebugMeshInitListener debugMeshInitListener = null;
    private int collideWithGroups = 1;
    private int collisionGroup = 1;
    private int debugMeshResolution = 0;
    private int debugNumSides = 1;
    private Material debugMaterial = null;
    private MeshNormals debugMeshNormals = MeshNormals.None;
    private Object applicationData = null;
    private Object userObject = null;

    protected PhysicsCollisionObject() {
    }

    public void activate(boolean forceFlag) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.activate(objectId, forceFlag);
    }

    public void addCollideWithGroup(int collisionGroup) {
        this.collideWithGroups |= collisionGroup;
        if (this.hasAssignedNativeObject()) {
            long objectId = this.nativeId();
            PhysicsCollisionObject.setCollideWithGroups(objectId, this.collideWithGroups);
        }
    }

    public void addToIgnoreList(PhysicsCollisionObject otherPco) {
        Validate.nonNull((Object)otherPco, (String)"other collision object");
        Validate.require((otherPco != this ? 1 : 0) != 0, (String)"2 distinct collision objects");
        if (this.ignoreList == null) {
            this.ignoreList = new TreeSet<PhysicsCollisionObject>();
        }
        if (!this.ignoreList.contains(otherPco)) {
            this.ignoreList.add(otherPco);
            if (otherPco.ignoreList == null) {
                otherPco.ignoreList = new TreeSet<PhysicsCollisionObject>();
            }
            assert (!otherPco.ignoreList.contains(this));
            otherPco.ignoreList.add(this);
            long thisId = this.nativeId();
            long otherId = otherPco.nativeId();
            boolean toIgnore = true;
            PhysicsCollisionObject.setIgnoreCollisionCheck(thisId, otherId, toIgnore);
        }
    }

    public BoundingBox boundingBox(BoundingBox storeResult) {
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        Vector3f translation = this.getPhysicsLocation(null);
        Matrix3f rotation = this.getPhysicsRotationMatrix(null);
        this.collisionShape.boundingBox(translation, rotation, result);
        return result;
    }

    public void clearIgnoreList() {
        long thisId = this.nativeId();
        if (this.ignoreList != null && !this.ignoreList.isEmpty()) {
            boolean toIgnore = false;
            for (PhysicsCollisionObject otherPco : this.ignoreList) {
                long otherId = otherPco.nativeId();
                PhysicsCollisionObject.setIgnoreCollisionCheck(thisId, otherId, toIgnore);
                assert (otherPco.ignoreList.contains(this));
                otherPco.ignoreList.remove(this);
            }
            this.ignoreList.clear();
        }
    }

    public int collisionFlags() {
        long objectId = this.nativeId();
        int result = PhysicsCollisionObject.getCollisionFlags(objectId);
        return result;
    }

    public final void copyPcoProperties(PhysicsCollisionObject old) {
        assert (old.hasAssignedNativeObject());
        assert (old.nativeId() != this.nativeId());
        int flags = old.collisionFlags();
        boolean hasCsd = (flags & 0x80) != 0;
        this.setCcdMotionThreshold(old.getCcdMotionThreshold());
        this.setCcdSweptSphereRadius(old.getCcdSweptSphereRadius());
        if (hasCsd) {
            this.setContactDamping(old.getContactDamping());
        }
        this.setContactProcessingThreshold(old.getContactProcessingThreshold());
        if (hasCsd) {
            this.setContactStiffness(old.getContactStiffness());
        }
        this.setDeactivationTime(old.getDeactivationTime());
        this.setFriction(old.getFriction());
        this.setRestitution(old.getRestitution());
        this.setRollingFriction(old.getRollingFriction());
        this.setSpinningFriction(old.getSpinningFriction());
        this.setUserIndex(old.userIndex());
        this.setUserIndex2(old.userIndex2());
        this.setUserIndex3(old.userIndex3());
        if (old.hasAnisotropicFriction(1)) {
            this.setAnisotropicFriction(old.getAnisotropicFriction(null), 1);
        } else if (old.hasAnisotropicFriction(2)) {
            this.setAnisotropicFriction(old.getAnisotropicFriction(null), 2);
        }
    }

    public int countIgnored() {
        int result;
        int n = result = this.ignoreList == null ? 0 : this.ignoreList.size();
        assert (this.checkIgnoreList());
        assert (result >= 0) : result;
        return result;
    }

    public DebugMeshInitListener debugMeshInitListener() {
        return this.debugMeshInitListener;
    }

    public MeshNormals debugMeshNormals() {
        assert (this.debugMeshNormals != null);
        return this.debugMeshNormals;
    }

    public int debugMeshResolution() {
        assert (this.debugMeshResolution >= 0) : this.debugMeshResolution;
        assert (this.debugMeshResolution <= 2) : this.debugMeshResolution;
        return this.debugMeshResolution;
    }

    public int debugNumSides() {
        assert (this.debugNumSides >= 0) : this.debugNumSides;
        assert (this.debugNumSides <= 2) : this.debugNumSides;
        return this.debugNumSides;
    }

    public static native PhysicsCollisionObject findInstance(long var0);

    public int getActivationState() {
        long objectId = this.nativeId();
        int result = PhysicsCollisionObject.getActivationState(objectId);
        assert (result >= 1) : result;
        assert (result <= 5) : result;
        return result;
    }

    public Vector3f getAnisotropicFriction(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getAnisotropicFriction(objectId, result);
        return result;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public float getCcdMotionThreshold() {
        long objectId = this.nativeId();
        float distance = PhysicsCollisionObject.getCcdMotionThreshold(objectId);
        assert (distance >= 0.0f) : distance;
        return distance;
    }

    public float getCcdSquareMotionThreshold() {
        float distance = this.getCcdMotionThreshold();
        float dSquared = distance * distance;
        return dSquared;
    }

    public float getCcdSweptSphereRadius() {
        long objectId = this.nativeId();
        float radius = PhysicsCollisionObject.getCcdSweptSphereRadius(objectId);
        assert (radius >= 0.0f) : radius;
        return radius;
    }

    public int getCollideWithGroups() {
        assert (this.collideWithGroups == PhysicsCollisionObject.getCollideWithGroups(this.nativeId()));
        return this.collideWithGroups;
    }

    public int getCollisionGroup() {
        assert (this.collisionGroup == PhysicsCollisionObject.getCollisionGroup(this.nativeId()));
        assert (Integer.bitCount(this.collisionGroup) == 1) : this.collisionGroup;
        return this.collisionGroup;
    }

    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public CollisionSpace getCollisionSpace() {
        CollisionSpace result = null;
        if (this.spaceId() != 0L) {
            long objectId = this.nativeId();
            result = PhysicsCollisionObject.getCollisionSpace(objectId);
        }
        return result;
    }

    public float getContactDamping() {
        long objectId = this.nativeId();
        float damping = PhysicsCollisionObject.getContactDamping(objectId);
        return damping;
    }

    public float getContactProcessingThreshold() {
        long objectId = this.nativeId();
        float distance = PhysicsCollisionObject.getContactProcessingThreshold(objectId);
        return distance;
    }

    public float getContactStiffness() {
        long objectId = this.nativeId();
        float stiffness = PhysicsCollisionObject.getContactStiffness(objectId);
        return stiffness;
    }

    public float getDeactivationTime() {
        long objectId = this.nativeId();
        float time = PhysicsCollisionObject.getDeactivationTime(objectId);
        return time;
    }

    public Material getDebugMaterial() {
        return this.debugMaterial;
    }

    public float getFriction() {
        long objectId = this.nativeId();
        float result = PhysicsCollisionObject.getFriction(objectId);
        return result;
    }

    public Vector3f getPhysicsLocation() {
        return this.getPhysicsLocation(null);
    }

    public Vector3f getPhysicsLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getLocation(objectId, result);
        assert (Vector3f.isValidVector((Vector3f)result));
        return result;
    }

    public Vec3d getPhysicsLocationDp(Vec3d storeResult) {
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getLocationDp(objectId, result);
        assert (result.isFinite()) : result;
        return result;
    }

    public Quaternion getPhysicsRotation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getOrientation(objectId, result);
        return result;
    }

    public Quatd getPhysicsRotationDp(Quatd storeResult) {
        Quatd result = storeResult == null ? new Quatd() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getOrientationDp(objectId, result);
        return result;
    }

    public Matrix3f getPhysicsRotationMatrix(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getBasis(objectId, result);
        return result;
    }

    public Matrix3d getPhysicsRotationMatrixDp(Matrix3d storeResult) {
        Matrix3d result = storeResult == null ? new Matrix3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getBasisDp(objectId, result);
        return result;
    }

    public float getRestitution() {
        long objectId = this.nativeId();
        float result = PhysicsCollisionObject.getRestitution(objectId);
        return result;
    }

    public float getRollingFriction() {
        long objectId = this.nativeId();
        float result = PhysicsCollisionObject.getRollingFriction(objectId);
        return result;
    }

    public Vector3f getScale(Vector3f storeResult) {
        Vector3f result = this.collisionShape.getScale(storeResult);
        return result;
    }

    public float getSpinningFriction() {
        long objectId = this.nativeId();
        float result = PhysicsCollisionObject.getSpinningFriction(objectId);
        return result;
    }

    public Transform getTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        this.getPhysicsLocation(result.getTranslation());
        this.getPhysicsRotation(result.getRotation());
        this.getScale(result.getScale());
        return result;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean hasAnisotropicFriction(int mode) {
        Validate.inRange((int)mode, (String)"mode", (int)1, (int)3);
        long objectId = this.nativeId();
        boolean result = PhysicsCollisionObject.hasAnisotropicFriction(objectId, mode);
        return result;
    }

    public boolean ignores(PhysicsCollisionObject other) {
        boolean result = this.ignoreList == null || other == null ? false : this.ignoreList.contains(other);
        return result;
    }

    public boolean isActive() {
        long objectId = this.nativeId();
        boolean result = PhysicsCollisionObject.isActive(objectId);
        return result;
    }

    public final boolean isContactResponse() {
        long objectId = this.nativeId();
        int flags = PhysicsCollisionObject.getCollisionFlags(objectId);
        boolean result = (flags & 4) == 0;
        return result;
    }

    public final boolean isInWorld() {
        long objectId = this.nativeId();
        boolean result = PhysicsCollisionObject.isInWorld(objectId);
        return result;
    }

    public final boolean isStatic() {
        long objectId = this.nativeId();
        int flags = PhysicsCollisionObject.getCollisionFlags(objectId);
        boolean result = (flags & 1) != 0;
        return result;
    }

    public PhysicsCollisionObject[] listIgnoredPcos() {
        PhysicsCollisionObject[] result;
        if (this.ignoreList == null) {
            result = new PhysicsCollisionObject[]{};
        } else {
            int count = this.ignoreList.size();
            result = new PhysicsCollisionObject[count];
            int index = 0;
            Iterator<PhysicsCollisionObject> iterator = this.ignoreList.iterator();
            while (iterator.hasNext()) {
                PhysicsCollisionObject otherPco;
                result[index] = otherPco = iterator.next();
                ++index;
            }
        }
        return result;
    }

    public Integer proxyGroup() {
        Integer result = null;
        long objectId = this.nativeId();
        if (PhysicsCollisionObject.hasBroadphaseProxy(objectId)) {
            result = PhysicsCollisionObject.getProxyFilterGroup(objectId);
        }
        return result;
    }

    public Integer proxyMask() {
        Integer result = null;
        long objectId = this.nativeId();
        if (PhysicsCollisionObject.hasBroadphaseProxy(objectId)) {
            result = PhysicsCollisionObject.getProxyFilterMask(objectId);
        }
        return result;
    }

    public void removeCollideWithGroup(int collisionGroup) {
        this.collideWithGroups &= ~collisionGroup;
        if (this.hasAssignedNativeObject()) {
            this.setCollideWithGroups(this.collideWithGroups);
        }
    }

    public void removeFromIgnoreList(PhysicsCollisionObject otherPco) {
        Validate.nonNull((Object)otherPco, (String)"other collision object");
        Validate.require((otherPco != this ? 1 : 0) != 0, (String)"2 distinct collision objects");
        if (this.ignoreList != null && this.ignoreList.contains(otherPco)) {
            this.ignoreList.remove(otherPco);
            assert (otherPco.ignoreList != null);
            assert (otherPco.ignoreList.contains(this));
            otherPco.ignoreList.remove(this);
            long thisId = this.nativeId();
            long otherId = otherPco.nativeId();
            boolean toIgnore = false;
            PhysicsCollisionObject.setIgnoreCollisionCheck(thisId, otherId, toIgnore);
        }
    }

    public void setAnisotropicFriction(Vector3f components, int mode) {
        Validate.nonNull((Object)components, (String)"components");
        Validate.inRange((int)mode, (String)"mode", (int)0, (int)2);
        long objectId = this.nativeId();
        PhysicsCollisionObject.setAnisotropicFriction(objectId, components, mode);
    }

    public void setApplicationData(Object data) {
        this.applicationData = data;
    }

    public void setCcdMotionThreshold(float threshold) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setCcdMotionThreshold(objectId, threshold);
    }

    public void setCcdSweptSphereRadius(float radius) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setCcdSweptSphereRadius(objectId, radius);
    }

    public void setCollideWithGroups(int collisionGroups) {
        long objectId = this.nativeId();
        this.collideWithGroups = collisionGroups;
        PhysicsCollisionObject.setCollideWithGroups(objectId, this.collideWithGroups);
    }

    public void setCollisionGroup(int collisionGroup) {
        Validate.require((Integer.bitCount(collisionGroup) == 1 ? 1 : 0) != 0, (String)"exactly one bit set");
        this.collisionGroup = collisionGroup;
        long objectId = this.nativeId();
        PhysicsCollisionObject.setCollisionGroup(objectId, collisionGroup);
    }

    public void setCollisionShape(CollisionShape collisionShape) {
        Validate.nonNull((Object)collisionShape, (String)"collision shape");
        this.collisionShape = collisionShape;
    }

    public void setContactDamping(float damping) {
        long objectId = this.nativeId();
        float stiffness = PhysicsCollisionObject.getContactStiffness(objectId);
        PhysicsCollisionObject.setContactStiffnessAndDamping(objectId, stiffness, damping);
    }

    public void setContactProcessingThreshold(float distance) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setContactProcessingThreshold(objectId, distance);
    }

    public void setContactStiffness(float stiffness) {
        long objectId = this.nativeId();
        float damping = PhysicsCollisionObject.getContactDamping(objectId);
        PhysicsCollisionObject.setContactStiffnessAndDamping(objectId, stiffness, damping);
    }

    public void setDeactivationTime(float time) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setDeactivationTime(objectId, time);
    }

    public void setDebugMaterial(Material material) {
        this.debugMaterial = material;
    }

    public void setDebugMeshInitListener(DebugMeshInitListener listener) {
        this.debugMeshInitListener = listener;
    }

    public void setDebugMeshNormals(MeshNormals newSetting) {
        Validate.nonNull((Object)newSetting, (String)"new setting");
        this.debugMeshNormals = newSetting;
    }

    public void setDebugMeshResolution(int newSetting) {
        Validate.inRange((int)newSetting, (String)"new setting", (int)0, (int)2);
        this.debugMeshResolution = newSetting;
    }

    public void setDebugNumSides(int numSides) {
        Validate.inRange((int)numSides, (String)"number of sides", (int)0, (int)2);
        this.debugNumSides = numSides;
    }

    public void setFriction(float friction) {
        Validate.nonNegative((float)friction, (String)tagFriction);
        long objectId = this.nativeId();
        PhysicsCollisionObject.setFriction(objectId, friction);
    }

    public void setIgnoreList(PhysicsCollisionObject[] desiredList) {
        Validate.nonNull((Object)desiredList, (String)"desired list");
        this.clearIgnoreList();
        if (desiredList.length > 0) {
            if (this.ignoreList == null) {
                this.ignoreList = new TreeSet<PhysicsCollisionObject>();
            }
            for (PhysicsCollisionObject otherPco : desiredList) {
                if (otherPco == null || otherPco == this || this.ignoreList.contains(otherPco)) continue;
                this.addToIgnoreList(otherPco);
            }
        }
    }

    public void setRestitution(float restitution) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setRestitution(objectId, restitution);
    }

    public void setRollingFriction(float friction) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setRollingFriction(objectId, friction);
    }

    public void setSpinningFriction(float friction) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setSpinningFriction(objectId, friction);
    }

    public void setUserIndex(int index) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setUserIndex(objectId, index);
    }

    public void setUserIndex2(int index) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setUserIndex2(objectId, index);
    }

    public void setUserIndex3(int index) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setUserIndex3(objectId, index);
    }

    public void setUserObject(Object user) {
        this.userObject = user;
    }

    public long spaceId() {
        long objectId = this.nativeId();
        long spaceId = PhysicsCollisionObject.getSpaceId(objectId);
        return spaceId;
    }

    public int userIndex() {
        long objectId = this.nativeId();
        int result = PhysicsCollisionObject.getUserIndex(objectId);
        return result;
    }

    public int userIndex2() {
        long objectId = this.nativeId();
        int result = PhysicsCollisionObject.getUserIndex2(objectId);
        return result;
    }

    public int userIndex3() {
        long objectId = this.nativeId();
        int result = PhysicsCollisionObject.getUserIndex3(objectId);
        return result;
    }

    protected static native void attachCollisionShape(long var0, long var2);

    protected void cloneIgnoreList(Cloner cloner, PhysicsCollisionObject old) {
        assert (this.countIgnored() == 0) : "count = " + this.countIgnored();
        assert (this.checkIgnoreList());
        assert (old.checkIgnoreList());
        if (old.ignoreList != null) {
            for (PhysicsCollisionObject oldPco : old.ignoreList) {
                assert (oldPco.checkIgnoreList());
                PhysicsCollisionObject newPco = (PhysicsCollisionObject)cloner.clone((Object)oldPco);
                if (!newPco.hasAssignedNativeObject()) continue;
                assert (newPco.checkIgnoreList());
                this.addToIgnoreList(newPco);
            }
        }
        assert (this.checkIgnoreList());
        assert (old.checkIgnoreList());
    }

    protected static native void finalizeNative(long var0);

    protected static final native int getInternalType(long var0);

    protected void initUserPointer() {
        logger.log(Level.FINE, "initUserPointer() for {0}", this);
        long objectId = this.nativeId();
        this.initUserPointer(objectId, this.collisionGroup, this.collideWithGroups);
        assert (PhysicsCollisionObject.getCollisionGroup(objectId) == this.collisionGroup);
        assert (PhysicsCollisionObject.getCollideWithGroups(objectId) == this.collideWithGroups);
        assert (PhysicsCollisionObject.getSpaceId(objectId) == 0L);
    }

    protected final void readPcoProperties(InputCapsule capsule) throws IOException {
        Savable[] tmpArray;
        this.setCcdMotionThreshold(capsule.readFloat(tagCcdMotionThreshold, 0.0f));
        this.setCcdSweptSphereRadius(capsule.readFloat(tagCcdSweptSphereRadius, 0.0f));
        boolean hasCsd = capsule.readBoolean(tagHasCsd, true);
        if (hasCsd) {
            this.setContactDamping(capsule.readFloat(tagContactDamping, 0.1f));
        }
        this.setContactProcessingThreshold(capsule.readFloat(tagContactProcessingThreshold, 0.0f));
        if (hasCsd) {
            this.setContactStiffness(capsule.readFloat(tagContactStiffness, 1.0E30f));
        }
        this.setDeactivationTime(capsule.readFloat(tagDeactivationTime, 0.0f));
        this.setFriction(capsule.readFloat(tagFriction, 0.5f));
        this.setRestitution(capsule.readFloat(tagRestitution, 0.0f));
        this.setRollingFriction(capsule.readFloat(tagRollingFriction, 0.0f));
        this.setSpinningFriction(capsule.readFloat(tagSpinningFriction, 0.0f));
        int mode = capsule.readInt(tagAnisotropicFrictionMode, 0);
        if (mode != 0) {
            Vector3f components = (Vector3f)capsule.readSavable(tagAnisotropicFrictionComponents, (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
            this.setAnisotropicFriction(components, mode);
        }
        if ((tmpArray = capsule.readSavableArray(tagIgnoreList, null)) != null) {
            for (Savable savable : tmpArray) {
                PhysicsCollisionObject pco = (PhysicsCollisionObject)savable;
                this.addToIgnoreList(pco);
            }
        }
        this.applicationData = capsule.readSavable(tagApplicationData, null);
        this.setUserIndex(capsule.readInt(tagUserIndex, -1));
        this.setUserIndex2(capsule.readInt(tagUserIndex2, -1));
        this.setUserIndex3(capsule.readInt(tagUserIndex3, -1));
        this.userObject = capsule.readSavable(tagUserObject, null);
    }

    protected static native void setActivationState(long var0, int var2);

    protected static native void setCollisionFlags(long var0, int var2);

    protected void setLocationAndBasis(Vector3f centerLocation, Matrix3f orientation) {
        Validate.finite((Vector3f)centerLocation, (String)"center location");
        Validate.nonNull((Object)orientation, (String)"orientation");
        long objectId = this.nativeId();
        PhysicsCollisionObject.setLocationAndBasis(objectId, centerLocation, orientation);
    }

    public void cloneFields(Cloner cloner, Object original) {
        if (this.applicationData instanceof Cloneable) {
            this.applicationData = cloner.clone(this.applicationData);
        }
        if (this.userObject instanceof Cloneable) {
            this.userObject = cloner.clone(this.userObject);
        }
        this.collisionShape = (CollisionShape)cloner.clone((Object)this.collisionShape);
        this.debugMaterial = (Material)cloner.clone((Object)this.debugMaterial);
        if (!this.hasAssignedNativeObject()) {
            this.ignoreList = null;
        }
    }

    public PhysicsCollisionObject jmeClone() {
        try {
            PhysicsCollisionObject clone = (PhysicsCollisionObject)this.clone();
            clone.unassignNativeObject();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.collisionGroup = capsule.readInt(tagCollisionGroup, 1);
        this.collideWithGroups = capsule.readInt(tagCollisionGroupsMask, 1);
        this.debugMeshNormals = (MeshNormals)capsule.readEnum(tagDebugMeshNormals, MeshNormals.class, (Enum)MeshNormals.None);
        this.debugMeshResolution = capsule.readInt(tagDebugMeshResolution, 0);
        this.debugMaterial = (Material)capsule.readSavable(tagDebugMaterial, null);
        Savable shape = capsule.readSavable(tagCollisionShape, null);
        this.collisionShape = (CollisionShape)shape;
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.collisionGroup, tagCollisionGroup, 1);
        capsule.write(this.collideWithGroups, tagCollisionGroupsMask, 1);
        capsule.write((Enum)this.debugMeshNormals, tagDebugMeshNormals, (Enum)MeshNormals.None);
        capsule.write(this.debugMeshResolution, tagDebugMeshResolution, 0);
        capsule.write((Savable)this.debugMaterial, tagDebugMaterial, null);
        capsule.write((Savable)this.collisionShape, tagCollisionShape, null);
        if (this.applicationData instanceof Savable) {
            capsule.write((Savable)this.applicationData, tagApplicationData, null);
        }
        capsule.write(this.userIndex(), tagUserIndex, -1);
        capsule.write(this.userIndex2(), tagUserIndex2, -1);
        capsule.write(this.userIndex3(), tagUserIndex3, -1);
        if (this.userObject instanceof Savable) {
            capsule.write((Savable)this.userObject, tagUserObject, null);
        }
        capsule.write(this.getCcdMotionThreshold(), tagCcdMotionThreshold, 0.0f);
        capsule.write(this.getCcdSweptSphereRadius(), tagCcdSweptSphereRadius, 0.0f);
        int flags = this.collisionFlags();
        boolean hasCsd = (flags & 0x80) != 0;
        capsule.write(hasCsd, tagHasCsd, true);
        capsule.write(this.getContactDamping(), tagContactDamping, 0.1f);
        capsule.write(this.getContactProcessingThreshold(), tagContactProcessingThreshold, 0.0f);
        capsule.write(this.getContactStiffness(), tagContactStiffness, 1.0E30f);
        capsule.write(this.getDeactivationTime(), tagDeactivationTime, 0.0f);
        capsule.write(this.getFriction(), tagFriction, 0.5f);
        capsule.write(this.getRestitution(), tagRestitution, 0.0f);
        capsule.write(this.getRollingFriction(), tagRollingFriction, 0.0f);
        capsule.write(this.getSpinningFriction(), tagSpinningFriction, 0.0f);
        int mode = 0;
        if (this.hasAnisotropicFriction(1)) {
            mode = 1;
        } else if (this.hasAnisotropicFriction(2)) {
            mode = 2;
        }
        capsule.write(mode, tagAnisotropicFrictionMode, 0);
        if (mode != 0) {
            Vector3f components = this.getAnisotropicFriction(null);
            capsule.write((Savable)components, tagAnisotropicFrictionComponents, null);
        }
        if (this.ignoreList != null) {
            int numIgnored = this.ignoreList.size();
            Savable[] tmpArray = new Savable[numIgnored];
            this.ignoreList.toArray(tmpArray);
            capsule.write(tmpArray, tagIgnoreList, null);
        }
    }

    @Override
    public String toString() {
        String result = this.getClass().getSimpleName();
        result = result.replace("Body", "");
        result = result.replace("Control", "C");
        result = result.replace("Physics", "");
        result = result.replace("Object", "");
        if (this.hasAssignedNativeObject()) {
            long objectId = this.nativeId();
            result = result + "#" + Long.toHexString(objectId);
        } else {
            result = result + "#unassigned";
        }
        return result;
    }

    private boolean checkIgnoreList() {
        int jvmCount;
        long objectId = this.nativeId();
        int nativeCount = PhysicsCollisionObject.getNumObjectsWithoutCollision(objectId);
        int n = jvmCount = this.ignoreList == null ? 0 : this.ignoreList.size();
        if (jvmCount != nativeCount) {
            logger.log(Level.SEVERE, "{0}  jvmCount = {1}, nativeCount = {2}", new Object[]{this, jvmCount, nativeCount});
            return false;
        }
        return true;
    }

    private static void freeNativeObject(long objectId) {
        assert (objectId != 0L);
        PhysicsCollisionObject.finalizeNative(objectId);
    }

    private static native void activate(long var0, boolean var2);

    private static native int getActivationState(long var0);

    private static native void getAnisotropicFriction(long var0, Vector3f var2);

    private static native void getBasis(long var0, Matrix3f var2);

    private static native void getBasisDp(long var0, Matrix3d var2);

    private static native float getCcdMotionThreshold(long var0);

    private static native float getCcdSweptSphereRadius(long var0);

    private static native int getCollideWithGroups(long var0);

    private static native int getCollisionFlags(long var0);

    private static native int getCollisionGroup(long var0);

    private static native CollisionSpace getCollisionSpace(long var0);

    private static native float getContactDamping(long var0);

    private static native float getContactProcessingThreshold(long var0);

    private static native float getContactStiffness(long var0);

    private static native float getDeactivationTime(long var0);

    private static native float getFriction(long var0);

    private static native void getLocation(long var0, Vector3f var2);

    private static native void getLocationDp(long var0, Vec3d var2);

    private static native int getNumObjectsWithoutCollision(long var0);

    private static native long getObjectWithoutCollision(long var0, int var2);

    private static native void getOrientation(long var0, Quaternion var2);

    private static native void getOrientationDp(long var0, Quatd var2);

    private static native int getProxyFilterGroup(long var0);

    private static native int getProxyFilterMask(long var0);

    private static native float getRestitution(long var0);

    private static native float getRollingFriction(long var0);

    private static native long getSpaceId(long var0);

    private static native float getSpinningFriction(long var0);

    private static native int getUserIndex(long var0);

    private static native int getUserIndex2(long var0);

    private static native int getUserIndex3(long var0);

    private static native boolean hasAnisotropicFriction(long var0, int var2);

    private static native boolean hasBroadphaseProxy(long var0);

    private native void initUserPointer(long var1, int var3, int var4);

    private static native boolean isActive(long var0);

    private static native boolean isInWorld(long var0);

    private static native void setAnisotropicFriction(long var0, Vector3f var2, int var3);

    private static native void setCcdMotionThreshold(long var0, float var2);

    private static native void setCcdSweptSphereRadius(long var0, float var2);

    private static native void setCollideWithGroups(long var0, int var2);

    private static native void setCollisionGroup(long var0, int var2);

    private static native void setContactProcessingThreshold(long var0, float var2);

    private static native void setContactStiffnessAndDamping(long var0, float var2, float var3);

    private static native void setDeactivationTime(long var0, float var2);

    private static native void setFriction(long var0, float var2);

    private static native void setIgnoreCollisionCheck(long var0, long var2, boolean var4);

    private static native void setLocationAndBasis(long var0, Vector3f var2, Matrix3f var3);

    private static native void setRestitution(long var0, float var2);

    private static native void setRollingFriction(long var0, float var2);

    private static native void setSpinningFriction(long var0, float var2);

    private static native void setUserIndex(long var0, int var2);

    private static native void setUserIndex2(long var0, int var2);

    private static native void setUserIndex3(long var0, int var2);
}

