/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Box2dShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(Box2dShape.class.getName());
    private static final String tagX = "halfExtentX";
    private static final String tagY = "halfExtentY";
    private float halfExtentX = 1.0f;
    private float halfExtentY = 1.0f;

    protected Box2dShape() {
    }

    public Box2dShape(float halfExtent) {
        Validate.nonNegative((float)halfExtent, (String)"half extent");
        this.halfExtentX = halfExtent;
        this.halfExtentY = halfExtent;
        this.createShape();
    }

    public Box2dShape(float xHalfExtent, float yHalfExtent) {
        Validate.nonNegative((float)xHalfExtent, (String)"half extent on X");
        Validate.nonNegative((float)yHalfExtent, (String)"half extent on Y");
        this.halfExtentX = xHalfExtent;
        this.halfExtentY = yHalfExtent;
        this.createShape();
    }

    public Box2dShape(Vector2f halfExtents) {
        Validate.nonNegative((Vector2f)halfExtents, (String)"half extents");
        this.halfExtentX = halfExtents.x;
        this.halfExtentY = halfExtents.y;
        this.createShape();
    }

    public Box2dShape(Vector3f halfExtents) {
        Validate.nonNegative((Vector3f)halfExtents, (String)"half extents");
        this.halfExtentX = halfExtents.x;
        this.halfExtentY = halfExtents.y;
        this.createShape();
    }

    public Vector3f getHalfExtents(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.halfExtentX, this.halfExtentY, this.margin);
        return result;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.createShape();
        this.copyShapeProperties((Box2dShape)original);
    }

    @Override
    public float maxRadius() {
        float x = this.scale.x * this.halfExtentX;
        float y = this.scale.y * this.halfExtentY;
        float result = MyMath.hypotenuse((float[])new float[]{x, y});
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.halfExtentX = capsule.readFloat(tagX, 1.0f);
        this.halfExtentY = capsule.readFloat(tagY, 1.0f);
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.halfExtentX, tagX, 1.0f);
        capsule.write(this.halfExtentY, tagY, 1.0f);
    }

    private void createShape() {
        assert (this.halfExtentX >= 0.0f) : this.halfExtentX;
        assert (this.halfExtentY >= 0.0f) : this.halfExtentY;
        long shapeId = Box2dShape.createShape(this.halfExtentX, this.halfExtentY, this.margin);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(float var0, float var1, float var2);
}

