/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

public class CapsuleCollisionShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(CapsuleCollisionShape.class.getName());
    private static final String tagAxis = "axis";
    private static final String tagHeight = "height";
    private static final String tagRadius = "radius";
    private float height;
    private float radius;
    private int axis;

    protected CapsuleCollisionShape() {
    }

    public CapsuleCollisionShape(float radius, float height) {
        Validate.nonNegative((float)radius, (String)tagRadius);
        Validate.nonNegative((float)height, (String)tagHeight);
        this.radius = radius;
        this.height = height;
        this.axis = 1;
        this.createShape();
    }

    public CapsuleCollisionShape(float radius, float height, int axisIndex) {
        Validate.nonNegative((float)radius, (String)tagRadius);
        Validate.nonNegative((float)height, (String)tagHeight);
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        this.radius = radius;
        this.height = height;
        this.axis = axisIndex;
        this.createShape();
    }

    public int getAxis() {
        assert (this.axis == 0 || this.axis == 1 || this.axis == 2) : this.axis;
        return this.axis;
    }

    public float getHeight() {
        assert (this.height >= 0.0f) : this.height;
        return this.height;
    }

    public float getRadius() {
        assert (this.radius >= 0.0f) : this.radius;
        return this.radius;
    }

    public float unscaledVolume() {
        float result = MyVolume.capsuleVolume((float)this.radius, (float)this.height);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleUniform((Vector3f)scale);
        return canScale;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.createShape();
        this.copyShapeProperties((CapsuleCollisionShape)original);
    }

    @Override
    public float getMargin() {
        return 0.0f;
    }

    @Override
    public float maxRadius() {
        float result = this.scale.x * (this.radius + this.height / 2.0f);
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.radius = capsule.readFloat(tagRadius, 0.5f);
        this.height = capsule.readFloat(tagHeight, 1.0f);
        this.axis = capsule.readInt(tagAxis, 1);
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    public float scaledVolume() {
        float result = this.unscaledVolume() * this.scale.x * this.scale.y * this.scale.z;
        return result;
    }

    @Override
    public void setMargin(float margin) {
        logger2.log(Level.WARNING, "Cannot alter the margin of a CapsuleCollisionShape.");
    }

    @Override
    public HullCollisionShape toHullShape() {
        HullCollisionShape result;
        float effectiveRadius = this.scale.x * this.radius;
        float defaultMargin = CapsuleCollisionShape.getDefaultMargin();
        if (effectiveRadius > defaultMargin) {
            CapsuleCollisionShape shrunkenCapsule = new CapsuleCollisionShape(effectiveRadius - defaultMargin, this.height, this.axis);
            FloatBuffer buffer = DebugShapeFactory.debugVertices(shrunkenCapsule, 0);
            buffer.rewind();
            buffer.limit(buffer.capacity());
            result = new HullCollisionShape(buffer);
        } else {
            Vector3f v1 = new Vector3f();
            v1.set(this.axis, this.height / 2.0f);
            Vector3f v2 = v1.negate();
            result = new HullCollisionShape(v1, v2);
            if (effectiveRadius <= 1.0E-9f) {
                result.setMargin(1.0E-9f);
            } else {
                result.setMargin(effectiveRadius);
            }
        }
        return result;
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.radius, tagRadius, 0.5f);
        capsule.write(this.height, tagHeight, 1.0f);
        capsule.write(this.axis, tagAxis, 1);
    }

    private void createShape() {
        assert (this.axis == 0 || this.axis == 1 || this.axis == 2) : this.axis;
        assert (this.radius >= 0.0f) : this.radius;
        assert (this.height >= 0.0f) : this.height;
        long shapeId = CapsuleCollisionShape.createShape(this.axis, this.radius, this.height);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.margin = 0.0f;
    }

    private static native long createShape(int var0, float var1, float var2);
}

