/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class ConicalFrustum
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(ConicalFrustum.class.getName());
    private static final String tagUnscaledA = "a";
    private static final String tagUnscaledB = "b";
    private static final String tagUnscaledHeight = "height";
    private float unscaledA;
    private float unscaledB;
    private float unscaledHeight;

    protected ConicalFrustum() {
    }

    public ConicalFrustum(float a, float b, float height) {
        Validate.positive((float)a, (String)"A radius");
        Validate.positive((float)b, (String)"B radius");
        Validate.positive((float)height, (String)tagUnscaledHeight);
        this.unscaledA = a;
        this.unscaledB = b;
        this.unscaledHeight = height;
        this.createShape();
    }

    public float aRadius() {
        assert (this.unscaledA > 0.0f) : this.unscaledA;
        return this.unscaledA;
    }

    public float bRadius() {
        assert (this.unscaledB > 0.0f) : this.unscaledB;
        return this.unscaledB;
    }

    public float height() {
        assert (this.unscaledHeight > 0.0f) : this.unscaledHeight;
        return this.unscaledHeight;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean result = super.canScale(scale) && scale.x == scale.z;
        return result;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.createShape();
        this.copyShapeProperties((ConicalFrustum)original);
    }

    @Override
    public float maxRadius() {
        long shapeId = this.nativeId();
        float result = ConicalFrustum.maxRadius(shapeId);
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.unscaledA = capsule.readFloat(tagUnscaledA, 1.0f);
        this.unscaledB = capsule.readFloat(tagUnscaledB, 1.0f);
        this.unscaledHeight = capsule.readFloat(tagUnscaledHeight, 1.0f);
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    public float scaledVolume() {
        long shapeId = this.nativeId();
        float result = ConicalFrustum.scaledVolume(shapeId);
        return result;
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.unscaledA, tagUnscaledA, 1.0f);
        capsule.write(this.unscaledB, tagUnscaledB, 1.0f);
        capsule.write(this.unscaledHeight, tagUnscaledHeight, 1.0f);
    }

    private void createShape() {
        long shapeId = ConicalFrustum.createShapeNative(this.unscaledA, this.unscaledB, this.unscaledHeight);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShapeNative(float var0, float var1, float var2);

    private static native float maxRadius(long var0);

    private static native float scaledVolume(long var0);
}

