/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public abstract class CustomConvexShape
extends ConvexShape {
    public static final Logger loggerY = Logger.getLogger(CustomConvexShape.class.getName());
    private static final String tagHalfExtents = "halfExtents";
    private static final String tagInertia = "inertia";
    protected static final ThreadLocal<Vector3f> threadTmpVector = new ThreadLocal<Vector3f>(){

        @Override
        protected Vector3f initialValue() {
            return new Vector3f();
        }
    };
    private Vector3f halfExtents;
    private Vector3f inertia = new Vector3f();

    protected CustomConvexShape() {
    }

    protected CustomConvexShape(float xHalfExtent, float yHalfExtent, float zHalfExtent) {
        Validate.positive((float)xHalfExtent, (String)"X half extent");
        Validate.positive((float)yHalfExtent, (String)"Y half extent");
        Validate.positive((float)zHalfExtent, (String)"Z half extent");
        this.halfExtents = new Vector3f(xHalfExtent, yHalfExtent, zHalfExtent);
        this.createShape();
    }

    protected CustomConvexShape(Vector3f halfExtents) {
        if (halfExtents == null) {
            this.halfExtents = null;
        } else {
            Validate.positive((Vector3f)halfExtents, (String)"half extents");
            this.halfExtents = halfExtents.clone();
        }
        this.createShape();
    }

    protected abstract Vector3f locateSupport(float var1, float var2, float var3);

    protected void setScaledInertia(float ix, float iy, float iz) {
        Validate.positive((float)ix, (String)"X-axis inertia");
        Validate.positive((float)iy, (String)"Y-axis inertia");
        Validate.positive((float)iz, (String)"Z-axis inertia");
        this.inertia.set(ix, iy, iz);
        long shapeId = this.nativeId();
        CustomConvexShape.setScaledInertia(shapeId, ix, iy, iz);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.halfExtents = (Vector3f)cloner.clone((Object)this.halfExtents);
        this.inertia = (Vector3f)cloner.clone((Object)this.inertia);
        this.createShape();
        this.copyShapeProperties((CustomConvexShape)original);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.halfExtents = (Vector3f)capsule.readSavable(tagHalfExtents, null);
        this.inertia = (Vector3f)capsule.readSavable(tagInertia, (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.halfExtents, tagHalfExtents, null);
        capsule.write((Savable)this.inertia, tagInertia, (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
    }

    private void createShape() {
        long shapeId = this.createShapeNative(this.halfExtents);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setMargin(this.margin);
    }

    private native long createShapeNative(Vector3f var1);

    private static native void setScaledInertia(long var0, float var2, float var3, float var4);
}

