/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

public class CylinderCollisionShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(CylinderCollisionShape.class.getName());
    private static final String tagAxis = "axis";
    private static final String tagHalfExtents = "halfExtents";
    private int axis;
    private Vector3f halfExtents = new Vector3f(0.5f, 0.5f, 0.5f);

    protected CylinderCollisionShape() {
    }

    public CylinderCollisionShape(float radius, float height, int axisIndex) {
        Validate.nonNegative((float)radius, (String)"radius");
        Validate.nonNegative((float)height, (String)"height");
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        this.axis = axisIndex;
        this.halfExtents.set(radius, radius, radius);
        this.halfExtents.set(axisIndex, height / 2.0f);
        this.createShape();
    }

    public CylinderCollisionShape(FloatBuffer buffer, int startPosition, int endPosition, int axisIndex) {
        Validate.nonNull((Object)buffer, (String)"buffer");
        Validate.inRange((int)startPosition, (String)"start position", (int)0, (int)endPosition);
        Validate.inRange((int)endPosition, (String)"end position", (int)startPosition, (int)buffer.capacity());
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        this.axis = axisIndex;
        MyBuffer.maxAbs((FloatBuffer)buffer, (int)startPosition, (int)endPosition, (Vector3f)this.halfExtents);
        float halfHeight = this.halfExtents.get(axisIndex);
        float radius = MyBuffer.cylinderRadius((FloatBuffer)buffer, (int)startPosition, (int)endPosition, (int)axisIndex);
        this.halfExtents.set(radius, radius, radius);
        this.halfExtents.set(axisIndex, halfHeight);
        this.createShape();
    }

    public CylinderCollisionShape(Vector3f halfExtents) {
        Validate.nonNegative((Vector3f)halfExtents, (String)"half extents");
        this.halfExtents.set(halfExtents);
        this.axis = 2;
        this.createShape();
    }

    public CylinderCollisionShape(Vector3f halfExtents, int axisIndex) {
        Validate.nonNegative((Vector3f)halfExtents, (String)"half extents");
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        this.halfExtents.set(halfExtents);
        this.axis = axisIndex;
        this.createShape();
    }

    public int getAxis() {
        assert (this.axis == 0 || this.axis == 1 || this.axis == 2) : this.axis;
        return this.axis;
    }

    public Vector3f getHalfExtents(Vector3f storeResult) {
        assert (MyVector3f.isAllNonNegative((Vector3f)this.halfExtents)) : this.halfExtents;
        Vector3f result = storeResult == null ? this.halfExtents.clone() : storeResult.set(this.halfExtents);
        return result;
    }

    public float getHeight() {
        float result = 2.0f * this.halfExtents.get(this.axis);
        assert (result >= 0.0f) : result;
        return result;
    }

    public float unscaledVolume() {
        float result = MyVolume.cylinderVolume((Vector3f)this.halfExtents);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale);
        if (canScale) {
            if (this.axis == 0 && scale.y != scale.z) {
                canScale = false;
            } else if (this.axis == 1 && scale.x != scale.z) {
                canScale = false;
            } else if (this.axis == 2 && scale.x != scale.y) {
                canScale = false;
            }
        }
        return canScale;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.halfExtents = (Vector3f)cloner.clone((Object)this.halfExtents);
        this.createShape();
        this.copyShapeProperties((CylinderCollisionShape)original);
    }

    @Override
    public float maxRadius() {
        double bigRadius;
        double halfHeight;
        double xx = this.scale.x * this.halfExtents.x;
        double yy = this.scale.y * this.halfExtents.y;
        double zz = this.scale.z * this.halfExtents.z;
        switch (this.axis) {
            case 0: {
                halfHeight = xx;
                bigRadius = Math.max(yy, zz);
                break;
            }
            case 1: {
                halfHeight = yy;
                bigRadius = Math.max(xx, zz);
                break;
            }
            case 2: {
                halfHeight = zz;
                bigRadius = Math.max(xx, yy);
                break;
            }
            default: {
                throw new IllegalStateException("axis = " + this.axis);
            }
        }
        float result = (float)Math.hypot(halfHeight, bigRadius);
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        Vector3f he = (Vector3f)capsule.readSavable(tagHalfExtents, (Savable)new Vector3f(0.5f, 0.5f, 0.5f));
        this.halfExtents.set(he);
        this.axis = capsule.readInt(tagAxis, 1);
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    public HullCollisionShape toHullShape() {
        Vector3f hes = this.halfExtents.mult(this.scale);
        float minHalfExtent = MyMath.min((float[])new float[]{hes.x, hes.y, hes.z});
        float defaultMargin = CylinderCollisionShape.getDefaultMargin();
        float hullMargin = Math.min(defaultMargin, minHalfExtent);
        hes.subtractLocal(hullMargin, hullMargin, hullMargin);
        MyVector3f.accumulateMaxima((Vector3f)hes, (Vector3f)new Vector3f(1.0E-6f, 1.0E-6f, 1.0E-6f));
        CylinderCollisionShape reducedShape = new CylinderCollisionShape(hes, this.axis);
        FloatBuffer buffer = DebugShapeFactory.debugVertices(reducedShape, 0);
        buffer.rewind();
        buffer.limit(buffer.capacity());
        HullCollisionShape result = new HullCollisionShape(buffer);
        result.setMargin(hullMargin);
        return result;
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.halfExtents, tagHalfExtents, null);
        capsule.write(this.axis, tagAxis, 1);
    }

    private void createShape() {
        assert (this.axis == 0 || this.axis == 1 || this.axis == 2) : this.axis;
        assert (MyVector3f.isAllNonNegative((Vector3f)this.halfExtents)) : this.halfExtents;
        long shapeId = CylinderCollisionShape.createShape(this.axis, this.halfExtents);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(int var0, Vector3f var1);
}

