/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.collision.shapes.infos.CompoundMesh;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class GImpactCollisionShape
extends CollisionShape {
    public static final Logger logger2 = Logger.getLogger(GImpactCollisionShape.class.getName());
    private static final String tagNativeMesh = "nativeMesh";
    private CompoundMesh nativeMesh;

    protected GImpactCollisionShape() {
    }

    public GImpactCollisionShape(CompoundMesh mesh, Vector3f offset) {
        Validate.require((mesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.nativeMesh = new CompoundMesh(mesh, offset);
        this.createShape();
    }

    public GImpactCollisionShape(IndexedMesh ... submeshes) {
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : submeshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.createShape();
    }

    public GImpactCollisionShape(Mesh ... jmeMeshes) {
        this.nativeMesh = new CompoundMesh(jmeMeshes);
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.createShape();
    }

    public int countMeshTriangles() {
        int result = this.nativeMesh.countTriangles();
        return result;
    }

    public int countMeshVertices() {
        int numVertices = this.nativeMesh.countVertices();
        return numVertices;
    }

    public int countSubmeshes() {
        int result = this.nativeMesh.countSubmeshes();
        return result;
    }

    public IndexedMesh getSubmesh(int index) {
        int numSubmeshes = this.nativeMesh.countSubmeshes();
        Validate.inRange((int)index, (String)"submesh index", (int)0, (int)(numSubmeshes - 1));
        IndexedMesh result = this.nativeMesh.getSubmesh(index);
        return result;
    }

    public ChildCollisionShape[] split(Triangle splittingTriangle) {
        ChildCollisionShape[] result;
        block3: {
            CompoundMesh[] mp;
            block1: {
                ChildCollisionShape child;
                int numPlus;
                block2: {
                    Validate.nonNull((Object)splittingTriangle, (String)"splitting triangle");
                    mp = this.nativeMesh.split(splittingTriangle);
                    result = new ChildCollisionShape[2];
                    int numMinus = mp[0] == null ? 0 : mp[0].countTriangles();
                    int n = numPlus = mp[1] == null ? 0 : mp[1].countTriangles();
                    if (numMinus != 0 && numPlus != 0) break block1;
                    child = new ChildCollisionShape(new Vector3f(), this);
                    if (numMinus <= 0) break block2;
                    result[0] = child;
                    break block3;
                }
                if (numPlus <= 0) break block3;
                result[1] = child;
                break block3;
            }
            Vector3f max = new Vector3f();
            Vector3f min = new Vector3f();
            Vector3f offset = max;
            Vector3f center = min;
            for (int i = 0; i < 2; ++i) {
                mp[i].maxMin(max, min);
                MyVector3f.midpoint((Vector3f)max, (Vector3f)min, (Vector3f)center);
                offset.set(center).negateLocal();
                GImpactCollisionShape shape = new GImpactCollisionShape(mp[i], offset);
                shape.setScale(this.scale);
                result[i] = new ChildCollisionShape(center, shape);
            }
        }
        return result;
    }

    @Override
    public boolean canSplit() {
        return true;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.nativeMesh = (CompoundMesh)cloner.clone((Object)this.nativeMesh);
        this.createShape();
        this.copyShapeProperties((GImpactCollisionShape)original);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.nativeMesh = (CompoundMesh)capsule.readSavable(tagNativeMesh, null);
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        GImpactCollisionShape.recalcAabb(shapeId);
    }

    @Override
    public void setScale(Vector3f scale) {
        super.setScale(scale);
        this.recalculateAabb();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.nativeMesh, tagNativeMesh, null);
    }

    private void createShape() {
        int numTriangles = this.nativeMesh.countTriangles();
        assert (numTriangles > 0) : numTriangles;
        long meshId = this.nativeMesh.nativeId();
        long shapeId = GImpactCollisionShape.createShape(meshId);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(long var0);

    private static native void recalcAabb(long var0);
}

