/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.BoundingValueHierarchy;
import com.jme3.bullet.collision.shapes.infos.CompoundMesh;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.bullet.util.NativeLibrary;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MeshCollisionShape
extends CollisionShape {
    public static final int maxSubmeshes = 1024;
    public static final int maxTrianglesInAnySubmesh = 0x1FFFFF;
    public static final Logger logger2 = Logger.getLogger(MeshCollisionShape.class.getName());
    private static final String tagBvh = "bvh";
    private static final String tagDoublePrecision = "doublePrecision";
    private static final String tagNativeMesh = "nativeMesh";
    private static final String tagNativePlatform = "nativePlatform";
    private static final String tagUseCompression = "useCompression";
    private boolean useCompression;
    private static boolean serializeBvh = true;
    private BoundingValueHierarchy bvh;
    private CompoundMesh nativeMesh;

    protected MeshCollisionShape() {
    }

    public MeshCollisionShape(boolean useCompression, Collection<IndexedMesh> meshes) {
        Validate.nonEmpty(meshes, (String)"meshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : meshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = useCompression;
        this.createShape();
    }

    public MeshCollisionShape(boolean useCompression, CompoundMesh mesh) {
        Validate.require((mesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.nativeMesh = new CompoundMesh(mesh);
        this.useCompression = useCompression;
        this.createShape();
    }

    public MeshCollisionShape(boolean useCompression, IndexedMesh ... submeshes) {
        Validate.nonEmpty((Object[])submeshes, (String)"submeshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : submeshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = useCompression;
        this.createShape();
    }

    public MeshCollisionShape(byte[] bvhBytes, IndexedMesh ... submeshes) {
        Validate.nonNull((Object)bvhBytes, (String)"BVH data");
        Validate.nonEmpty((Object[])submeshes, (String)"submeshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : submeshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = true;
        this.bvh = new BoundingValueHierarchy(bvhBytes);
        this.createShape();
    }

    public MeshCollisionShape(Mesh ... jmeMeshes) {
        Validate.nonEmpty((Object[])jmeMeshes, (String)"JME meshes");
        this.nativeMesh = new CompoundMesh(jmeMeshes);
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = true;
        this.createShape();
    }

    public MeshCollisionShape(Mesh mesh, boolean useCompression) {
        Validate.nonNull((Object)mesh, (String)"mesh");
        this.nativeMesh = new CompoundMesh(mesh);
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = useCompression;
        this.createShape();
    }

    public int countMeshTriangles() {
        int result = this.nativeMesh.countTriangles();
        return result;
    }

    public int countMeshVertices() {
        int numVertices = this.nativeMesh.countVertices();
        return numVertices;
    }

    public int countSubmeshes() {
        int result = this.nativeMesh.countSubmeshes();
        return result;
    }

    public BoundingValueHierarchy getBvh() {
        return this.bvh;
    }

    public IndexedMesh getSubmesh(int index) {
        int numSubmeshes = this.nativeMesh.countSubmeshes();
        Validate.inRange((int)index, (String)"submesh index", (int)0, (int)(numSubmeshes - 1));
        IndexedMesh result = this.nativeMesh.getSubmesh(index);
        return result;
    }

    public static boolean isSerializingBvh() {
        return serializeBvh;
    }

    public byte[] serializeBvh() {
        byte[] result = this.bvh.serialize();
        return result;
    }

    public static void setSerializingBvh(boolean setting) {
        serializeBvh = setting;
    }

    public MeshCollisionShape[] split(Triangle splittingTriangle) {
        int numPlus;
        Validate.nonNull((Object)splittingTriangle, (String)"splitting triangle");
        CompoundMesh[] mp = this.nativeMesh.split(splittingTriangle);
        MeshCollisionShape[] result = new MeshCollisionShape[2];
        int numMinus = mp[0] == null ? 0 : mp[0].countTriangles();
        int n = numPlus = mp[1] == null ? 0 : mp[1].countTriangles();
        if (numMinus == 0 || numPlus == 0) {
            if (numMinus > 0) {
                result[0] = this;
            } else if (numPlus > 0) {
                result[1] = this;
            }
        } else {
            result[0] = new MeshCollisionShape(this.useCompression, mp[0]);
            result[0].setScale(this.scale);
            result[1] = new MeshCollisionShape(this.useCompression, mp[1]);
            result[1].setScale(this.scale);
        }
        return result;
    }

    @Override
    public boolean canSplit() {
        return true;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.nativeMesh = (CompoundMesh)cloner.clone((Object)this.nativeMesh);
        this.bvh = (BoundingValueHierarchy)cloner.clone((Object)this.bvh);
        this.createShape();
        this.copyShapeProperties((MeshCollisionShape)original);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        boolean writeDoublePrecision = capsule.readBoolean(tagDoublePrecision, false);
        Platform writePlatform = (Platform)capsule.readEnum(tagNativePlatform, Platform.class, null);
        this.bvh = writeDoublePrecision != NativeLibrary.isDoublePrecision() || writePlatform != JmeSystem.getPlatform() ? null : (BoundingValueHierarchy)capsule.readSavable(tagBvh, null);
        this.nativeMesh = (CompoundMesh)capsule.readSavable(tagNativeMesh, null);
        this.useCompression = capsule.readBoolean(tagUseCompression, true);
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        MeshCollisionShape.recalcAabb(shapeId);
    }

    @Override
    public void setScale(Vector3f scale) {
        super.setScale(scale);
        long shapeId = this.nativeId();
        if (MeshCollisionShape.hasBvh(shapeId)) {
            this.bvh = new BoundingValueHierarchy(this);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        if (serializeBvh) {
            capsule.write((Savable)this.bvh, tagBvh, null);
        }
        boolean doublePrecision = NativeLibrary.isDoublePrecision();
        capsule.write(doublePrecision, tagDoublePrecision, false);
        Platform nativePlatform = JmeSystem.getPlatform();
        capsule.write((Enum)nativePlatform, tagNativePlatform, null);
        capsule.write((Savable)this.nativeMesh, tagNativeMesh, null);
        capsule.write(this.useCompression, tagUseCompression, true);
    }

    private void createShape() {
        int numTriangles = this.nativeMesh.countTriangles();
        assert (numTriangles > 0) : numTriangles;
        if (this.useCompression) {
            int numSubmeshes = this.nativeMesh.countSubmeshes();
            if (numSubmeshes > 1024) {
                throw new IllegalArgumentException("Too many submeshes: " + numSubmeshes);
            }
            for (int submeshI = 0; submeshI < numSubmeshes; ++submeshI) {
                IndexedMesh submesh = this.nativeMesh.getSubmesh(submeshI);
                int count = submesh.countTriangles();
                if (count <= 0x1FFFFF) continue;
                throw new IllegalArgumentException("Submesh has too many triangles: " + count);
            }
        }
        boolean buildBvh = false;
        long meshId = this.nativeMesh.nativeId();
        long shapeId = MeshCollisionShape.createShape(this.useCompression, buildBvh, meshId);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
        assert (!MeshCollisionShape.hasBvh(shapeId));
        if (this.bvh == null) {
            this.bvh = new BoundingValueHierarchy(this);
        } else {
            long bvhId = this.bvh.nativeId();
            MeshCollisionShape.setOptimizedBvh(shapeId, bvhId, this.scale);
        }
        assert (MeshCollisionShape.hasBvh(shapeId));
        assert (this.bvh.isCompressed() == this.useCompression) : this.bvh.isCompressed() + " != " + this.useCompression;
    }

    private static native long createShape(boolean var0, boolean var1, long var2);

    private static native boolean hasBvh(long var0);

    private static native void recalcAabb(long var0);

    private static native void setOptimizedBvh(long var0, long var2, Vector3f var4);
}

