/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class MinkowskiSum
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(MinkowskiSum.class.getName());
    private static final String tagShapeA = "shapeA";
    private static final String tagShapeB = "shapeB";
    private ConvexShape shapeA;
    private ConvexShape shapeB;

    protected MinkowskiSum() {
    }

    public MinkowskiSum(ConvexShape shapeA, ConvexShape shapeB) {
        Validate.nonNull((Object)shapeA, (String)"shape A");
        Validate.nonNull((Object)shapeA, (String)"shape B");
        this.shapeA = shapeA;
        this.shapeB = shapeB;
        this.createShape();
    }

    public ConvexShape getShapeA() {
        assert (this.shapeA != null);
        return this.shapeA;
    }

    public ConvexShape getShapeB() {
        assert (this.shapeB != null);
        return this.shapeB;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleIdentity((Vector3f)scale);
        return canScale;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.shapeA = (ConvexShape)cloner.clone((Object)this.shapeA);
        this.shapeB = (ConvexShape)cloner.clone((Object)this.shapeB);
        this.createShape();
        this.copyShapeProperties((MinkowskiSum)original);
    }

    @Override
    public float getMargin() {
        this.margin = this.shapeA.nativeMargin() + this.shapeB.nativeMargin();
        float result = super.getMargin();
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.shapeA = (ConvexShape)capsule.readSavable(tagShapeA, null);
        this.shapeB = (ConvexShape)capsule.readSavable(tagShapeB, null);
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    public void setMargin(float margin) {
        logger2.log(Level.WARNING, "Cannot directly alter the margin of a MinkowskiSum");
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.shapeA, tagShapeA, null);
        capsule.write((Savable)this.shapeB, tagShapeB, null);
    }

    private void createShape() {
        long shapeAId = this.shapeA.nativeId();
        long shapeBId = this.shapeB.nativeId();
        long shapeId = MinkowskiSum.createShape(shapeAId, shapeBId);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.margin = this.shapeA.getMargin() + this.shapeB.getMargin();
    }

    private static native long createShape(long var0, long var2);
}

