/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.AbstractTriangle;
import com.jme3.math.FastMath;
import com.jme3.math.LineSegment;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

public class SimplexCollisionShape
extends ConvexShape {
    private static final int numAxes = 3;
    public static final Logger logger2 = Logger.getLogger(SimplexCollisionShape.class.getName());
    private static final String tagSimplexPoint1 = "simplexPoint1";
    private static final String tagSimplexPoint2 = "simplexPoint2";
    private static final String tagSimplexPoint3 = "simplexPoint3";
    private static final String tagSimplexPoint4 = "simplexPoint4";
    private Vector3f[] locations;

    protected SimplexCollisionShape() {
    }

    public SimplexCollisionShape(Vector3f location) {
        this.locations = new Vector3f[1];
        this.locations[0] = location.clone();
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f point1, Vector3f point2) {
        this.locations = new Vector3f[2];
        this.locations[0] = point1.clone();
        this.locations[1] = point2.clone();
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f vertex1, Vector3f vertex2, Vector3f vertex3) {
        this.locations = new Vector3f[3];
        this.locations[0] = vertex1.clone();
        this.locations[1] = vertex2.clone();
        this.locations[2] = vertex3.clone();
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f vertex1, Vector3f vertex2, Vector3f vertex3, Vector3f vertex4) {
        this.locations = new Vector3f[4];
        this.locations[0] = vertex1.clone();
        this.locations[1] = vertex2.clone();
        this.locations[2] = vertex3.clone();
        this.locations[3] = vertex4.clone();
        this.createShape();
    }

    public SimplexCollisionShape(AbstractTriangle triangle) {
        Validate.nonNull((Object)triangle, (String)"triangle");
        this.locations = new Vector3f[3];
        this.locations[0] = triangle.get1().clone();
        this.locations[1] = triangle.get2().clone();
        this.locations[2] = triangle.get3().clone();
        this.createShape();
    }

    public SimplexCollisionShape(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull((Object)buffer, (String)"buffer");
        Validate.inRange((int)startPosition, (String)"start position", (int)0, (int)(endPosition - 3));
        Validate.inRange((int)endPosition, (String)"end position", (int)(startPosition + 3), (int)buffer.capacity());
        int numFloats = endPosition - startPosition;
        Validate.require((numFloats % 3 == 0 ? 1 : 0) != 0, (String)"range a multiple of 3");
        int numVertices = numFloats / 3;
        assert (numVertices >= 1) : numVertices;
        assert (numVertices <= 4) : numVertices;
        this.locations = new Vector3f[numVertices];
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            this.locations[vertexIndex] = new Vector3f();
            MyBuffer.get((FloatBuffer)buffer, (int)(startPosition + vertexIndex * 3), (Vector3f)this.locations[vertexIndex]);
        }
        this.createShape();
    }

    public SimplexCollisionShape(LineSegment segment) {
        Validate.nonNull((Object)segment, (String)"segment");
        this.locations = new Vector3f[2];
        this.locations[0] = segment.getNegativeEnd(null);
        this.locations[1] = segment.getPositiveEnd(null);
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f[] vertices) {
        Validate.nonEmpty((Object[])vertices, (String)"vertices");
        int numVertices = vertices.length;
        assert (numVertices <= 4) : numVertices;
        this.locations = new Vector3f[numVertices];
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            this.locations[vertexIndex] = vertices[vertexIndex].clone();
        }
        this.createShape();
    }

    public Vector3f copyVertex(int index, Vector3f storeResult) {
        int numVertices = this.locations.length;
        Validate.inRange((int)index, (String)"index", (int)0, (int)(numVertices - 1));
        Vector3f result = storeResult == null ? this.locations[index].clone() : storeResult.set(this.locations[index]);
        return result;
    }

    public float[] copyVertices() {
        int numVertices = this.locations.length;
        float[] result = new float[numVertices * 3];
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            int floatIndex = vertexIndex * 3;
            Vector3f location = this.locations[vertexIndex];
            result[floatIndex + 0] = location.x;
            result[floatIndex + 1] = location.y;
            result[floatIndex + 2] = location.z;
        }
        return result;
    }

    public int countMeshVertices() {
        int result = this.locations.length;
        assert (result >= 1) : result;
        assert (result <= 4) : result;
        return result;
    }

    public Vector3f getHalfExtents(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.zero();
        for (Vector3f location : this.locations) {
            float z;
            float y;
            float x = FastMath.abs((float)location.x);
            if (x > result.x) {
                result.x = x;
            }
            if ((y = FastMath.abs((float)location.y)) > result.y) {
                result.y = y;
            }
            if (!((z = FastMath.abs((float)location.z)) > result.z)) continue;
            result.z = z;
        }
        assert (MyVector3f.isAllNonNegative((Vector3f)result)) : result;
        return result;
    }

    public float unscaledVolume() {
        float volume = 0.0f;
        if (this.locations.length > 3) {
            volume = (float)MyVolume.tetrahedronVolume((Vector3f)this.locations[0], (Vector3f)this.locations[1], (Vector3f)this.locations[2], (Vector3f)this.locations[3]);
        }
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleIdentity((Vector3f)scale);
        return canScale;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.locations = (Vector3f[])cloner.clone((Object)this.locations);
        this.createShape();
        this.copyShapeProperties((SimplexCollisionShape)original);
    }

    @Override
    public float maxRadius() {
        double maxLengthSquared = 0.0;
        for (Vector3f location : this.locations) {
            double lengthSquared = MyVector3f.lengthSquared((Vector3f)location);
            if (!(lengthSquared > maxLengthSquared)) continue;
            maxLengthSquared = lengthSquared;
        }
        float result = this.margin + (float)Math.sqrt(maxLengthSquared);
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        Vector3f v1 = (Vector3f)capsule.readSavable(tagSimplexPoint1, null);
        Vector3f v2 = (Vector3f)capsule.readSavable(tagSimplexPoint2, null);
        Vector3f v3 = (Vector3f)capsule.readSavable(tagSimplexPoint3, null);
        Vector3f v4 = (Vector3f)capsule.readSavable(tagSimplexPoint4, null);
        this.locations = v2 == null ? new Vector3f[]{v1} : (v3 == null ? new Vector3f[]{v1, v2} : (v4 == null ? new Vector3f[]{v1, v2, v3} : new Vector3f[]{v1, v2, v3, v4}));
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        SimplexCollisionShape.recalcAabb(shapeId);
    }

    @Override
    public HullCollisionShape toHullShape() {
        assert (MyVector3f.isScaleIdentity((Vector3f)this.scale)) : this.scale;
        HullCollisionShape result = new HullCollisionShape(this.locations);
        result.setMargin(this.margin);
        return result;
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.locations[0], tagSimplexPoint1, null);
        int numVertices = this.locations.length;
        if (numVertices > 1) {
            capsule.write((Savable)this.locations[1], tagSimplexPoint2, null);
        }
        if (numVertices > 2) {
            capsule.write((Savable)this.locations[2], tagSimplexPoint3, null);
        }
        if (numVertices > 3) {
            capsule.write((Savable)this.locations[3], tagSimplexPoint4, null);
        }
    }

    private void createShape() {
        long shapeId;
        int numVertices = this.locations.length;
        switch (numVertices) {
            case 1: {
                shapeId = SimplexCollisionShape.createShape(this.locations[0]);
                break;
            }
            case 2: {
                shapeId = SimplexCollisionShape.createShape(this.locations[0], this.locations[1]);
                break;
            }
            case 3: {
                shapeId = SimplexCollisionShape.createShape(this.locations[0], this.locations[1], this.locations[2]);
                break;
            }
            case 4: {
                shapeId = SimplexCollisionShape.createShape(this.locations[0], this.locations[1], this.locations[2], this.locations[3]);
                break;
            }
            default: {
                String message = "numVertices = " + numVertices;
                throw new IllegalArgumentException(message);
            }
        }
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(Vector3f var0);

    private static native long createShape(Vector3f var0, Vector3f var1);

    private static native long createShape(Vector3f var0, Vector3f var1, Vector3f var2);

    private static native long createShape(Vector3f var0, Vector3f var1, Vector3f var2, Vector3f var3);

    private static native void recalcAabb(long var0);
}

