/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class SphericalSegment
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(SphericalSegment.class.getName());
    private static final String tagUnscaledRadius = "radius";
    private static final String tagUnscaledYMax = "yMax";
    private static final String tagUnscaledYMin = "yMin";
    private float unscaledRadius;
    private float unscaledYMax;
    private float unscaledYMin;

    protected SphericalSegment() {
    }

    public SphericalSegment(float radius) {
        this(radius, radius, 0.0f);
    }

    public SphericalSegment(float radius, float yMax, float yMin) {
        Validate.positive((float)radius, (String)tagUnscaledRadius);
        Validate.inRange((float)yMax, (String)tagUnscaledYMax, (float)yMin, (float)radius);
        Validate.inRange((float)yMin, (String)tagUnscaledYMin, (float)(-radius), (float)yMax);
        this.unscaledRadius = radius;
        this.unscaledYMax = yMax;
        this.unscaledYMin = yMin;
        this.createShape();
    }

    public float getHeight() {
        float result = this.unscaledYMax - this.unscaledYMin;
        assert (result >= 0.0f) : result;
        return result;
    }

    public float sphereRadius() {
        assert (this.unscaledRadius > 0.0f) : this.unscaledRadius;
        return this.unscaledRadius;
    }

    public float yMax() {
        assert (this.unscaledYMax >= -this.unscaledRadius);
        assert (this.unscaledYMax <= this.unscaledRadius);
        return this.unscaledYMax;
    }

    public float yMin() {
        assert (this.unscaledYMin >= -this.unscaledRadius);
        assert (this.unscaledYMin <= this.unscaledRadius);
        return this.unscaledYMin;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleUniform((Vector3f)scale);
        return canScale;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.createShape();
        this.copyShapeProperties((SphericalSegment)original);
    }

    @Override
    public float maxRadius() {
        long shapeId = this.nativeId();
        float result = SphericalSegment.maxRadius(shapeId);
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.unscaledRadius = capsule.readFloat(tagUnscaledRadius, 1.0f);
        this.unscaledYMax = capsule.readFloat(tagUnscaledYMax, 1.0f);
        this.unscaledYMin = capsule.readFloat(tagUnscaledYMin, 0.0f);
        this.createShape();
        this.readShapeProperties(capsule);
    }

    @Override
    public float scaledVolume() {
        long shapeId = this.nativeId();
        float result = SphericalSegment.scaledVolume(shapeId);
        return result;
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.unscaledRadius, tagUnscaledRadius, 1.0f);
        capsule.write(this.unscaledYMax, tagUnscaledYMax, 1.0f);
        capsule.write(this.unscaledYMin, tagUnscaledYMin, 0.0f);
    }

    private void createShape() {
        long shapeId = SphericalSegment.createShapeNative(this.unscaledRadius, this.unscaledYMax, this.unscaledYMin);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShapeNative(float var0, float var1, float var2);

    private static native float maxRadius(long var0);

    private static native float scaledVolume(long var0);
}

