/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Plane;
import com.jme3.math.Transform;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.DistinctVectorValues;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;
import jme3utilities.math.RectangularSolid;
import jme3utilities.math.VectorSet;

public class IndexedMesh
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    private static final int floatBytes = 4;
    private static final int numAxes = 3;
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(IndexedMesh.class.getName());
    private static final String tagIndexInts = "indexInts";
    private static final String tagIndexStride = "indexStride";
    private static final String tagNumTriangles = "numTriangles";
    private static final String tagNumVertices = "numVertices";
    private static final String tagVertexStride = "vertexStride";
    private static final String tagVertices = "vertices";
    private FloatBuffer vertexPositions;
    private IndexBuffer indices;
    private int indexStride;
    private int numTriangles;
    private int numVertices;
    private int vertexStride;

    protected IndexedMesh() {
    }

    public IndexedMesh(CollisionShape shape, int resolution, boolean dedup) {
        Validate.nonNull((Object)shape, (String)"shape");
        Validate.inRange((int)resolution, (String)"resolution", (int)0, (int)2);
        FloatBuffer positionBuffer = DebugShapeFactory.getDebugTriangles(shape, resolution);
        Mesh jmeMesh = new Mesh();
        jmeMesh.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        if (dedup) {
            jmeMesh = MyMesh.addIndices((Mesh)jmeMesh);
        }
        this.create(jmeMesh, null);
    }

    public IndexedMesh(Mesh jmeMesh) {
        Validate.nonNull((Object)jmeMesh, (String)"JME mesh");
        Validate.require((boolean)MyMesh.hasTriangles((Mesh)jmeMesh), (String)"mode=Triangles/TriangleFan/TriangleStrip");
        this.create(jmeMesh, null);
    }

    public IndexedMesh(Mesh jmeMesh, Transform transform) {
        Validate.nonNull((Object)jmeMesh, (String)"JME mesh");
        Validate.require((boolean)MyMesh.hasTriangles((Mesh)jmeMesh), (String)"mode=Triangles/TriangleFan/TriangleStrip");
        Validate.nonNull((Object)transform, (String)"transform");
        this.create(jmeMesh, transform);
    }

    public IndexedMesh(Vector3f[] positionArray, int[] indexArray) {
        Validate.nonNull((Object)positionArray, (String)"position array");
        Validate.nonNull((Object)indexArray, (String)"index array");
        int numIndices = indexArray.length;
        Validate.require((numIndices % 3 == 0 ? 1 : 0) != 0, (String)"length a multiple of 3");
        this.numVertices = positionArray.length;
        this.vertexPositions = BufferUtils.createFloatBuffer((Vector3f[])positionArray);
        this.vertexStride = 12;
        this.numTriangles = numIndices / 3;
        IntBuffer buffer = BufferUtils.createIntBuffer((int[])indexArray);
        this.indices = IndexBuffer.wrapIndexBuffer((Buffer)buffer);
        int indexBytes = this.indices.getFormat().getComponentSize();
        this.indexStride = 3 * indexBytes;
        this.createMesh();
    }

    public IndexedMesh(FloatBuffer buffer) {
        Validate.nonNull((Object)buffer, (String)"buffer");
        int numFloats = buffer.limit();
        Validate.require((numFloats % 9 == 0 ? 1 : 0) != 0, (String)"limit a multiple of 9");
        DistinctVectorValues dvv = new DistinctVectorValues(buffer, 0, numFloats);
        this.numVertices = dvv.countDistinct();
        this.vertexPositions = BufferUtils.createFloatBuffer((int)(3 * this.numVertices));
        this.vertexStride = 12;
        int numIndices = numFloats / 3;
        this.numTriangles = numIndices / 3;
        this.indices = IndexBuffer.createIndexBuffer((int)this.numVertices, (int)numIndices);
        int indexBytes = this.indices.getFormat().getComponentSize();
        this.indexStride = 3 * indexBytes;
        Vector3f tmpVector = new Vector3f();
        for (int oldVi = 0; oldVi < numIndices; ++oldVi) {
            int newVi = dvv.findVvid(oldVi);
            assert (newVi >= 0) : newVi;
            this.indices.put(oldVi, newVi);
            int readPosition = 3 * oldVi;
            MyBuffer.get((FloatBuffer)buffer, (int)readPosition, (Vector3f)tmpVector);
            int writePosition = 3 * newVi;
            MyBuffer.put((FloatBuffer)this.vertexPositions, (int)writePosition, (Vector3f)tmpVector);
        }
        this.createMesh();
    }

    public IndexedMesh(FloatBuffer positionBuffer, IntBuffer indexBuffer) {
        Validate.nonNull((Object)positionBuffer, (String)"position buffer");
        Validate.nonNull((Object)indexBuffer, (String)"index buffer");
        int numFloats = positionBuffer.capacity();
        Validate.require((numFloats % 3 == 0 ? 1 : 0) != 0, (String)"capacity a multiple of 3");
        int numIndices = indexBuffer.capacity();
        Validate.require((numIndices % 3 == 0 ? 1 : 0) != 0, (String)"capacity a multiple of 3");
        this.numVertices = numFloats / 3;
        this.vertexPositions = positionBuffer;
        this.vertexStride = 12;
        this.numTriangles = numIndices / 3;
        this.indices = IndexBuffer.wrapIndexBuffer((Buffer)indexBuffer);
        int indexBytes = this.indices.getFormat().getComponentSize();
        this.indexStride = 3 * indexBytes;
        this.createMesh();
    }

    public IndexedMesh(CollisionShape shape, int meshResolution) {
        Validate.nonNull((Object)shape, (String)"shape");
        Validate.require((!(shape instanceof CompoundCollisionShape) ? 1 : 0) != 0, (String)"not a compound shape");
        Validate.inRange((int)meshResolution, (String)"mesh resolution", (int)0, (int)2);
        long shapeId = shape.nativeId();
        long meshId = IndexedMesh.createIntDebug(shapeId, meshResolution);
        this.setNativeId(meshId);
        logger.log(Level.FINE, "Created {0}", this);
        this.numVertices = IndexedMesh.countVertices(meshId);
        int numFloats = this.numVertices * 3;
        this.vertexPositions = BufferUtils.createFloatBuffer((int)numFloats);
        this.vertexStride = 12;
        this.numTriangles = IndexedMesh.countTriangles(meshId);
        int numIndices = this.numTriangles * 3;
        IntBuffer indexBuffer = BufferUtils.createIntBuffer((int)numIndices);
        this.indices = IndexBuffer.wrapIndexBuffer((Buffer)indexBuffer);
        int indexBytes = this.indices.getFormat().getComponentSize();
        this.indexStride = 3 * indexBytes;
        IndexedMesh.fillBuffersInt(meshId, this.vertexPositions, indexBuffer);
    }

    public IntBuffer copyIndices() {
        int numInts = this.indices.size();
        IntBuffer result = BufferUtils.createIntBuffer((int)numInts);
        for (int bufPos = 0; bufPos < numInts; ++bufPos) {
            int tmpIndex = this.indices.get(bufPos);
            result.put(tmpIndex);
        }
        return result;
    }

    public void copyTriangle(int triangleIndex, Triangle destination) {
        Validate.inRange((int)triangleIndex, (String)"triangle index", (int)0, (int)(this.numTriangles - 1));
        Validate.nonNull((Object)destination, (String)"destination");
        int startPosition = triangleIndex * 3;
        Vector3f tmpVector = new Vector3f();
        for (int vertexI = 0; vertexI < 3; ++vertexI) {
            int indexPosition = startPosition + vertexI;
            int vertexIndex = this.indices.get(indexPosition);
            MyBuffer.get((FloatBuffer)this.vertexPositions, (int)(vertexIndex * 3), (Vector3f)tmpVector);
            destination.set(vertexI, tmpVector);
        }
    }

    public FloatBuffer copyTriangles() {
        int numIndices = this.numTriangles * 3;
        int numFloats = numIndices * 3;
        FloatBuffer result = BufferUtils.createFloatBuffer((int)numFloats);
        for (int ii = 0; ii < numIndices; ++ii) {
            int startOffset = this.indices.get(ii) * 3;
            float x = this.vertexPositions.get(startOffset);
            float y = this.vertexPositions.get(startOffset + 1);
            float z = this.vertexPositions.get(startOffset + 2);
            result.put(x).put(y).put(z);
        }
        assert (result.position() == result.capacity());
        return result;
    }

    public FloatBuffer copyVertexPositions() {
        int numFloats = this.numVertices * 3;
        FloatBuffer result = BufferUtils.createFloatBuffer((int)numFloats);
        for (int bufPos = 0; bufPos < numFloats; ++bufPos) {
            float tmpFloat = this.vertexPositions.get(bufPos);
            result.put(tmpFloat);
        }
        return result;
    }

    public int countTriangles() {
        assert (this.numTriangles >= 0) : this.numTriangles;
        return this.numTriangles;
    }

    public int countVertices() {
        assert (this.numVertices >= 0) : this.numVertices;
        return this.numVertices;
    }

    public VectorSet distinctVertices() {
        int numFloats = this.numVertices * 3;
        assert (this.vertexPositions.capacity() == numFloats);
        VectorSet result = MyBuffer.distinct((FloatBuffer)this.vertexPositions, (int)0, (int)numFloats);
        return result;
    }

    public Vector3f[] footprint(Transform meshToWorld) {
        int position;
        int vectorIndex;
        Validate.nonNull((Object)meshToWorld, (String)"mesh-to-world transform");
        VectorSet distinct = this.distinctVertices();
        FloatBuffer floatBuffer = distinct.toBuffer();
        int numFloats = floatBuffer.limit();
        MyBuffer.transform((FloatBuffer)floatBuffer, (int)0, (int)numFloats, (Transform)meshToWorld);
        float minY = Float.POSITIVE_INFINITY;
        int numVectors = numFloats / 3;
        for (vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            position = vectorIndex * 3 + 1;
            float y = floatBuffer.get(position);
            if (!(y < minY)) continue;
            minY = y;
        }
        for (vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            position = vectorIndex * 3 + 1;
            floatBuffer.put(position, minY);
        }
        RectangularSolid solid = new RectangularSolid(floatBuffer, 0, numFloats);
        Vector3f maxima = solid.maxima(null);
        Vector3f minima = solid.minima(null);
        float midX = (minima.x + maxima.x) / 2.0f;
        Vector3f[] cornerLocations = new Vector3f[]{new Vector3f(midX, maxima.y, maxima.z), new Vector3f(midX, minima.y, maxima.z), new Vector3f(midX, maxima.y, minima.z), new Vector3f(midX, minima.y, minima.z)};
        for (Vector3f location : cornerLocations) {
            solid.localToWorld(location, location);
        }
        return cornerLocations;
    }

    public float maxDistance(Transform meshToWorld) {
        Validate.nonNull((Object)meshToWorld, (String)"meshToWorld");
        double maxSquaredDistance = 0.0;
        Vector3f tmpVector = new Vector3f();
        for (int i = 0; i < this.numVertices; ++i) {
            MyBuffer.get((FloatBuffer)this.vertexPositions, (int)(3 * i), (Vector3f)tmpVector);
            MyMath.transform((Transform)meshToWorld, (Vector3f)tmpVector, (Vector3f)tmpVector);
            double lengthSquared = MyVector3f.lengthSquared((Vector3f)tmpVector);
            if (!(lengthSquared > maxSquaredDistance)) continue;
            maxSquaredDistance = lengthSquared;
        }
        float result = (float)Math.sqrt(maxSquaredDistance);
        return result;
    }

    public void maxMin(Vector3f storeMaxima, Vector3f storeMinima) {
        Validate.nonNull((Object)storeMaxima, (String)"store maxima");
        Validate.nonNull((Object)storeMinima, (String)"store minima");
        int numFloats = this.numVertices * 3;
        MyBuffer.maxMin((FloatBuffer)this.vertexPositions, (int)0, (int)numFloats, (Vector3f)storeMaxima, (Vector3f)storeMinima);
    }

    public IndexedMesh[] split(Plane splittingPlane) {
        IndexedMesh[] result;
        block4: {
            FloatBuffer[] buffers;
            block2: {
                int numPlus;
                block3: {
                    Validate.nonNull((Object)splittingPlane, (String)"splitting plane");
                    buffers = new FloatBuffer[2];
                    int cap = 2 * this.numTriangles * 3 * 3;
                    buffers[0] = BufferUtils.createFloatBuffer((int)cap);
                    buffers[1] = BufferUtils.createFloatBuffer((int)cap);
                    Triangle triangle = new Triangle();
                    for (int triangleI = 0; triangleI < this.numTriangles; ++triangleI) {
                        this.copyTriangle(triangleI, triangle);
                        IndexedMesh.splitTriangle(triangle, splittingPlane, buffers);
                    }
                    result = new IndexedMesh[2];
                    int numMinus = buffers[0].position();
                    numPlus = buffers[1].position();
                    if (numMinus != 0 && numPlus != 0) break block2;
                    if (numMinus <= 0) break block3;
                    result[0] = this;
                    break block4;
                }
                if (numPlus <= 0) break block4;
                result[1] = this;
                break block4;
            }
            for (int sideI = 0; sideI < 2; ++sideI) {
                buffers[sideI].flip();
                result[sideI] = new IndexedMesh(buffers[sideI]);
            }
        }
        return result;
    }

    public float surfaceArea() {
        double total = 0.0;
        Triangle tmpTriangle = new Triangle();
        for (int triIndex = 0; triIndex < this.numTriangles; ++triIndex) {
            this.copyTriangle(triIndex, tmpTriangle);
            double triangleArea = MyMath.area((Triangle)tmpTriangle);
            total += triangleArea;
        }
        float result = (float)total;
        assert (result >= 0.0f) : result;
        return result;
    }

    public float volumeConvex() {
        double total = 0.0;
        if (this.numTriangles > 0) {
            Vector3f v0 = new Vector3f();
            MyBuffer.get((FloatBuffer)this.vertexPositions, (int)0, (Vector3f)v0);
            Triangle tri = new Triangle();
            for (int triIndex = 0; triIndex < this.numTriangles; ++triIndex) {
                this.copyTriangle(triIndex, tri);
                double tetraVolume = MyVolume.tetrahedronVolume((Vector3f)tri.get1(), (Vector3f)tri.get2(), (Vector3f)tri.get3(), (Vector3f)v0);
                total += tetraVolume;
            }
        }
        float result = (float)total;
        assert (result >= 0.0f) : result;
        return result;
    }

    public void cloneFields(Cloner cloner, Object original) {
        IndexedMesh originalMesh = (IndexedMesh)original;
        int numFloats = this.vertexPositions.capacity();
        this.vertexPositions = BufferUtils.createFloatBuffer((int)numFloats);
        for (int offset = 0; offset < numFloats; ++offset) {
            float tmpFloat = originalMesh.vertexPositions.get(offset);
            this.vertexPositions.put(offset, tmpFloat);
        }
        int numIndices = this.indices.getBuffer().capacity();
        this.indices = IndexBuffer.createIndexBuffer((int)this.numVertices, (int)numIndices);
        for (int offset = 0; offset < numIndices; ++offset) {
            int tmpIndex = originalMesh.indices.get(offset);
            this.indices.put(offset, tmpIndex);
        }
        this.unassignNativeObject();
        this.createMesh();
    }

    public IndexedMesh jmeClone() {
        try {
            IndexedMesh clone = (IndexedMesh)this.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.indexStride = capsule.readInt(tagIndexStride, 12);
        this.numTriangles = capsule.readInt(tagNumTriangles, 0);
        this.numVertices = capsule.readInt(tagNumVertices, 0);
        this.vertexStride = capsule.readInt(tagVertexStride, 12);
        assert (this.vertexStride == 12) : this.vertexStride;
        int[] intArray = capsule.readIntArray(tagIndexInts, new int[0]);
        int numIndices = intArray.length;
        assert (numIndices == this.numTriangles * 3);
        switch (this.indexStride) {
            case 3: {
                ByteBuffer byteBuf = BufferUtils.createByteBuffer((int)numIndices);
                this.indices = IndexBuffer.wrapIndexBuffer((Buffer)byteBuf);
                break;
            }
            case 6: {
                ShortBuffer sBuf = BufferUtils.createShortBuffer((int)numIndices);
                this.indices = IndexBuffer.wrapIndexBuffer((Buffer)sBuf);
                break;
            }
            case 12: {
                IntBuffer intBuffer = BufferUtils.createIntBuffer((int)numIndices);
                this.indices = IndexBuffer.wrapIndexBuffer((Buffer)intBuffer);
                break;
            }
            default: {
                throw new RuntimeException("indexStride = " + this.indexStride);
            }
        }
        for (int offset = 0; offset < numIndices; ++offset) {
            int tmpIndex = intArray[offset];
            this.indices.put(offset, tmpIndex);
        }
        float[] floatArray = capsule.readFloatArray(tagVertices, new float[0]);
        assert (floatArray.length == this.numVertices * 3);
        this.vertexPositions = BufferUtils.createFloatBuffer((float[])floatArray);
        this.createMesh();
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        int numIndices = this.numTriangles * 3;
        int[] intArray = new int[numIndices];
        for (int offset = 0; offset < numIndices; ++offset) {
            intArray[offset] = this.indices.get(offset);
        }
        capsule.write(intArray, tagIndexInts, null);
        capsule.write(this.indexStride, tagIndexStride, 12);
        capsule.write(this.numTriangles, tagNumTriangles, 0);
        capsule.write(this.numVertices, tagNumVertices, 0);
        capsule.write(this.vertexStride, tagVertexStride, 12);
        int numFloats = this.vertexPositions.capacity();
        float[] floatArray = new float[numFloats];
        for (int offset = 0; offset < numFloats; ++offset) {
            floatArray[offset] = this.vertexPositions.get(offset);
        }
        capsule.write(floatArray, tagVertices, null);
    }

    private void create(Mesh jmeMesh, Transform transform) {
        assert (MyMesh.hasTriangles((Mesh)jmeMesh));
        this.numVertices = jmeMesh.getVertexCount();
        if (this.numVertices <= 0) {
            this.numVertices = 0;
        }
        FloatBuffer meshVs = jmeMesh.getFloatBuffer(VertexBuffer.Type.Position);
        int numFloats = 3 * this.numVertices;
        this.vertexPositions = BufferUtils.createFloatBuffer((int)numFloats);
        for (int offset = 0; offset < numFloats; ++offset) {
            float temp = meshVs.get(offset);
            this.vertexPositions.put(offset, temp);
        }
        this.vertexStride = 12;
        if (transform != null && !MyMath.isIdentity((Transform)transform)) {
            MyBuffer.transform((FloatBuffer)this.vertexPositions, (int)0, (int)numFloats, (Transform)transform);
        }
        this.numTriangles = jmeMesh.getTriangleCount();
        if (this.numTriangles <= 0) {
            this.numTriangles = 0;
        }
        int numIndices = 3 * this.numTriangles;
        this.indices = IndexBuffer.createIndexBuffer((int)this.numVertices, (int)numIndices);
        IndexBuffer triangleIndices = jmeMesh.getIndicesAsList();
        for (int offset = 0; offset < numIndices; ++offset) {
            int index = triangleIndices.get(offset);
            assert (index >= 0) : index;
            assert (index < this.numVertices) : index;
            this.indices.put(offset, index);
        }
        int indexBytes = this.indices.getFormat().getComponentSize();
        this.indexStride = 3 * indexBytes;
        this.createMesh();
    }

    private void createMesh() {
        long meshId;
        assert (this.vertexStride == 12) : this.vertexStride;
        switch (this.indexStride) {
            case 3: {
                ByteBuffer byteBuffer = (ByteBuffer)this.indices.getBuffer();
                meshId = IndexedMesh.createByte(byteBuffer, this.vertexPositions, this.numTriangles, this.numVertices, this.vertexStride, this.indexStride);
                break;
            }
            case 6: {
                ShortBuffer shortBuffer = (ShortBuffer)this.indices.getBuffer();
                meshId = IndexedMesh.createShort(shortBuffer, this.vertexPositions, this.numTriangles, this.numVertices, this.vertexStride, this.indexStride);
                break;
            }
            case 12: {
                IntBuffer intBuffer = (IntBuffer)this.indices.getBuffer();
                meshId = IndexedMesh.createInt(intBuffer, this.vertexPositions, this.numTriangles, this.numVertices, this.vertexStride, this.indexStride);
                break;
            }
            default: {
                throw new RuntimeException("indexStride = " + this.indexStride);
            }
        }
        this.setNativeId(meshId);
        logger.log(Level.FINE, "Created {0}", this);
    }

    private static void freeNativeObject(long meshId) {
        assert (meshId != 0L);
        IndexedMesh.finalizeNative(meshId);
    }

    private static void putTriangle(FloatBuffer buffer, Vector3f v1, Vector3f v2, Vector3f v3) {
        if (v1.equals((Object)v2) || v1.equals((Object)v3) || v2.equals((Object)v3)) {
            return;
        }
        buffer.put(v1.x).put(v1.y).put(v1.z);
        buffer.put(v2.x).put(v2.y).put(v2.z);
        buffer.put(v3.x).put(v3.y).put(v3.z);
    }

    private static void splitTriangle(Triangle input, Plane splittingPlane, FloatBuffer[] putResults) {
        Vector3f a = input.get1();
        Vector3f b = input.get2();
        Vector3f c = input.get3();
        float aa = splittingPlane.pseudoDistance(a);
        float bb = splittingPlane.pseudoDistance(b);
        float cc = splittingPlane.pseudoDistance(c);
        if (aa == 0.0f && bb == 0.0f && cc == 0.0f) {
            IndexedMesh.putTriangle(putResults[0], a, b, c);
            IndexedMesh.putTriangle(putResults[1], a, b, c);
        } else if (aa <= 0.0f && bb <= 0.0f && cc <= 0.0f) {
            IndexedMesh.putTriangle(putResults[0], a, b, c);
        } else if (aa >= 0.0f && bb >= 0.0f && cc >= 0.0f) {
            IndexedMesh.putTriangle(putResults[1], a, b, c);
        } else if (aa >= 0.0f && bb <= 0.0f && cc <= 0.0f) {
            float tab = aa / (aa - bb);
            Vector3f ab = MyVector3f.lerp((float)tab, (Vector3f)a, (Vector3f)b, null);
            float tac = aa / (aa - cc);
            Vector3f ac = MyVector3f.lerp((float)tac, (Vector3f)a, (Vector3f)c, null);
            IndexedMesh.putTriangle(putResults[0], b, c, ac);
            IndexedMesh.putTriangle(putResults[0], b, ac, ab);
            IndexedMesh.putTriangle(putResults[1], a, ab, ac);
        } else if (aa <= 0.0f && bb >= 0.0f && cc >= 0.0f) {
            float tab = -aa / (bb - aa);
            Vector3f ab = MyVector3f.lerp((float)tab, (Vector3f)a, (Vector3f)b, null);
            float tac = -aa / (cc - aa);
            Vector3f ac = MyVector3f.lerp((float)tac, (Vector3f)a, (Vector3f)c, null);
            IndexedMesh.putTriangle(putResults[1], b, c, ac);
            IndexedMesh.putTriangle(putResults[1], b, ac, ab);
            IndexedMesh.putTriangle(putResults[0], a, ab, ac);
        } else if (aa <= 0.0f && bb >= 0.0f && cc <= 0.0f) {
            float tab = -aa / (bb - aa);
            Vector3f ab = MyVector3f.lerp((float)tab, (Vector3f)a, (Vector3f)b, null);
            float tbc = bb / (bb - cc);
            Vector3f bc = MyVector3f.lerp((float)tbc, (Vector3f)b, (Vector3f)c, null);
            IndexedMesh.putTriangle(putResults[0], a, bc, c);
            IndexedMesh.putTriangle(putResults[0], a, ab, bc);
            IndexedMesh.putTriangle(putResults[1], b, bc, ab);
        } else if (aa >= 0.0f && bb <= 0.0f && cc >= 0.0f) {
            float tab = aa / (aa - bb);
            Vector3f ab = MyVector3f.lerp((float)tab, (Vector3f)a, (Vector3f)b, null);
            float tbc = -bb / (cc - bb);
            Vector3f bc = MyVector3f.lerp((float)tbc, (Vector3f)b, (Vector3f)c, null);
            IndexedMesh.putTriangle(putResults[1], a, bc, c);
            IndexedMesh.putTriangle(putResults[1], a, ab, bc);
            IndexedMesh.putTriangle(putResults[0], b, bc, ab);
        } else if (aa <= 0.0f && bb <= 0.0f && cc >= 0.0f) {
            float tac = -aa / (cc - aa);
            Vector3f ac = MyVector3f.lerp((float)tac, (Vector3f)a, (Vector3f)c, null);
            float tbc = -bb / (cc - bb);
            Vector3f bc = MyVector3f.lerp((float)tbc, (Vector3f)b, (Vector3f)c, null);
            IndexedMesh.putTriangle(putResults[0], a, b, bc);
            IndexedMesh.putTriangle(putResults[0], a, bc, ac);
            IndexedMesh.putTriangle(putResults[1], ac, bc, c);
        } else {
            assert (aa >= 0.0f) : aa;
            assert (bb >= 0.0f) : bb;
            assert (cc <= 0.0f) : cc;
            float tac = aa / (aa - cc);
            Vector3f ac = MyVector3f.lerp((float)tac, (Vector3f)a, (Vector3f)c, null);
            float tbc = bb / (bb - cc);
            Vector3f bc = MyVector3f.lerp((float)tbc, (Vector3f)b, (Vector3f)c, null);
            IndexedMesh.putTriangle(putResults[1], a, b, bc);
            IndexedMesh.putTriangle(putResults[1], a, bc, ac);
            IndexedMesh.putTriangle(putResults[0], ac, bc, c);
        }
    }

    private static native int countTriangles(long var0);

    private static native int countVertices(long var0);

    private static native long createByte(ByteBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native long createInt(IntBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native long createIntDebug(long var0, int var2);

    private static native long createShort(ShortBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native void fillBuffersInt(long var0, FloatBuffer var2, IntBuffer var3);

    private static native void finalizeNative(long var0);
}

