/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.PhysicsSweepTestResult;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;

public class BetterCharacterControl
extends AbstractPhysicsControl
implements PhysicsTickListener {
    public static final Logger logger2 = Logger.getLogger(BetterCharacterControl.class.getName());
    private static final String tagBody = "body";
    private static final String tagDuckedFactor = "duckedFactor";
    private static final String tagHeight = "height";
    private static final String tagJumpForce = "jumpForce";
    private static final String tagMass = "mass";
    private static final String tagPhysicsDamping = "physicsDamping";
    private static final String tagRadius = "radius";
    private static final String tagViewDirection = "viewDirection";
    private static final String tagWalkDirection = "walkDirection";
    private boolean isDucked = false;
    private boolean onGround = false;
    private boolean wantToJump = false;
    private boolean wantToUnDuck = false;
    private float dampingFactor = 0.9f;
    private float duckedFactor = 0.6f;
    private float initialHeight;
    private float initialRadius;
    private float mass;
    private PhysicsRigidBody rigidBody;
    private Quaternion localToWorld = new Quaternion();
    private Quaternion viewToWorld = new Quaternion();
    private SphereCollisionShape sweepShape;
    private Transform sweepBegin = new Transform();
    private Transform sweepEnd = new Transform();
    private Vector3f baseLocation = new Vector3f();
    private Vector3f jumpImpulse = new Vector3f();
    private Vector3f localForward = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f localLeft = new Vector3f(1.0f, 0.0f, 0.0f);
    private Vector3f localUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Vector3f velocity = new Vector3f();
    private Vector3f viewDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f viewDirInWorld = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f walkVelocity = new Vector3f();

    protected BetterCharacterControl() {
    }

    public BetterCharacterControl(float radius, float height, float mass) {
        Validate.positive((float)radius, (String)tagRadius);
        Validate.require((height > 2.0f * radius ? 1 : 0) != 0, (String)"height more than 2x the radius");
        Validate.positive((float)mass, (String)tagMass);
        this.initialRadius = radius;
        this.initialHeight = height;
        this.mass = mass;
        CollisionShape shape = this.getShape();
        this.rigidBody = new PhysicsRigidBody(shape, mass);
        float upwardImpulse = 5.0f * mass;
        this.jumpImpulse = new Vector3f(0.0f, upwardImpulse, 0.0f);
        this.rigidBody.setAngularFactor(0.0f);
    }

    public float getDuckedFactor() {
        return this.duckedFactor;
    }

    public Vector3f getGravity(Vector3f storeResult) {
        Vector3f result = this.rigidBody.getGravity(storeResult);
        return result;
    }

    public float getInitialHeight() {
        return this.initialHeight;
    }

    public float getInitialRadius() {
        return this.initialRadius;
    }

    public Vector3f getJumpForce(Vector3f storeResult) {
        if (storeResult == null) {
            return this.jumpImpulse.clone();
        }
        return storeResult.set(this.jumpImpulse);
    }

    public float getPhysicsDamping() {
        return this.dampingFactor;
    }

    public PhysicsRigidBody getRigidBody() {
        assert (this.rigidBody != null);
        return this.rigidBody;
    }

    public Vector3f getVelocity() {
        Vector3f result = this.getVelocity(null);
        return result;
    }

    public Vector3f getVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.velocity.clone() : storeResult.set(this.velocity);
        return result;
    }

    public Vector3f getViewDirection() {
        return this.getViewDirection(null);
    }

    public Vector3f getViewDirection(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.viewDirection.clone() : storeResult.set(this.viewDirection);
        return result;
    }

    public Vector3f getWalkDirection(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.walkVelocity.clone() : storeResult.set(this.walkVelocity);
        return result;
    }

    public boolean isDucked() {
        return this.isDucked;
    }

    public boolean isKinematic() {
        boolean result = !this.rigidBody.isDynamic();
        return result;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void jump() {
        this.wantToJump = true;
    }

    public void resetForward(Vector3f vec) {
        if (!this.rigidBody.isDynamic()) {
            return;
        }
        if (vec == null) {
            this.localForward.set(0.0f, 0.0f, 1.0f);
        } else {
            this.localForward.set(vec);
        }
        this.updateLocalCoordinateSystem();
    }

    public void setDucked(boolean newState) {
        if (newState) {
            this.setHeightPercent(this.duckedFactor);
            this.isDucked = true;
            this.wantToUnDuck = false;
        } else {
            this.wantToUnDuck = true;
        }
    }

    public void setDuckedFactor(float factor) {
        Validate.fraction((float)factor, (String)"factor");
        this.duckedFactor = factor;
    }

    public void setGravity(Vector3f newGravity) {
        Validate.finite((Vector3f)newGravity, (String)"new gravity");
        this.rigidBody.setGravity(newGravity);
        this.localUp.set(newGravity).normalizeLocal().negateLocal();
        this.updateLocalCoordinateSystem();
    }

    public void setJumpForce(Vector3f newImpulse) {
        Validate.finite((Vector3f)newImpulse, (String)"new impulse");
        this.jumpImpulse.set(newImpulse);
    }

    public void setKinematic(boolean newSetting) {
        this.rigidBody.setKinematic(newSetting);
    }

    public void setPhysicsDamping(float newFactor) {
        Validate.fraction((float)newFactor, (String)"new factor");
        this.dampingFactor = newFactor;
    }

    public void setViewDirection(Vector3f newDirection) {
        assert (Validate.nonZero((Vector3f)newDirection, (String)"new direction"));
        if (this.rigidBody.isDynamic()) {
            this.viewDirection.set(newDirection);
            this.updateLocalViewDirection();
        }
    }

    public void setWalkDirection(Vector3f newVelocity) {
        this.walkVelocity.set(newVelocity);
    }

    public void warp(Vector3f newLocation) {
        Validate.finite((Vector3f)newLocation, (String)"new location");
        if (this.rigidBody.isDynamic()) {
            this.setPhysicsLocation(newLocation);
        }
    }

    @Override
    protected void addPhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.getGravity(this.localUp);
        this.localUp.normalizeLocal();
        this.localUp.negateLocal();
        this.updateLocalCoordinateSystem();
        space.addCollisionObject(this.rigidBody);
        space.addTickListener(this);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.sweepShape = null;
        this.sweepEnd = (Transform)cloner.clone((Object)this.sweepEnd);
        this.sweepBegin = (Transform)cloner.clone((Object)this.sweepBegin);
        this.jumpImpulse = (Vector3f)cloner.clone((Object)this.jumpImpulse);
        this.localForward = (Vector3f)cloner.clone((Object)this.localForward);
        this.localToWorld = (Quaternion)cloner.clone((Object)this.localToWorld);
        this.localLeft = (Vector3f)cloner.clone((Object)this.localLeft);
        this.localUp = (Vector3f)cloner.clone((Object)this.localUp);
        this.baseLocation = (Vector3f)cloner.clone((Object)this.baseLocation);
        this.rigidBody = (PhysicsRigidBody)cloner.clone((Object)this.rigidBody);
        this.viewDirInWorld = (Vector3f)cloner.clone((Object)this.viewDirInWorld);
        this.viewToWorld = (Quaternion)cloner.clone((Object)this.viewToWorld);
        this.scale = (Vector3f)cloner.clone((Object)this.scale);
        this.velocity = (Vector3f)cloner.clone((Object)this.velocity);
        this.viewDirection = (Vector3f)cloner.clone((Object)this.viewDirection);
        this.walkVelocity = (Vector3f)cloner.clone((Object)this.walkVelocity);
    }

    @Override
    protected void createSpatialData(Spatial spatial) {
        this.rigidBody.setUserObject(spatial);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.initialRadius = capsule.readFloat(tagRadius, 1.0f);
        this.initialHeight = capsule.readFloat(tagHeight, 2.0f);
        this.mass = capsule.readFloat(tagMass, 80.0f);
        this.jumpImpulse = (Vector3f)capsule.readSavable(tagJumpForce, (Savable)new Vector3f(0.0f, this.mass * 5.0f, 0.0f));
        this.dampingFactor = capsule.readFloat(tagPhysicsDamping, 0.9f);
        this.duckedFactor = capsule.readFloat(tagDuckedFactor, 0.6f);
        this.viewDirection = (Vector3f)capsule.readSavable(tagViewDirection, (Savable)new Vector3f(0.0f, 0.0f, 1.0f));
        this.walkVelocity = (Vector3f)capsule.readSavable(tagWalkDirection, (Savable)new Vector3f(0.0f, 0.0f, 1.0f));
        this.rigidBody = (PhysicsRigidBody)capsule.readSavable(tagBody, null);
        Spatial controlled = this.getSpatial();
        this.rigidBody.setUserObject(controlled);
    }

    @Override
    protected void removePhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.removeCollisionObject(this.rigidBody);
        space.removeTickListener(this);
    }

    @Override
    protected void removeSpatialData(Spatial spatial) {
        this.rigidBody.setUserObject(null);
    }

    @Override
    protected void setPhysicsLocation(Vector3f newLocation) {
        Validate.finite((Vector3f)newLocation, (String)"new location");
        this.rigidBody.setPhysicsLocation(newLocation);
        this.baseLocation.set(newLocation);
    }

    @Override
    protected void setPhysicsRotation(Quaternion newOrientation) {
        Validate.nonZero((Quaternion)newOrientation, (String)"new orientation");
        this.viewToWorld.set(newOrientation);
        this.viewDirInWorld.set(this.viewDirection);
        MyQuaternion.rotate((Quaternion)this.viewToWorld, (Vector3f)this.viewDirInWorld, (Vector3f)this.viewDirInWorld);
        this.updateLocalViewDirection();
    }

    public void update(float tpf) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.rigidBody.isDynamic()) {
            this.rigidBody.getPhysicsLocation(this.baseLocation);
            this.applyPhysicsTransform(this.baseLocation, this.viewToWorld);
        } else {
            this.baseLocation.set(this.getSpatialTranslation());
            this.setPhysicsLocation(this.baseLocation);
            this.viewToWorld.set(this.getSpatialRotation());
            this.setPhysicsRotation(this.viewToWorld);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.initialRadius, tagRadius, 1.0f);
        capsule.write(this.initialHeight, tagHeight, 2.0f);
        capsule.write(this.mass, tagMass, 80.0f);
        capsule.write((Savable)this.jumpImpulse, tagJumpForce, null);
        capsule.write(this.dampingFactor, tagPhysicsDamping, 0.9f);
        capsule.write(this.duckedFactor, tagDuckedFactor, 0.6f);
        capsule.write((Savable)this.viewDirection, tagViewDirection, null);
        capsule.write((Savable)this.walkVelocity, tagWalkDirection, null);
        capsule.write((Savable)this.rigidBody, tagBody, null);
    }

    @Override
    public void physicsTick(PhysicsSpace space, float timeStep) {
        if (this.rigidBody.isDynamic()) {
            this.rigidBody.getLinearVelocity(this.velocity);
        } else {
            this.velocity.zero();
        }
    }

    @Override
    public void prePhysicsTick(PhysicsSpace space, float timeStep) {
        this.checkOnGround();
        if (this.wantToUnDuck && this.checkCanUnDuck()) {
            this.setHeightPercent(1.0f);
            this.wantToUnDuck = false;
            this.isDucked = false;
        }
        if (this.rigidBody.isDynamic()) {
            this.dynamicPreTick();
        }
        this.wantToJump = false;
    }

    protected void calculateNewForward(Quaternion rotation, Vector3f direction, Vector3f worldUpVector) {
        if (direction == null) {
            return;
        }
        TempVars vars = TempVars.get();
        Vector3f newLeft = vars.vect1;
        Vector3f newLeftNegate = vars.vect2;
        newLeft.set(worldUpVector);
        newLeft.crossLocal(direction);
        newLeft.normalizeLocal();
        if (MyVector3f.isZero((Vector3f)newLeft)) {
            if (direction.x != 0.0f) {
                newLeft.set(direction.y, -direction.x, 0.0f);
            } else {
                newLeft.set(0.0f, direction.z, -direction.y);
            }
            newLeft.normalizeLocal();
            if (logger2.isLoggable(Level.INFO)) {
                logger2.log(Level.INFO, "Zero left for direction {0}, up {1}", new Object[]{direction, worldUpVector});
            }
        }
        newLeftNegate.set(newLeft);
        newLeftNegate.negateLocal();
        direction.set(worldUpVector);
        direction.crossLocal(newLeftNegate);
        direction.normalizeLocal();
        if (MyVector3f.isZero((Vector3f)direction)) {
            direction.set(0.0f, 0.0f, 1.0f);
            if (logger2.isLoggable(Level.INFO)) {
                logger2.log(Level.INFO, "Zero left for left {0}, up {1}", new Object[]{newLeft, worldUpVector});
            }
        }
        if (rotation != null) {
            rotation.fromAxes(newLeft, worldUpVector, direction);
        }
        vars.release();
    }

    protected boolean checkCanUnDuck() {
        Vector3f startLocation = this.sweepBegin.getTranslation();
        startLocation.set(this.baseLocation);
        float currentHeight = this.getFinalHeight();
        float bodyRadius = this.getFinalRadius();
        MyVector3f.accumulateScaled((Vector3f)startLocation, (Vector3f)this.localUp, (float)(currentHeight - bodyRadius));
        Vector3f endLocation = this.sweepEnd.getTranslation();
        endLocation.set(this.baseLocation);
        MyVector3f.accumulateScaled((Vector3f)endLocation, (Vector3f)this.localUp, (float)(this.initialHeight - bodyRadius));
        if (this.sweepShape == null || this.sweepShape.getRadius() != bodyRadius) {
            this.sweepShape = new SphereCollisionShape(bodyRadius);
        }
        PhysicsSpace space = this.getPhysicsSpace();
        List<PhysicsSweepTestResult> results = space.sweepTest(this.sweepShape, this.sweepBegin, this.sweepEnd);
        boolean isObstructed = false;
        for (PhysicsSweepTestResult result : results) {
            PhysicsCollisionObject object = result.getCollisionObject();
            if (object.equals(this.rigidBody)) continue;
            isObstructed = true;
            break;
        }
        return !isObstructed;
    }

    protected void checkOnGround() {
        Vector3f startLocation = this.sweepBegin.getTranslation();
        startLocation.set(this.baseLocation);
        float scaledHeight = this.getFinalHeight();
        MyVector3f.accumulateScaled((Vector3f)startLocation, (Vector3f)this.localUp, (float)(scaledHeight / 2.0f));
        Vector3f endLocation = this.sweepEnd.getTranslation();
        endLocation.set(this.baseLocation);
        float bodyRadius = this.getFinalRadius();
        float margin = this.rigidBody.getCollisionShape().getMargin();
        MyVector3f.accumulateScaled((Vector3f)endLocation, (Vector3f)this.localUp, (float)(bodyRadius - margin));
        if (this.sweepShape == null || this.sweepShape.getRadius() != bodyRadius) {
            this.sweepShape = new SphereCollisionShape(bodyRadius);
        }
        PhysicsSpace space = this.getPhysicsSpace();
        List<PhysicsSweepTestResult> results = space.sweepTest(this.sweepShape, this.sweepBegin, this.sweepEnd);
        boolean isSupported = false;
        for (PhysicsSweepTestResult result : results) {
            PhysicsCollisionObject object = result.getCollisionObject();
            if (object.equals(this.rigidBody)) continue;
            isSupported = true;
            break;
        }
        this.onGround = isSupported;
    }

    protected float getFinalHeight() {
        float result = this.initialHeight * this.scale.y;
        assert (result > 0.0f) : result;
        return result;
    }

    protected float getFinalRadius() {
        float result = this.initialRadius * this.scale.z;
        assert (result > 0.0f) : result;
        return result;
    }

    protected CollisionShape getShape() {
        float scaledRadius = this.getFinalRadius();
        float totalHeight = this.getFinalHeight();
        float cylinderHeight = totalHeight - 2.0f * scaledRadius;
        CapsuleCollisionShape capsule = new CapsuleCollisionShape(scaledRadius, cylinderHeight);
        CompoundCollisionShape result = new CompoundCollisionShape(1);
        float yOffset = totalHeight / 2.0f;
        result.addChildShape(capsule, 0.0f, yOffset, 0.0f);
        return result;
    }

    protected void setHeightPercent(float fraction) {
        this.scale.setY(fraction);
        CollisionShape newShape = this.getShape();
        this.rigidBody.setCollisionShape(newShape);
    }

    protected void updateLocalCoordinateSystem() {
        this.calculateNewForward(this.localToWorld, this.localForward, this.localUp);
        this.localLeft.set(this.localUp);
        this.localLeft.crossLocal(this.localForward);
        this.rigidBody.setPhysicsRotation(this.localToWorld);
        this.updateLocalViewDirection();
    }

    protected void updateLocalViewDirection() {
        this.viewDirInWorld.set(this.viewDirection);
        MyQuaternion.rotate((Quaternion)this.localToWorld, (Vector3f)this.viewDirInWorld, (Vector3f)this.viewDirInWorld);
        this.calculateNewForward(this.viewToWorld, this.viewDirInWorld, this.localUp);
    }

    private void dynamicPreTick() {
        TempVars vars = TempVars.get();
        Vector3f currentVelocity = vars.vect2;
        currentVelocity.set(this.velocity);
        float left = this.velocity.dot(this.localLeft) * this.dampingFactor;
        float forward = this.velocity.dot(this.localForward) * this.dampingFactor;
        Vector3f counter = vars.vect1;
        counter.set(-left, 0.0f, -forward);
        MyQuaternion.rotate((Quaternion)this.localToWorld, (Vector3f)counter, (Vector3f)counter);
        this.velocity.addLocal(counter);
        float requestedSpeed = this.walkVelocity.length();
        if (requestedSpeed > 0.0f) {
            Vector3f localWalkDirection = vars.vect1;
            localWalkDirection.set(this.walkVelocity);
            localWalkDirection.normalizeLocal();
            float speed = this.velocity.dot(localWalkDirection);
            float additionalSpeed = requestedSpeed - speed;
            localWalkDirection.multLocal(additionalSpeed);
            this.velocity.addLocal(localWalkDirection);
        }
        if (currentVelocity.distance(this.velocity) > 1.0E-4f) {
            this.rigidBody.setLinearVelocity(this.velocity);
        }
        if (this.wantToJump && this.onGround) {
            Vector3f impulseInWorld = vars.vect1;
            impulseInWorld.set(this.jumpImpulse);
            MyQuaternion.rotate((Quaternion)this.localToWorld, (Vector3f)impulseInWorld, (Vector3f)impulseInWorld);
            this.rigidBody.applyCentralImpulse(impulseInWorld);
        }
        vars.release();
    }
}

