/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class CharacterControl
extends AbstractPhysicsControl {
    public static final Logger logger2 = Logger.getLogger(CharacterControl.class.getName());
    private static final String tagCharacter = "character";
    private static final String tagViewDirection = "viewDirection";
    private PhysicsCharacter character = null;
    private static final Quaternion tmpOrientation = new Quaternion();
    private Vector3f viewDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3f tmpVector = new Vector3f();

    protected CharacterControl() {
    }

    public CharacterControl(ConvexShape shape, float stepHeight) {
        this.character = new PhysicsCharacter(shape, stepHeight);
    }

    public PhysicsCharacter getCharacter() {
        assert (this.character != null);
        return this.character;
    }

    public Vector3f getPhysicsLocation() {
        Vector3f result = this.character.getPhysicsLocation(null);
        return result;
    }

    public Vector3f getViewDirection(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.viewDirection.clone() : storeResult.set(this.viewDirection);
        return result;
    }

    public void jump() {
        this.character.jump();
    }

    public boolean onGround() {
        boolean result = this.character.onGround();
        return result;
    }

    public void setFallSpeed(float speed) {
        this.character.setFallSpeed(speed);
    }

    public void setGravity(float downwardAcceleration) {
        this.character.setGravity(downwardAcceleration);
    }

    public void setJumpSpeed(float speed) {
        this.character.setJumpSpeed(speed);
    }

    public void setViewDirection(Vector3f direction) {
        Validate.nonZero((Vector3f)direction, (String)"direction");
        this.viewDirection.set(direction);
        MyVector3f.normalizeLocal((Vector3f)this.viewDirection);
    }

    public void setWalkDirection(Vector3f offset) {
        Validate.finite((Vector3f)offset, (String)"offset");
        this.character.setWalkDirection(offset);
    }

    @Override
    protected void addPhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.addCollisionObject(this.character);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.character = (PhysicsCharacter)cloner.clone((Object)this.character);
        this.viewDirection = (Vector3f)cloner.clone((Object)this.viewDirection);
    }

    @Override
    protected void createSpatialData(Spatial spatial) {
        this.character.setUserObject(spatial);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.character = (PhysicsCharacter)capsule.readSavable(tagCharacter, null);
        this.viewDirection = (Vector3f)capsule.readSavable(tagViewDirection, (Savable)new Vector3f(0.0f, 0.0f, 1.0f));
        if (this.character != null) {
            Spatial controlled = this.getSpatial();
            this.character.setUserObject(controlled);
        }
    }

    @Override
    protected void removePhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.removeCollisionObject(this.character);
    }

    @Override
    protected void removeSpatialData(Spatial spatial) {
        this.character.setUserObject(null);
    }

    @Override
    public void setPhysicsLocation(Vector3f location) {
        this.character.setPhysicsLocation(location);
    }

    @Override
    protected void setPhysicsRotation(Quaternion orientation) {
    }

    public void update(float tpf) {
        if (!this.isEnabled()) {
            return;
        }
        this.character.getUpDirection(tmpVector);
        tmpOrientation.lookAt(this.viewDirection, tmpVector);
        this.character.getPhysicsLocation(tmpVector);
        this.applyPhysicsTransform(tmpVector, tmpOrientation);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.character, tagCharacter, null);
        capsule.write((Savable)this.viewDirection, tagViewDirection, null);
    }
}

