/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class JoinedBodyControl
extends AbstractPhysicsControl {
    public static final Logger logger3 = Logger.getLogger(JoinedBodyControl.class.getName());
    private static final String tagRigidBody = "rigidBody";
    private PhysicsRigidBody rigidBody;
    private static final Quaternion tmpUpdateOrientation = new Quaternion();
    private static final Vector3f tmpUpdateLocation = new Vector3f();

    protected JoinedBodyControl() {
    }

    public JoinedBodyControl(CollisionShape bodyShape, float mass) {
        Validate.nonNull((Object)bodyShape, (String)"shape");
        Validate.positive((float)mass, (String)"mass");
        this.rigidBody = new PhysicsRigidBody(bodyShape, mass);
        this.rigidBody.setUserObject(this);
    }

    public PhysicsRigidBody getRigidBody() {
        return this.rigidBody;
    }

    public boolean isKinematic() {
        boolean result = !this.rigidBody.isDynamic();
        return result;
    }

    public void setKinematic(boolean newSetting) {
        this.rigidBody.setKinematic(newSetting);
    }

    @Override
    protected void addPhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.addCollisionObject(this.rigidBody);
        for (PhysicsJoint joint : this.rigidBody.listJoints()) {
            space.addJoint(joint);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.rigidBody = (PhysicsRigidBody)cloner.clone((Object)this.rigidBody);
    }

    @Override
    protected void createSpatialData(Spatial spatial) {
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.rigidBody = (PhysicsRigidBody)capsule.readSavable(tagRigidBody, null);
        this.rigidBody.setUserObject(this);
    }

    @Override
    protected void removePhysics() {
        PhysicsJoint[] joints;
        PhysicsSpace space = this.getPhysicsSpace();
        for (PhysicsJoint joint : joints = this.rigidBody.listJoints()) {
            joint.destroy();
            space.removeJoint(joint);
        }
        space.removeCollisionObject(this.rigidBody);
    }

    @Override
    protected void removeSpatialData(Spatial spatial) {
    }

    @Override
    public void setPhysicsLocation(Vector3f newLocation) {
        Validate.finite((Vector3f)newLocation, (String)"new location");
        this.rigidBody.setPhysicsLocation(newLocation);
    }

    @Override
    protected void setPhysicsRotation(Quaternion newOrientation) {
        Validate.nonZero((Quaternion)newOrientation, (String)"new orientation");
        this.rigidBody.setPhysicsRotation(newOrientation);
    }

    public void update(float tpf) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.rigidBody.isDynamic()) {
            RigidBodyMotionState motionState = this.rigidBody.getMotionState();
            motionState.getLocation(tmpUpdateLocation);
            motionState.getOrientation(tmpUpdateOrientation);
            this.applyPhysicsTransform(tmpUpdateLocation, tmpUpdateOrientation);
        } else {
            tmpUpdateLocation.set(this.getSpatialTranslation());
            this.setPhysicsLocation(tmpUpdateLocation);
            tmpUpdateOrientation.set(this.getSpatialRotation());
            this.setPhysicsRotation(tmpUpdateOrientation);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.rigidBody, tagRigidBody, null);
    }
}

