/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.bullet.util.CollisionShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MySpatial;
import jme3utilities.math.MyMath;

public class RigidBodyControl
extends PhysicsRigidBody
implements PhysicsControl {
    public static final Logger logger3 = Logger.getLogger(RigidBodyControl.class.getName());
    private static final String tagApplyLocalPhysics = "applyLocalPhysics";
    private static final String tagApplyScale = "applyScale";
    private static final String tagEnabled = "enabled";
    private static final String tagKinematicSpatial = "kinematicSpatial";
    private static final String tagSpatial = "spatial";
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private boolean added = false;
    private boolean applyScale = false;
    private boolean enabled = true;
    private boolean kinematicSpatial = true;
    private PhysicsSpace space = null;
    private Spatial spatial;

    protected RigidBodyControl() {
    }

    public RigidBodyControl(float mass) {
        this.mass = mass;
    }

    public RigidBodyControl(CollisionShape shape) {
        super(shape);
    }

    public RigidBodyControl(CollisionShape shape, float mass) {
        super(shape, mass);
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public boolean isApplyPhysicsLocal() {
        RigidBodyMotionState ms = this.getMotionState();
        boolean result = ms.isApplyPhysicsLocal();
        return result;
    }

    public boolean isApplyScale() {
        return this.applyScale;
    }

    public final boolean isKinematicSpatial() {
        return this.kinematicSpatial;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        RigidBodyMotionState ms = this.getMotionState();
        ms.setApplyPhysicsLocal(applyPhysicsLocal);
    }

    public void setApplyScale(boolean setting) {
        this.applyScale = setting;
    }

    public void setKinematicSpatial(boolean kinematicSpatial) {
        this.kinematicSpatial = kinematicSpatial;
    }

    protected void createCollisionShape() {
        if (this.spatial == null) {
            return;
        }
        CollisionShape shape = null;
        if (this.spatial instanceof Geometry) {
            Mesh mesh = ((Geometry)this.spatial).getMesh();
            if (mesh instanceof Sphere) {
                float radius = ((Sphere)mesh).getRadius();
                shape = new SphereCollisionShape(radius);
            } else if (mesh instanceof Box) {
                Box box = (Box)mesh;
                shape = new BoxCollisionShape(box.getXExtent(), box.getYExtent(), box.getZExtent());
            }
        }
        if (shape == null) {
            shape = this.mass > 0.0f ? CollisionShapeFactory.createDynamicMeshShape(this.spatial) : CollisionShapeFactory.createMeshShape(this.spatial);
        }
        this.setCollisionShape(shape);
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("cloneForSpatial() isn't implemented.");
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!enabled && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (this.space == newSpace) {
            return;
        }
        if (this.added) {
            this.space.removeCollisionObject(this);
            this.added = false;
        }
        if (newSpace != null && this.isEnabled()) {
            if (!this.hasAssignedNativeObject()) {
                String message = "Cannot add an incomplete RigidBodyControl to a PhysicsSpace.";
                throw new IllegalStateException(message);
            }
            newSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = newSpace;
    }

    public void setSpatial(Spatial controlledSpatial) {
        if (this.spatial == controlledSpatial) {
            return;
        }
        this.spatial = controlledSpatial;
        this.setUserObject(controlledSpatial);
        if (controlledSpatial != null) {
            if (this.getCollisionShape() == null) {
                this.createCollisionShape();
                this.rebuildRigidBody();
            }
            Vector3f location = this.getSpatialTranslation();
            this.setPhysicsLocation(location);
            Quaternion orientation = this.getSpatialRotation();
            this.setPhysicsRotation(orientation);
        }
    }

    public void update(float tpf) {
        if (!this.enabled) {
            return;
        }
        if (this.isKinematic() && this.kinematicSpatial) {
            this.setPhysicsLocation(this.getSpatialTranslation());
            this.setPhysicsRotation(this.getSpatialRotation());
            if (this.applyScale) {
                Vector3f newScale;
                CollisionShape shape = this.getCollisionShape();
                if (!shape.canScale(newScale = this.copySpatialScale(null))) {
                    float factor = MyMath.cubeRoot((float)(newScale.x * newScale.y * newScale.z));
                    newScale.set(factor, factor, factor);
                }
                if (shape.canScale(newScale)) {
                    this.setPhysicsScale(newScale);
                }
            }
        } else if (!MySpatial.isIgnoringTransforms((Spatial)this.spatial)) {
            this.getMotionState().applyTransform(this.spatial);
            if (this.applyScale) {
                this.applySpatialScale();
            }
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        RigidBodyControl old = (RigidBodyControl)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.spatial = (Spatial)cloner.clone((Object)this.spatial);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.enabled = capsule.readBoolean(tagEnabled, true);
        this.kinematicSpatial = capsule.readBoolean(tagKinematicSpatial, true);
        this.spatial = (Spatial)capsule.readSavable(tagSpatial, null);
        RigidBodyMotionState ms = this.getMotionState();
        ms.setApplyPhysicsLocal(capsule.readBoolean(tagApplyLocalPhysics, false));
        this.applyScale = capsule.readBoolean(tagApplyScale, false);
        this.setUserObject(this.spatial);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.enabled, tagEnabled, true);
        RigidBodyMotionState ms = this.getMotionState();
        capsule.write(ms.isApplyPhysicsLocal(), tagApplyLocalPhysics, false);
        capsule.write(this.kinematicSpatial, tagKinematicSpatial, true);
        capsule.write(this.applyScale, tagApplyScale, false);
        capsule.write((Savable)this.spatial, tagSpatial, null);
    }

    private void applySpatialScale() {
        Node parent;
        Vector3f scale = this.getScale(null);
        if (!this.isApplyPhysicsLocal() && (parent = this.spatial.getParent()) != null) {
            Vector3f parentScale = parent.getWorldScale();
            if (parentScale.x == 0.0f || parentScale.y == 0.0f || parentScale.z == 0.0f) {
                throw new IllegalStateException("Zero in parent scale.");
            }
            scale.divideLocal(parentScale);
        }
        this.spatial.setLocalScale(scale);
    }

    private Vector3f copySpatialScale(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (MySpatial.isIgnoringTransforms((Spatial)this.spatial)) {
            result.set(scaleIdentity);
        } else if (this.isApplyPhysicsLocal()) {
            Vector3f scale = this.spatial.getLocalScale();
            result.set(scale);
        } else {
            Vector3f scale = this.spatial.getWorldScale();
            result.set(scale);
        }
        return result;
    }

    private Quaternion getSpatialRotation() {
        RigidBodyMotionState ms;
        Quaternion result = MySpatial.isIgnoringTransforms((Spatial)this.spatial) ? rotateIdentity : ((ms = this.getMotionState()).isApplyPhysicsLocal() ? this.spatial.getLocalRotation() : this.spatial.getWorldRotation());
        return result;
    }

    private Vector3f getSpatialTranslation() {
        RigidBodyMotionState ms;
        Vector3f result = MySpatial.isIgnoringTransforms((Spatial)this.spatial) ? translateIdentity : ((ms = this.getMotionState()).isApplyPhysicsLocal() ? this.spatial.getLocalTranslation() : this.spatial.getWorldTranslation());
        return result;
    }
}

