/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSoftSpace;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.bullet.control.UseTriangles;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.bullet.util.NativeSoftBodyUtil;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MySpatial;
import jme3utilities.Validate;
import jme3utilities.math.IntPair;
import jme3utilities.math.MyMath;

public class SoftBodyControl
extends AbstractPhysicsControl {
    public static final Logger logger2 = Logger.getLogger(SoftBodyControl.class.getName());
    private static final String tagBody = "body";
    private static final String tagGeometry = "geometry";
    private static final String tagMergeVertices = "mergeVertices";
    private static final String tagUpdateNormals = "updateNormals";
    private static final String tagUseTriangles = "useTriangles";
    private boolean mergeVertices = true;
    private boolean updateNormals = true;
    private Geometry geometry = null;
    private IntBuffer indexMap = null;
    private PhysicsSoftBody body = null;
    private UseTriangles useTriangles = UseTriangles.FacesOnly;

    public SoftBodyControl() {
    }

    public SoftBodyControl(boolean localPhysics, boolean updateNormals, boolean mergeVertices) {
        this(localPhysics, updateNormals, mergeVertices, UseTriangles.FacesOnly);
    }

    public SoftBodyControl(boolean localPhysics, boolean updateNormals, boolean mergeVertices, UseTriangles useTriangles) {
        Validate.nonNull((Object)((Object)useTriangles), (String)"use triangles");
        super.setApplyPhysicsLocal(localPhysics);
        this.mergeVertices = mergeVertices;
        this.updateNormals = updateNormals;
        this.useTriangles = useTriangles;
    }

    public PhysicsSoftBody getBody() {
        return this.body;
    }

    @Override
    protected void addPhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.addCollisionObject(this.body);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.geometry = (Geometry)cloner.clone((Object)this.geometry);
        this.body = (PhysicsSoftBody)cloner.clone((Object)this.body);
        if (this.indexMap != null) {
            SoftBodyControl originalControl = (SoftBodyControl)original;
            int numIndices = this.indexMap.limit();
            this.indexMap = BufferUtils.createIntBuffer((int)numIndices);
            for (int offset = 0; offset < numIndices; ++offset) {
                int tmpIndex = originalControl.indexMap.get(offset);
                this.indexMap.put(tmpIndex);
            }
        }
    }

    @Override
    protected void createSpatialData(Spatial spatial) {
        this.body = new PhysicsSoftBody();
        this.body.setUserObject(spatial);
        List geometries = MySpatial.listGeometries((Spatial)spatial);
        this.geometry = (Geometry)geometries.get(0);
        Mesh mesh = this.geometry.getMesh();
        if (mesh.getBuffer(VertexBuffer.Type.Normal) == null) {
            this.updateNormals = false;
        }
        this.appendFromGeometry();
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.body = (PhysicsSoftBody)capsule.readSavable(tagBody, null);
        this.geometry = (Geometry)capsule.readSavable(tagGeometry, null);
        this.mergeVertices = capsule.readBoolean(tagMergeVertices, false);
        this.updateNormals = capsule.readBoolean(tagUpdateNormals, false);
        this.useTriangles = (UseTriangles)capsule.readEnum(tagUseTriangles, UseTriangles.class, (Enum)UseTriangles.FacesOnly);
        if (this.body != null) {
            Spatial controlled = this.getSpatial();
            this.body.setUserObject(controlled);
        }
    }

    @Override
    protected void removePhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.removeCollisionObject(this.body);
    }

    @Override
    protected void removeSpatialData(Spatial spatial) {
        this.body.setUserObject(null);
        this.body = null;
    }

    @Override
    public void setPhysicsLocation(Vector3f location) {
        Validate.finite((Vector3f)location, (String)"location");
        this.body.setPhysicsLocation(location);
    }

    @Override
    protected void setPhysicsRotation(Quaternion orientation) {
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (newSpace != null && !(newSpace instanceof PhysicsSoftSpace)) {
            throw new IllegalArgumentException("The PhysicsSpace must be a PhysicsSoftSpace or null.");
        }
        super.setPhysicsSpace(newSpace);
    }

    public void update(float tpf) {
        Transform physicsToMesh;
        if (!this.isEnabled()) {
            return;
        }
        Spatial spatial = this.getSpatial();
        Transform meshToWorld = this.geometry.getWorldTransform();
        Transform worldToMesh = meshToWorld.invert();
        if (this.isApplyPhysicsLocal()) {
            Transform localToWorld = spatial.getWorldTransform();
            physicsToMesh = MyMath.combine((Transform)localToWorld, (Transform)worldToMesh, null);
        } else {
            physicsToMesh = worldToMesh;
        }
        Mesh mesh = this.geometry.getMesh();
        boolean localFlag = false;
        NativeSoftBodyUtil.updateMesh(this.body, this.indexMap, mesh, localFlag, this.updateNormals, physicsToMesh);
        spatial.updateModelBound();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.body, tagBody, null);
        capsule.write((Savable)this.geometry, tagGeometry, null);
        capsule.write(this.mergeVertices, tagMergeVertices, false);
        capsule.write(this.updateNormals, tagUpdateNormals, false);
        capsule.write((Enum)this.useTriangles, tagUseTriangles, (Enum)UseTriangles.FacesOnly);
    }

    private void appendFromGeometry() {
        Transform meshToPhysics;
        assert (this.body.isEmpty());
        Mesh mesh = this.geometry.getMesh();
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        int numVertices = mesh.getVertexCount();
        IndexBuffer links = null;
        IndexBuffer faces = null;
        block0 : switch (mesh.getMode()) {
            case Lines: 
            case LineLoop: 
            case LineStrip: {
                links = mesh.getIndicesAsList();
                break;
            }
            case Triangles: 
            case TriangleFan: 
            case TriangleStrip: {
                switch (this.useTriangles) {
                    case FacesAndLinks: {
                        faces = mesh.getIndicesAsList();
                        links = SoftBodyControl.trianglesToLines(faces, numVertices);
                        break block0;
                    }
                    case FacesOnly: {
                        faces = mesh.getIndicesAsList();
                        break block0;
                    }
                    case Ignore: {
                        break block0;
                    }
                    case LinksOnly: {
                        faces = mesh.getIndicesAsList();
                        links = SoftBodyControl.trianglesToLines(faces, numVertices);
                        faces = null;
                        break block0;
                    }
                }
                throw new IllegalStateException("useTriangles = " + (Object)((Object)this.useTriangles));
            }
            default: {
                throw new IllegalStateException(mesh.getMode().name());
            }
        }
        if (this.mergeVertices) {
            this.indexMap = NativeSoftBodyUtil.generateIndexMap(positions);
            positions = NativeSoftBodyUtil.mapVertexData(this.indexMap, positions, 3);
            if (links != null) {
                links = NativeSoftBodyUtil.mapIndices(this.indexMap, links, null);
            }
            if (faces != null) {
                faces = NativeSoftBodyUtil.mapIndices(this.indexMap, faces, null);
            }
        } else {
            this.indexMap = null;
        }
        this.body.appendNodes(positions);
        if (links != null) {
            this.body.appendLinks(links);
        }
        if (faces != null) {
            this.body.appendFaces(faces);
        }
        Transform meshToWorld = this.geometry.getWorldTransform();
        if (this.isApplyPhysicsLocal()) {
            Spatial spatial = this.getSpatial();
            Transform localToWorld = spatial.getWorldTransform();
            Transform worldToLocal = localToWorld.invert();
            meshToPhysics = MyMath.combine((Transform)meshToWorld, (Transform)worldToLocal, null);
        } else {
            meshToPhysics = meshToWorld;
        }
        this.body.applyTransform(meshToPhysics);
    }

    private static IndexBuffer trianglesToLines(IndexBuffer indexList, int numVertices) {
        Validate.nonNull((Object)indexList, (String)"index list");
        Validate.require((indexList.size() % 3 == 0 ? 1 : 0) != 0, (String)"size a multiple of 3");
        Validate.positive((int)numVertices, (String)"number of vertices");
        int numTriangles = indexList.size() / 3;
        HashSet<IntPair> edgeSet = new HashSet<IntPair>(3 * numTriangles);
        for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
            int intOffset = 3 * triIndex;
            int ti0 = indexList.get(intOffset);
            int ti1 = indexList.get(intOffset + 1);
            int ti2 = indexList.get(intOffset + 2);
            edgeSet.add(new IntPair(ti0, ti1));
            edgeSet.add(new IntPair(ti0, ti2));
            edgeSet.add(new IntPair(ti1, ti2));
        }
        int numEdges = edgeSet.size();
        int numIndices = 2 * numEdges;
        IndexBuffer result = IndexBuffer.createIndexBuffer((int)numVertices, (int)numIndices);
        for (IntPair edge : edgeSet) {
            result.put(edge.smaller());
            result.put(edge.larger());
        }
        Buffer ibData = result.getBuffer();
        ibData.flip();
        return result;
    }
}

