/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MySpatial;

public class VehicleControl
extends PhysicsVehicle
implements PhysicsControl {
    public static final Logger logger4 = Logger.getLogger(VehicleControl.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final String tagApplyLocalPhysics = "applyLocalPhysics";
    private static final String tagEnabled = "enabled";
    private static final String tagSpatial = "spatial";
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private boolean added = false;
    private boolean enabled = true;
    private PhysicsSpace space = null;
    private Spatial spatial;

    protected VehicleControl() {
    }

    public VehicleControl(CollisionShape shape) {
        super(shape);
    }

    public VehicleControl(CollisionShape shape, float mass) {
        super(shape, mass);
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public boolean isApplyPhysicsLocal() {
        RigidBodyMotionState ms = this.getMotionState();
        return ms.isApplyPhysicsLocal();
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        RigidBodyMotionState motionsState = this.getMotionState();
        motionsState.setApplyPhysicsLocal(applyPhysicsLocal);
        int numWheels = this.getNumWheels();
        for (int wheelIndex = 0; wheelIndex < numWheels; ++wheelIndex) {
            VehicleWheel wheel = this.getWheel(wheelIndex);
            wheel.setApplyLocal(applyPhysicsLocal);
        }
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("cloneForSpatial() isn't implemented.");
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!enabled && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (this.space == newSpace) {
            return;
        }
        if (this.added) {
            this.space.removeCollisionObject(this);
            this.added = false;
        }
        if (newSpace != null && this.isEnabled()) {
            newSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = newSpace;
    }

    public void setSpatial(Spatial controlledSpatial) {
        this.spatial = controlledSpatial;
        this.setUserObject(controlledSpatial);
        if (controlledSpatial != null) {
            this.setPhysicsLocation(this.getSpatialTranslation());
            this.setPhysicsRotation(this.getSpatialRotation());
        }
    }

    public void update(float tpf) {
        if (!this.enabled) {
            return;
        }
        if (this.spatial != null) {
            if (this.getMotionState().applyTransform(this.spatial)) {
                this.spatial.getWorldTransform();
                this.applyWheelTransforms();
            }
        } else {
            this.applyWheelTransforms();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        VehicleControl old = (VehicleControl)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.spatial = (Spatial)cloner.clone((Object)this.spatial);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.enabled = capsule.readBoolean(tagEnabled, true);
        this.spatial = (Spatial)capsule.readSavable(tagSpatial, null);
        RigidBodyMotionState ms = this.getMotionState();
        ms.setApplyPhysicsLocal(capsule.readBoolean(tagApplyLocalPhysics, false));
        this.setUserObject(this.spatial);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.enabled, tagEnabled, true);
        RigidBodyMotionState ms = this.getMotionState();
        capsule.write(ms.isApplyPhysicsLocal(), tagApplyLocalPhysics, false);
        capsule.write((Savable)this.spatial, tagSpatial, null);
    }

    private Quaternion getSpatialRotation() {
        if (MySpatial.isIgnoringTransforms((Spatial)this.spatial)) {
            return rotateIdentity;
        }
        RigidBodyMotionState ms = this.getMotionState();
        if (ms.isApplyPhysicsLocal()) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    private Vector3f getSpatialTranslation() {
        RigidBodyMotionState ms;
        Vector3f result = MySpatial.isIgnoringTransforms((Spatial)this.spatial) ? translateIdentity : ((ms = this.getMotionState()).isApplyPhysicsLocal() ? this.spatial.getLocalTranslation() : this.spatial.getWorldTranslation());
        return result;
    }
}

