/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.CollisionShapeDebugControl;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;

public class BulletCharacterDebugControl
extends CollisionShapeDebugControl {
    public static final Logger logger = Logger.getLogger(BulletCharacterDebugControl.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private int oldResolution;
    private MeshNormals oldNormals;
    private final PhysicsCharacter character;
    private static final Vector3f tmpCenter = new Vector3f();

    public BulletCharacterDebugControl(BulletDebugAppState debugAppState, PhysicsCharacter ch) {
        super(debugAppState);
        this.character = ch;
        super.setShape(this.character.getCollisionShape());
        this.oldNormals = this.character.debugMeshNormals();
        this.oldResolution = this.character.debugMeshResolution();
        this.debugSpatial = DebugShapeFactory.getDebugShape(this.character);
        this.debugSpatial.setName(ch.toString());
        this.updateMaterial();
    }

    protected void controlUpdate(float tpf) {
        CollisionShape newShape = this.character.getCollisionShape();
        MeshNormals newNormals = this.character.debugMeshNormals();
        int newResolution = this.character.debugMeshResolution();
        boolean rebuild = this.hasShapeChanged(newShape) ? true : (this.oldNormals != newNormals ? true : this.oldResolution != newResolution);
        if (rebuild) {
            logger.log(Level.INFO, "Rebuild debugSpatial for {0}.", this.character);
            this.setShape(newShape);
            this.oldNormals = newNormals;
            this.oldResolution = newResolution;
            Node node = (Node)this.spatial;
            node.detachChild(this.debugSpatial);
            this.debugSpatial = DebugShapeFactory.getDebugShape(this.character);
            this.debugSpatial.setName(this.character.toString());
            node.attachChild(this.debugSpatial);
        }
        this.updateMaterial();
        this.character.getPhysicsLocation(tmpCenter);
        this.applyPhysicsTransform(tmpCenter, rotateIdentity);
    }

    private void updateMaterial() {
        Material material = this.character.getDebugMaterial();
        if (material == BulletDebugAppState.enableChildColoring) {
            if (this.debugSpatial instanceof Node) {
                this.colorChildren();
                return;
            }
            material = null;
        }
        if (material == null) {
            int numSides = this.character.debugNumSides();
            material = this.character.isContactResponse() ? this.debugAppState.getCharacterMaterial(numSides) : this.debugAppState.getGhostMaterial(numSides);
        }
        this.debugSpatial.setMaterial(material);
    }
}

