/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.AnchorDebugControl;
import com.jme3.bullet.debug.AngularVelocityDebugControl;
import com.jme3.bullet.debug.BoundingBoxDebugControl;
import com.jme3.bullet.debug.BulletCharacterDebugControl;
import com.jme3.bullet.debug.BulletGhostObjectDebugControl;
import com.jme3.bullet.debug.BulletRigidBodyDebugControl;
import com.jme3.bullet.debug.BulletVehicleDebugControl;
import com.jme3.bullet.debug.ConstraintDebugControl;
import com.jme3.bullet.debug.DebugConfiguration;
import com.jme3.bullet.debug.DebugInitListener;
import com.jme3.bullet.debug.GravityVectorDebugControl;
import com.jme3.bullet.debug.SoftJointDebugControl;
import com.jme3.bullet.debug.SweptSphereDebugControl;
import com.jme3.bullet.debug.VelocityVectorDebugControl;
import com.jme3.bullet.joints.Anchor;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.SoftPhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Transform;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyAsset;
import jme3utilities.Validate;
import jme3utilities.debug.AxesVisualizer;
import jme3utilities.math.MyMath;

public class BulletDebugAppState
extends BaseAppState {
    private static final ColorRGBA blueColor = new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f);
    private static final ColorRGBA brownColor = new ColorRGBA(0.25490198f, 0.15686275f, 0.09803922f, 1.0f);
    private static final ColorRGBA cyanColor = new ColorRGBA(0.0f, 1.0f, 1.0f, 1.0f);
    private static final ColorRGBA greenColor = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    private static final ColorRGBA magentaColor = new ColorRGBA(1.0f, 0.0f, 1.0f, 1.0f);
    private static final ColorRGBA orangeColor = new ColorRGBA(0.9843137f, 0.50980395f, 0.0f, 1.0f);
    private static final ColorRGBA pinkColor = new ColorRGBA(1.0f, 0.68f, 0.68f, 1.0f);
    private static final ColorRGBA redColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    private static final ColorRGBA whiteColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private static final ColorRGBA yellowColor = new ColorRGBA(1.0f, 1.0f, 0.0f, 1.0f);
    public static final Logger logger = Logger.getLogger(BulletDebugAppState.class.getName());
    public static final Material enableChildColoring = new Material();
    private static final Transform transformIdentity = new Transform();
    private AssetManager assetManager;
    private final DebugConfiguration configuration;
    private HashMap<PhysicsCollisionObject, Node> pcoMap = new HashMap(64);
    private HashMap<PhysicsJoint, Node> jointMap = new HashMap(64);
    private final Material[] blues = new Material[3];
    private final Material[] childMaterials = new Material[10];
    private Material gravity;
    private Material jointMaterialA;
    private Material jointMaterialB;
    private final Material[] magentas = new Material[3];
    private final Material[] pink = new Material[3];
    private Material white;
    private final Material[] yellows = new Material[3];
    private final Node root = new Node("Physics Debug Root Node");

    public BulletDebugAppState(DebugConfiguration config) {
        Validate.nonNull((Object)config, (String)"configuration");
        this.configuration = config;
    }

    Material getActiveMaterial(int numSides) {
        Material result = this.magentas[numSides];
        assert (result != null);
        return result;
    }

    Material getAngularVelocityMaterial() {
        assert (this.magentas[2] != null);
        return this.magentas[2];
    }

    Material getBoundingBoxMaterial() {
        assert (this.white != null);
        return this.white;
    }

    Material getCharacterMaterial(int numSides) {
        Material result = this.pink[numSides];
        assert (result != null);
        return result;
    }

    Material getChildMaterial(int childIndex) {
        assert (childIndex >= 0) : childIndex;
        int materialIndex = MyMath.modulo((int)childIndex, (int)this.childMaterials.length);
        Material result = this.childMaterials[materialIndex];
        assert (result != null);
        return result;
    }

    DebugConfiguration getConfiguration() {
        return this.configuration;
    }

    Material getGhostMaterial(int numSides) {
        Material result = this.yellows[numSides];
        assert (result != null);
        return result;
    }

    Material getGravityVectorMaterial() {
        assert (this.gravity != null);
        return this.gravity;
    }

    Material getInactiveMaterial(int numSides) {
        Material result = this.blues[numSides];
        assert (result != null);
        return result;
    }

    Material getJointMaterial(JointEnd end) {
        Material result;
        switch (end) {
            case A: {
                result = this.jointMaterialA;
                break;
            }
            case B: {
                result = this.jointMaterialB;
                break;
            }
            default: {
                throw new IllegalArgumentException(end.toString());
            }
        }
        assert (result != null);
        return result;
    }

    public Node getRootNode() {
        return this.root;
    }

    Material getSweptSphereMaterial() {
        assert (this.white != null);
        return this.white;
    }

    Material getVelocityVectorMaterial() {
        assert (this.white != null);
        return this.white;
    }

    public void setAngularVelocityFilter(DebugAppStateFilter filter) {
        this.configuration.setAngularVelocityFilter(filter);
        for (Node transformedNode : this.pcoMap.values()) {
            Node parent = transformedNode.getParent();
            Control control = parent.getControl(AngularVelocityDebugControl.class);
            parent.removeControl(control);
        }
    }

    public void setBoundingBoxFilter(DebugAppStateFilter filter) {
        this.configuration.setBoundingBoxFilter(filter);
        for (Node transformedNode : this.pcoMap.values()) {
            Node parent = transformedNode.getParent();
            Control control = parent.getControl(BoundingBoxDebugControl.class);
            parent.removeControl(control);
        }
    }

    public void setFilter(DebugAppStateFilter filter) {
        this.configuration.setFilter(filter);
    }

    public void setGravityVectorFilter(DebugAppStateFilter filter) {
        this.configuration.setGravityVectorFilter(filter);
        for (Node transformedNode : this.pcoMap.values()) {
            Node parent = transformedNode.getParent();
            Control control = parent.getControl(GravityVectorDebugControl.class);
            parent.removeControl(control);
        }
    }

    public void setJointLineWidth(float width) {
        Validate.inRange((float)width, (String)"width", (float)1.0f, (float)Float.MAX_VALUE);
        this.configuration.setJointLineWidth(width);
        if (this.jointMaterialA != null) {
            RenderState rs = this.jointMaterialA.getAdditionalRenderState();
            rs.setLineWidth(width);
            rs = this.jointMaterialB.getAdditionalRenderState();
            rs.setLineWidth(width);
        }
    }

    public void setSweptSphereFilter(DebugAppStateFilter filter) {
        this.configuration.setSweptSphereFilter(filter);
        for (Node transformedNode : this.pcoMap.values()) {
            Node parent = transformedNode.getParent();
            Control control = parent.getControl(SweptSphereDebugControl.class);
            parent.removeControl(control);
        }
    }

    public void setVelocityVectorFilter(DebugAppStateFilter filter) {
        this.configuration.setVelocityVectorFilter(filter);
        for (Node transformedNode : this.pcoMap.values()) {
            Node parent = transformedNode.getParent();
            Control control = parent.getControl(VelocityVectorDebugControl.class);
            parent.removeControl(control);
        }
    }

    protected void attachChild(Spatial spatial) {
        assert (spatial != null);
        this.root.attachChild(spatial);
    }

    protected Material createWireMaterial(AssetManager assetManager, ColorRGBA color, String name, int numSides) {
        Validate.nonNull((Object)assetManager, (String)"asset manager");
        Validate.nonNull((Object)color, (String)"color");
        Validate.inRange((int)numSides, (String)"number of sides", (int)1, (int)2);
        Material result = MyAsset.createWireframeMaterial((AssetManager)assetManager, (ColorRGBA)color);
        result.setName(name);
        RenderState renderState = result.getAdditionalRenderState();
        if (numSides > 1) {
            renderState.setFaceCullMode(RenderState.FaceCullMode.Off);
        }
        return result;
    }

    protected HashMap<PhysicsCollisionObject, Node> getPcoMap() {
        return this.pcoMap;
    }

    protected void setupMaterials(AssetManager am) {
        Material invisible;
        assert (am != null);
        this.blues[0] = invisible = MyAsset.createInvisibleMaterial((AssetManager)am);
        this.blues[1] = this.createWireMaterial(am, blueColor, "debug blue ss", 1);
        this.blues[1].getAdditionalRenderState().setWireframe(true);
        this.blues[1].setName("debug blue ss");
        this.blues[2] = this.createWireMaterial(am, blueColor, "debug blue ds", 2);
        this.childMaterials[0] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)whiteColor);
        this.childMaterials[1] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)redColor);
        this.childMaterials[2] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)greenColor);
        this.childMaterials[3] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)blueColor);
        this.childMaterials[4] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)yellowColor);
        this.childMaterials[5] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)cyanColor);
        this.childMaterials[6] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)orangeColor);
        this.childMaterials[7] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)magentaColor);
        this.childMaterials[8] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)pinkColor);
        this.childMaterials[9] = MyAsset.createUnshadedMaterial((AssetManager)am, (ColorRGBA)brownColor);
        for (int childI = 0; childI < this.childMaterials.length; ++childI) {
            this.childMaterials[childI].setName("debug child " + childI);
        }
        this.gravity = this.createWireMaterial(am, cyanColor, "debug gravity", 2);
        this.jointMaterialA = this.createWireMaterial(am, greenColor, "debug joint A wire", 2);
        this.jointMaterialB = this.createWireMaterial(am, redColor, "debug joint B wire", 2);
        float jointLineWidth = this.configuration.jointLineWidth();
        this.setJointLineWidth(jointLineWidth);
        this.magentas[0] = invisible;
        this.magentas[1] = this.createWireMaterial(am, magentaColor, "debug magenta ss", 1);
        this.magentas[2] = this.createWireMaterial(am, magentaColor, "debug magenta ds", 2);
        this.pink[0] = invisible;
        this.pink[1] = this.createWireMaterial(am, pinkColor, "debug pink ss", 1);
        this.pink[2] = this.createWireMaterial(am, pinkColor, "debug pink ds", 2);
        this.white = this.createWireMaterial(am, whiteColor, "debug white", 2);
        this.yellows[0] = invisible;
        this.yellows[1] = this.createWireMaterial(am, yellowColor, "debug yellow ss", 1);
        this.yellows[2] = this.createWireMaterial(am, yellowColor, "debug yellow ds", 2);
    }

    protected void updateAxes(Node node, boolean displayShape) {
        float axisLength = this.configuration.axisArrowLength();
        float axisLineWidth = this.configuration.axisLineWidth();
        boolean displayAxes = displayShape && axisLength > 0.0f;
        AxesVisualizer control = (AxesVisualizer)node.getControl(AxesVisualizer.class);
        if (control != null) {
            if (displayAxes) {
                control.setAxisLength(axisLength);
                control.setLineWidth(axisLineWidth);
            } else {
                control.setEnabled(false);
                node.removeControl((Control)control);
            }
        } else if (displayAxes) {
            control = new AxesVisualizer(this.assetManager, axisLength, axisLineWidth);
            node.addControl((Control)control);
            control.setEnabled(true);
        }
    }

    protected void updateShapes() {
        for (Map.Entry<PhysicsCollisionObject, Node> entry : this.pcoMap.entrySet()) {
            Object control;
            DebugAppStateFilter filter = this.configuration.getFilter();
            PhysicsCollisionObject pco = entry.getKey();
            boolean displayShape = filter == null || filter.displayObject(pco);
            Node node = entry.getValue();
            if (pco instanceof PhysicsCharacter) {
                control = node.getControl(BulletCharacterDebugControl.class);
                if (control == null && displayShape) {
                    logger.log(Level.FINE, "Create new BulletCharacterDebugControl");
                    control = new BulletCharacterDebugControl(this, (PhysicsCharacter)pco);
                    node.addControl(control);
                } else if (control != null && !displayShape) {
                    node.removeControl(control);
                }
                this.updateAxes(node, displayShape);
                continue;
            }
            if (pco instanceof PhysicsGhostObject) {
                control = node.getControl(BulletGhostObjectDebugControl.class);
                if (control == null && displayShape) {
                    logger.log(Level.FINE, "Create new BulletGhostObjectDebugControl");
                    control = new BulletGhostObjectDebugControl(this, (PhysicsGhostObject)pco);
                    node.addControl(control);
                } else if (control != null && !displayShape) {
                    node.removeControl(control);
                }
                this.updateAxes(node, displayShape);
                continue;
            }
            if (!(pco instanceof PhysicsRigidBody)) continue;
            control = node.getControl(BulletRigidBodyDebugControl.class);
            if (control == null && displayShape) {
                logger.log(Level.FINE, "Create new BulletRigidBodyDebugControl");
                control = new BulletRigidBodyDebugControl(this, (PhysicsRigidBody)pco);
                node.addControl(control);
            } else if (control != null && !displayShape) {
                node.removeControl(control);
            }
            this.updateAxes(node, displayShape);
        }
    }

    protected void updateVelocities() {
        this.updateAngularVelocities();
        this.updateVelocityVectors();
    }

    protected void cleanup(Application app) {
    }

    public void initialize(Application app) {
        this.assetManager = app.getAssetManager();
        this.setupMaterials(this.assetManager);
        DebugInitListener listener = this.configuration.getInitListener();
        if (listener != null) {
            listener.bulletDebugInit(this.root);
        }
        RenderQueue.ShadowMode mode = this.configuration.shadowMode();
        this.root.setShadowMode(mode);
    }

    protected void onDisable() {
        ViewPort[] viewPorts;
        for (ViewPort viewPort : viewPorts = this.configuration.listViewPorts()) {
            viewPort.detachScene((Spatial)this.root);
        }
    }

    protected void onEnable() {
        ViewPort[] viewPorts;
        for (ViewPort viewPort : viewPorts = this.configuration.listViewPorts()) {
            viewPort.attachScene((Spatial)this.root);
        }
    }

    public void render(RenderManager rm) {
        super.render(rm);
        this.configuration.renderAllViewPorts(rm, (Spatial)this.root);
    }

    public void update(float tpf) {
        super.update(tpf);
        this.updatePcoMap();
        this.updateShapes();
        this.updateVehicles();
        this.updateBoundingBoxes();
        this.updateGravityVectors();
        this.updateSweptSpheres();
        this.updateVelocities();
        this.updateJoints();
        this.root.updateLogicalState(tpf);
        Spatial transformSpatial = this.configuration.getTransformSpatial();
        if (transformSpatial == null) {
            this.root.setLocalTransform(transformIdentity);
        } else {
            Transform transform = transformSpatial.getWorldTransform();
            this.root.setLocalTransform(transform);
        }
        this.root.updateGeometricState();
    }

    private void updateAngularVelocities() {
        DebugAppStateFilter filter = this.configuration.getAngularVelocityFilter();
        if (filter == null) {
            return;
        }
        for (Map.Entry<PhysicsCollisionObject, Node> entry : this.pcoMap.entrySet()) {
            PhysicsCollisionObject pco = entry.getKey();
            boolean display = pco instanceof PhysicsRigidBody && ((PhysicsRigidBody)pco).isDynamic() && filter.displayObject(pco);
            Node transformedNode = entry.getValue();
            Node parent = transformedNode.getParent();
            Object control = parent.getControl(AngularVelocityDebugControl.class);
            if (control == null && display) {
                logger.log(Level.FINE, "Create AngularVelocityDebugControl");
                control = new AngularVelocityDebugControl(this, pco);
                parent.addControl(control);
                continue;
            }
            if (control == null || display) continue;
            parent.removeControl(control);
        }
    }

    private void updateBoundingBoxes() {
        DebugAppStateFilter filter = this.configuration.getBoundingBoxFilter();
        if (filter == null) {
            return;
        }
        for (Map.Entry<PhysicsCollisionObject, Node> entry : this.pcoMap.entrySet()) {
            PhysicsCollisionObject pco = entry.getKey();
            boolean display = filter.displayObject(pco);
            Node transformedNode = entry.getValue();
            Node parent = transformedNode.getParent();
            Object control = parent.getControl(BoundingBoxDebugControl.class);
            if (control == null && display) {
                logger.log(Level.FINE, "Create new BoundingBoxDebugControl");
                control = new BoundingBoxDebugControl(this, pco);
                parent.addControl(control);
                continue;
            }
            if (control == null || display) continue;
            parent.removeControl(control);
        }
    }

    private void updateGravityVectors() {
        DebugAppStateFilter filter = this.configuration.getGravityVectorFilter();
        if (filter == null) {
            return;
        }
        for (Map.Entry<PhysicsCollisionObject, Node> entry : this.pcoMap.entrySet()) {
            PhysicsCollisionObject pco = entry.getKey();
            boolean pcoIsKinematic = pco instanceof PhysicsRigidBody && ((PhysicsRigidBody)pco).isKinematic();
            boolean display = pco instanceof PhysicsBody && !pco.isStatic() && !pcoIsKinematic && filter.displayObject(pco);
            Node transformedNode = entry.getValue();
            Node parent = transformedNode.getParent();
            Object control = parent.getControl(GravityVectorDebugControl.class);
            if (control == null && display) {
                logger.log(Level.FINE, "Create new GravityVectorDebugControl");
                control = new GravityVectorDebugControl(this, pco);
                parent.addControl(control);
                continue;
            }
            if (control == null || display) continue;
            parent.removeControl(control);
        }
    }

    private void updateJoints() {
        DebugAppStateFilter filter = this.configuration.getFilter();
        HashMap<PhysicsJoint, Node> oldMap = this.jointMap;
        this.jointMap = new HashMap(oldMap.size());
        PhysicsSpace space = this.configuration.getSpace();
        Collection<PhysicsJoint> list = space.getJointList();
        for (PhysicsJoint joint : list) {
            if (filter != null && !filter.displayObject(joint)) continue;
            Node node = oldMap.remove(joint);
            if (node == null) {
                AbstractPhysicsDebugControl control;
                node = new Node(joint.toString());
                this.attachChild((Spatial)node);
                if (joint instanceof Anchor) {
                    logger.log(Level.FINE, "Create new AnchorDebugControl");
                    Anchor anchor = (Anchor)joint;
                    control = new AnchorDebugControl(this, anchor);
                } else if (joint instanceof Constraint) {
                    logger.log(Level.FINE, "Create new ConstraintDebugControl");
                    Constraint constraint = (Constraint)joint;
                    control = new ConstraintDebugControl(this, constraint);
                } else {
                    logger.log(Level.FINE, "Create new SoftJointDebugControl");
                    SoftPhysicsJoint softJoint = (SoftPhysicsJoint)joint;
                    control = new SoftJointDebugControl(this, softJoint);
                }
                node.addControl((Control)control);
            }
            this.jointMap.put(joint, node);
        }
        for (Node node : oldMap.values()) {
            node.removeFromParent();
        }
    }

    private void updatePcoMap() {
        HashMap<PhysicsCollisionObject, Node> oldMap = this.pcoMap;
        this.pcoMap = new HashMap(oldMap.size());
        PhysicsSpace space = this.configuration.getSpace();
        Collection<PhysicsCollisionObject> list = space.getPcoList();
        for (PhysicsCollisionObject pco : list) {
            Node node = oldMap.remove(pco);
            if (node == null) {
                Node parent = new Node(pco.toString());
                this.attachChild((Spatial)parent);
                node = new Node(pco + " transformed");
                parent.attachChild((Spatial)node);
            }
            this.pcoMap.put(pco, node);
        }
        for (Node transformedNode : oldMap.values()) {
            Node parent = transformedNode.getParent();
            parent.removeFromParent();
        }
    }

    private void updateSweptSpheres() {
        DebugAppStateFilter filter = this.configuration.getSweptSphereFilter();
        if (filter == null) {
            return;
        }
        for (Map.Entry<PhysicsCollisionObject, Node> entry : this.pcoMap.entrySet()) {
            PhysicsCollisionObject pco = entry.getKey();
            boolean display = filter.displayObject(pco) && pco.getCcdMotionThreshold() > 0.0f && pco.getCcdSweptSphereRadius() > 0.0f;
            Node transformedNode = entry.getValue();
            Node parent = transformedNode.getParent();
            Object control = parent.getControl(SweptSphereDebugControl.class);
            if (control == null && display) {
                logger.log(Level.FINE, "Create new SweptSphereDebugControl");
                control = new SweptSphereDebugControl(this, pco);
                parent.addControl(control);
                continue;
            }
            if (control == null || display) continue;
            parent.removeControl(control);
        }
    }

    private void updateVehicles() {
        DebugAppStateFilter filter = this.configuration.getFilter();
        PhysicsSpace space = this.configuration.getSpace();
        for (PhysicsVehicle vehicle : space.getVehicleList()) {
            boolean display = filter == null || filter.displayObject(vehicle);
            Node node = this.pcoMap.get(vehicle);
            Object control = node.getControl(BulletVehicleDebugControl.class);
            if (control == null && display) {
                logger.log(Level.FINE, "Create new BulletVehicleDebugControl");
                control = new BulletVehicleDebugControl(this, vehicle);
                node.addControl(control);
                continue;
            }
            if (control == null || display) continue;
            node.removeControl(control);
        }
    }

    private void updateVelocityVectors() {
        DebugAppStateFilter filter = this.configuration.getVelocityVectorFilter();
        if (filter == null) {
            return;
        }
        for (Map.Entry<PhysicsCollisionObject, Node> entry : this.pcoMap.entrySet()) {
            PhysicsCollisionObject pco = entry.getKey();
            boolean display = pco instanceof PhysicsRigidBody && ((PhysicsRigidBody)pco).isDynamic() && filter.displayObject(pco);
            Node transformedNode = entry.getValue();
            Node parent = transformedNode.getParent();
            Object control = parent.getControl(VelocityVectorDebugControl.class);
            if (control == null && display) {
                logger.log(Level.FINE, "Create new VelocityVectorDebugControl");
                control = new VelocityVectorDebugControl(this, pco);
                parent.addControl(control);
                continue;
            }
            if (control == null || display) continue;
            parent.removeControl(control);
        }
    }

    public static interface DebugAppStateFilter {
        public boolean displayObject(Object var1);
    }
}

