/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.CollisionShapeDebugControl;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;

public class BulletGhostObjectDebugControl
extends CollisionShapeDebugControl {
    public static final Logger logger = Logger.getLogger(BulletGhostObjectDebugControl.class.getName());
    private int oldResolution;
    private MeshNormals oldNormals;
    private final PhysicsGhostObject ghost;
    private final Quaternion rotation = new Quaternion();
    private final Vector3f location = new Vector3f();

    public BulletGhostObjectDebugControl(BulletDebugAppState debugAppState, PhysicsGhostObject gh) {
        super(debugAppState);
        this.ghost = gh;
        super.setShape(this.ghost.getCollisionShape());
        this.oldNormals = gh.debugMeshNormals();
        this.oldResolution = gh.debugMeshResolution();
        this.debugSpatial = DebugShapeFactory.getDebugShape(this.ghost);
        this.debugSpatial.setName(this.ghost.toString());
        this.updateMaterial();
    }

    protected void controlUpdate(float tpf) {
        CollisionShape newShape = this.ghost.getCollisionShape();
        MeshNormals newNormals = this.ghost.debugMeshNormals();
        int newResolution = this.ghost.debugMeshResolution();
        boolean rebuild = this.hasShapeChanged(newShape) ? true : (this.oldNormals != newNormals ? true : this.oldResolution != newResolution);
        if (rebuild) {
            logger.log(Level.INFO, "Rebuild debugSpatial for {0}.", this.ghost);
            this.setShape(newShape);
            this.oldNormals = newNormals;
            this.oldResolution = newResolution;
            Node node = (Node)this.spatial;
            node.detachChild(this.debugSpatial);
            this.debugSpatial = DebugShapeFactory.getDebugShape(this.ghost);
            this.debugSpatial.setName(this.ghost.toString());
            node.attachChild(this.debugSpatial);
        }
        this.updateMaterial();
        this.ghost.getPhysicsLocation(this.location);
        this.ghost.getPhysicsRotation(this.rotation);
        this.applyPhysicsTransform(this.location, this.rotation);
    }

    private void updateMaterial() {
        Material material = this.ghost.getDebugMaterial();
        if (material == BulletDebugAppState.enableChildColoring) {
            if (this.debugSpatial instanceof Node) {
                this.colorChildren();
                return;
            }
            material = null;
        }
        if (material == null) {
            int numSides = this.ghost.debugNumSides();
            material = this.debugAppState.getGhostMaterial(numSides);
        }
        this.debugSpatial.setMaterial(material);
    }
}

