/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.CollisionShapeDebugControl;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;

public class BulletRigidBodyDebugControl
extends CollisionShapeDebugControl {
    public static final Logger logger = Logger.getLogger(BulletRigidBodyDebugControl.class.getName());
    private int oldResolution;
    private MeshNormals oldNormals;
    private final PhysicsRigidBody body;
    private final Quaternion rotation = new Quaternion();
    private final Vector3f location = new Vector3f();

    public BulletRigidBodyDebugControl(BulletDebugAppState debugAppState, PhysicsRigidBody body) {
        super(debugAppState);
        this.body = body;
        super.setShape(body.getCollisionShape());
        this.oldNormals = body.debugMeshNormals();
        this.oldResolution = body.debugMeshResolution();
        this.debugSpatial = DebugShapeFactory.getDebugShape(body);
        this.debugSpatial.setName(body.toString());
        this.updateMaterial();
    }

    protected void controlUpdate(float tpf) {
        CollisionShape newShape = this.body.getCollisionShape();
        MeshNormals newNormals = this.body.debugMeshNormals();
        int newResolution = this.body.debugMeshResolution();
        boolean rebuild = this.hasShapeChanged(newShape) ? true : (this.oldNormals != newNormals ? true : this.oldResolution != newResolution);
        if (rebuild) {
            logger.log(Level.INFO, "Rebuild debugSpatial for {0}.", this.body);
            this.setShape(newShape);
            this.oldNormals = newNormals;
            this.oldResolution = newResolution;
            Node node = (Node)this.spatial;
            node.detachChild(this.debugSpatial);
            this.debugSpatial = DebugShapeFactory.getDebugShape(this.body);
            this.debugSpatial.setName(this.body.toString());
            node.attachChild(this.debugSpatial);
        }
        this.updateMaterial();
        if (this.body.isDynamic()) {
            RigidBodyMotionState motionState = this.body.getMotionState();
            motionState.getLocation(this.location);
            motionState.getOrientation(this.rotation);
        } else {
            this.body.getPhysicsLocation(this.location);
            this.body.getPhysicsRotation(this.rotation);
        }
        this.applyPhysicsTransform(this.location, this.rotation);
    }

    private void updateMaterial() {
        Material material = this.body.getDebugMaterial();
        if (material == BulletDebugAppState.enableChildColoring) {
            if (this.debugSpatial instanceof Node) {
                this.colorChildren();
                return;
            }
            material = null;
        }
        if (material == null) {
            int numSides = this.body.debugNumSides();
            material = !this.body.isContactResponse() ? this.debugAppState.getGhostMaterial(numSides) : (this.body.isDynamic() && this.body.isActive() ? this.debugAppState.getActiveMaterial(numSides) : this.debugAppState.getInactiveMaterial(numSides));
        }
        assert (material != null);
        this.debugSpatial.setMaterial(material);
    }
}

