/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;

class ChildSummary {
    static final Logger logger = Logger.getLogger(ChildSummary.class.getName());
    private boolean isValid = false;
    private float margin;
    private long shapeId;
    private final Quaternion rotation = new Quaternion();
    private final Vector3f offset = new Vector3f();
    private final Vector3f scale = new Vector3f();

    ChildSummary() {
    }

    boolean isValid() {
        return this.isValid;
    }

    void update(ChildCollisionShape child) {
        if (child == null) {
            this.isValid = false;
        } else {
            CollisionShape baseShape = child.getShape();
            this.margin = baseShape.getMargin();
            this.shapeId = baseShape.nativeId();
            child.copyRotation(this.rotation);
            child.copyOffset(this.offset);
            baseShape.getScale(this.scale);
            this.isValid = true;
        }
    }

    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            ChildSummary other = (ChildSummary)otherObject;
            result = this.isValid || other.isValid ? this.isValid && other.isValid && this.shapeId == other.shapeId && Float.compare(this.margin, other.margin) == 0 && this.rotation.equals((Object)other.rotation) && this.offset.equals((Object)other.offset) && this.scale.equals((Object)other.scale) : true;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int hash = 5;
        if (this.isValid) {
            hash = 97 * hash + (int)(this.shapeId >> 4);
            hash = 97 * hash + Float.floatToIntBits(this.margin);
            hash = 97 * hash + this.rotation.hashCode();
            hash = 97 * hash + this.offset.hashCode();
            hash = 97 * hash + this.scale.hashCode();
        }
        return hash;
    }
}

