/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.debug.ChildSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

class ChildSummaryList {
    static final Logger logger = Logger.getLogger(ChildSummaryList.class.getName());
    private final List<ChildSummary> list = new ArrayList<ChildSummary>(8);

    ChildSummaryList() {
    }

    int countValid() {
        ChildSummary summary;
        int result;
        for (result = 0; result < this.list.size() && (summary = this.list.get(result)).isValid(); ++result) {
        }
        return result;
    }

    void update(CompoundCollisionShape compound) {
        ChildCollisionShape[] children = compound.listChildren();
        int numChildren = children.length;
        while (numChildren > this.list.size()) {
            this.list.add(new ChildSummary());
        }
        for (int childIndex = 0; childIndex < this.list.size(); ++childIndex) {
            ChildSummary summary = this.list.get(childIndex);
            if (childIndex < numChildren) {
                ChildCollisionShape child = children[childIndex];
                summary.update(child);
                continue;
            }
            summary.update(null);
        }
    }

    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            ChildSummaryList other;
            int numValid = this.countValid();
            if (numValid != (other = (ChildSummaryList)otherObject).countValid()) {
                result = false;
            } else {
                result = true;
                for (int childIndex = 0; childIndex < numValid; ++childIndex) {
                    ChildSummary otherSummary;
                    ChildSummary summary = this.list.get(childIndex);
                    if (summary.equals(otherSummary = other.list.get(childIndex))) continue;
                    result = false;
                    break;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int hash = 13;
        int numValid = this.countValid();
        for (int childIndex = 0; childIndex < numValid; ++childIndex) {
            ChildSummary summary = this.list.get(childIndex);
            hash = 47 * hash + summary.hashCode();
        }
        return hash;
    }
}

