/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.CollisionShapeDebugControl;
import com.jme3.bullet.objects.MultiBodyCollider;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;

class ColliderDebugControl
extends CollisionShapeDebugControl {
    public static final Logger logger = Logger.getLogger(ColliderDebugControl.class.getName());
    private int oldResolution;
    private MeshNormals oldNormals;
    private final MultiBodyCollider collider;
    private final Quaternion rotation = new Quaternion();
    private final Vector3f location = new Vector3f();

    ColliderDebugControl(BulletDebugAppState debugAppState, MultiBodyCollider mbc) {
        super(debugAppState);
        this.collider = mbc;
        super.setShape(this.collider.getCollisionShape());
        this.oldNormals = this.collider.debugMeshNormals();
        this.oldResolution = this.collider.debugMeshResolution();
        this.debugSpatial = DebugShapeFactory.getDebugShape(this.collider);
        this.debugSpatial.setName(mbc.toString());
        this.updateMaterial();
    }

    protected void controlUpdate(float tpf) {
        CollisionShape newShape = this.collider.getCollisionShape();
        MeshNormals newNormals = this.collider.debugMeshNormals();
        int newResolution = this.collider.debugMeshResolution();
        boolean rebuild = this.hasShapeChanged(newShape) ? true : (this.oldNormals != newNormals ? true : this.oldResolution != newResolution);
        if (rebuild) {
            logger.log(Level.INFO, "Rebuild debugSpatial for {0}.", this.collider);
            this.setShape(newShape);
            this.oldNormals = newNormals;
            this.oldResolution = newResolution;
            Node node = (Node)this.spatial;
            node.detachChild(this.debugSpatial);
            this.debugSpatial = DebugShapeFactory.getDebugShape(this.collider);
            this.debugSpatial.setName(this.collider.toString());
            node.attachChild(this.debugSpatial);
        }
        this.updateMaterial();
        this.collider.getPhysicsLocation(this.location);
        this.collider.getPhysicsRotation(this.rotation);
        this.applyPhysicsTransform(this.location, this.rotation);
    }

    private void updateMaterial() {
        Material material = this.collider.getDebugMaterial();
        if (material == BulletDebugAppState.enableChildColoring) {
            if (this.debugSpatial instanceof Node) {
                this.colorChildren();
                return;
            }
            material = null;
        }
        if (material == null) {
            int numSides = this.collider.debugNumSides();
            material = !this.collider.isContactResponse() ? this.debugAppState.getGhostMaterial(numSides) : (this.collider.isActive() ? this.debugAppState.getActiveMaterial(numSides) : this.debugAppState.getInactiveMaterial(numSides));
        }
        assert (material != null);
        this.debugSpatial.setMaterial(material);
    }
}

