/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.util.logging.Logger;

class ConstraintDebugControl
extends AbstractPhysicsDebugControl {
    public static final Logger logger = Logger.getLogger(ConstraintDebugControl.class.getName());
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private final Constraint constraint;
    private final Geometry geomA;
    private final Geometry geomB;
    private static final Transform tmpTransform = new Transform();

    ConstraintDebugControl(BulletDebugAppState debugAppState, Constraint constraint) {
        super(debugAppState);
        this.constraint = constraint;
        this.geomA = new Geometry(constraint.toString());
        Arrow arrowA = new Arrow(translateIdentity);
        this.geomA.setMesh((Mesh)arrowA);
        Material materialA = debugAppState.getJointMaterial(JointEnd.A);
        this.geomA.setMaterial(materialA);
        this.geomA.setShadowMode(RenderQueue.ShadowMode.Off);
        this.geomB = new Geometry(constraint.toString());
        Arrow arrowB = new Arrow(translateIdentity);
        this.geomB.setMesh((Mesh)arrowB);
        Material materialB = debugAppState.getJointMaterial(JointEnd.B);
        this.geomB.setMaterial(materialB);
        this.geomB.setShadowMode(RenderQueue.ShadowMode.Off);
    }

    protected void controlUpdate(float tpf) {
        if (this.constraint.isEnabled()) {
            Vector3f vector = tmpTransform.getTranslation();
            Quaternion rotation = tmpTransform.getRotation();
            PhysicsRigidBody bodyA = this.constraint.getBodyA();
            if (bodyA == null) {
                this.geomA.setCullHint(Spatial.CullHint.Always);
            } else {
                bodyA.getPhysicsLocation(vector);
                bodyA.getPhysicsRotation(rotation);
                this.geomA.setLocalTransform(tmpTransform);
                this.geomA.setCullHint(Spatial.CullHint.Never);
                Arrow arrow = (Arrow)this.geomA.getMesh();
                this.constraint.getPivotA(vector);
                arrow.setArrowExtent(vector);
            }
            PhysicsRigidBody bodyB = this.constraint.getBodyB();
            if (bodyB == null) {
                this.geomB.setCullHint(Spatial.CullHint.Always);
            } else {
                bodyB.getPhysicsLocation(vector);
                bodyB.getPhysicsRotation(rotation);
                this.geomB.setLocalTransform(tmpTransform);
                this.geomB.setCullHint(Spatial.CullHint.Never);
                Arrow arrow = (Arrow)this.geomB.getMesh();
                this.constraint.getPivotB(vector);
                arrow.setArrowExtent(vector);
            }
        } else {
            this.geomA.setCullHint(Spatial.CullHint.Always);
            this.geomB.setCullHint(Spatial.CullHint.Always);
        }
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            assert (this.spatial == null);
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.geomA);
            node.attachChild((Spatial)this.geomB);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.geomA);
            node.detachChild((Spatial)this.geomB);
        }
        super.setSpatial(spatial);
    }
}

