/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.MultiBody;
import com.jme3.bullet.MultiBodySpace;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.ColliderDebugControl;
import com.jme3.bullet.debug.DebugConfiguration;
import com.jme3.bullet.objects.MultiBodyCollider;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiBodyDebugAppState
extends BulletDebugAppState {
    public static final Logger logger2 = Logger.getLogger(MultiBodyDebugAppState.class.getName());
    private HashMap<MultiBodyCollider, Node> colliderMap = new HashMap(64);

    public MultiBodyDebugAppState(DebugConfiguration config) {
        super(config);
    }

    @Override
    protected void updateShapes() {
        super.updateShapes();
        this.updateMultiBodies();
    }

    private void updateMultiBodies() {
        Node node;
        HashMap<MultiBodyCollider, Node> oldMap = this.colliderMap;
        this.colliderMap = new HashMap(oldMap.size());
        DebugConfiguration config = this.getConfiguration();
        MultiBodySpace pSpace = (MultiBodySpace)config.getSpace();
        Collection<MultiBody> list = pSpace.getMultiBodyList();
        for (MultiBody multiBody : list) {
            List<MultiBodyCollider> list2 = multiBody.listColliders();
            for (MultiBodyCollider collider : list2) {
                node = oldMap.remove(collider);
                if (node == null) {
                    node = new Node(collider.toString());
                    this.attachChild((Spatial)node);
                }
                this.colliderMap.put(collider, node);
            }
        }
        for (Node node2 : oldMap.values()) {
            node2.removeFromParent();
        }
        BulletDebugAppState.DebugAppStateFilter filter = this.getConfiguration().getFilter();
        for (Map.Entry<MultiBodyCollider, Node> entry : this.colliderMap.entrySet()) {
            MultiBodyCollider collider = entry.getKey();
            boolean displayShape = filter == null || filter.displayObject(collider);
            node = entry.getValue();
            Object control = node.getControl(ColliderDebugControl.class);
            if (control == null && displayShape) {
                logger.log(Level.FINE, "Create new MultiBodyDebugControl");
                control = new ColliderDebugControl(this, collider);
                node.addControl(control);
            } else if (control != null && !displayShape) {
                node.removeControl(control);
            }
            this.updateAxes(node, displayShape);
        }
    }
}

