/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.DebugMeshInitListener;
import com.jme3.bullet.debug.SoftDebugAppState;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.bullet.util.NativeSoftBodyUtil;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.Arrow;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;
import jme3utilities.math.MyBuffer;

class SoftBodyDebugControl
extends AbstractPhysicsDebugControl {
    public static final Logger logger = Logger.getLogger(SoftBodyDebugControl.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private static FloatBuffer tmpLocations = null;
    private static FloatBuffer tmpVelocities = null;
    private Geometry clustersGeometry = null;
    private Geometry facesGeometry = null;
    private Geometry linksGeometry = null;
    private Geometry pinsGeometry = null;
    private Geometry[] velocityGeometries = null;
    private final PhysicsSoftBody body;
    private static final Vector3f tmpCenter = new Vector3f();
    private static final Vector3f tmpVector = new Vector3f();

    SoftBodyDebugControl(BulletDebugAppState debugAppState, PhysicsSoftBody body) {
        super(debugAppState);
        this.body = body;
    }

    protected void controlUpdate(float tpf) {
        Mesh mesh;
        Node node = (Node)this.spatial;
        if (!this.isClustersGeometrySized()) {
            if (this.clustersGeometry != null) {
                node.detachChild((Spatial)this.clustersGeometry);
            }
            this.clustersGeometry = this.createClustersGeometry();
            assert (this.isClustersGeometrySized());
            if (this.clustersGeometry != null) {
                node.attachChild((Spatial)this.clustersGeometry);
            }
        }
        if (!this.isFacesGeometrySized()) {
            if (this.facesGeometry != null) {
                node.detachChild((Spatial)this.facesGeometry);
            }
            this.facesGeometry = this.createFacesGeometry();
            assert (this.isFacesGeometrySized());
            if (this.facesGeometry != null) {
                node.attachChild((Spatial)this.facesGeometry);
            }
        }
        if (!this.isLinksGeometrySized()) {
            if (this.linksGeometry != null) {
                node.detachChild((Spatial)this.linksGeometry);
            }
            this.linksGeometry = this.createLinksGeometry();
            assert (this.isLinksGeometrySized());
            if (this.linksGeometry != null) {
                node.attachChild((Spatial)this.linksGeometry);
            }
        }
        if (!this.isPinsGeometrySized()) {
            if (this.pinsGeometry != null) {
                node.detachChild((Spatial)this.pinsGeometry);
            }
            this.pinsGeometry = this.createPinsGeometry();
            assert (this.isPinsGeometrySized());
            if (this.pinsGeometry != null) {
                node.attachChild((Spatial)this.pinsGeometry);
            }
        }
        if (!this.areVelocitiesSized()) {
            if (this.velocityGeometries != null) {
                for (Geometry geometry : this.velocityGeometries) {
                    node.detachChild((Spatial)geometry);
                }
            }
            this.velocityGeometries = this.createVelocityGeometries();
            assert (this.areVelocitiesSized());
            if (this.velocityGeometries != null) {
                for (Geometry geometry : this.velocityGeometries) {
                    node.attachChild((Spatial)geometry);
                }
            }
        }
        boolean localFlag = true;
        if (this.clustersGeometry != null) {
            Mesh mesh2 = this.clustersGeometry.getMesh();
            NativeSoftBodyUtil.updateClusterMesh(this.body, mesh2, localFlag);
        }
        MeshNormals normals = this.body.debugMeshNormals();
        IntBuffer noIndexMap = null;
        boolean normalsFlag = normals != MeshNormals.None;
        Transform noTransform = null;
        if (this.linksGeometry != null) {
            mesh = this.linksGeometry.getMesh();
            NativeSoftBodyUtil.updateMesh(this.body, noIndexMap, mesh, localFlag, normalsFlag, noTransform);
        }
        if (this.facesGeometry != null) {
            mesh = this.facesGeometry.getMesh();
            NativeSoftBodyUtil.updateMesh(this.body, noIndexMap, mesh, localFlag, normalsFlag, noTransform);
            Material material = this.body.getDebugMaterial();
            if (material == null) {
                int numSides = this.body.debugNumSides();
                SoftDebugAppState sda = (SoftDebugAppState)this.debugAppState;
                material = sda.getFaceMaterial(numSides);
            }
            this.facesGeometry.setMaterial(material);
        }
        if (this.pinsGeometry != null) {
            mesh = this.pinsGeometry.getMesh();
            NativeSoftBodyUtil.updatePinMesh(this.body, mesh, localFlag);
        }
        this.body.getPhysicsLocation(tmpCenter);
        if (this.velocityGeometries != null) {
            int numArrows = this.velocityGeometries.length;
            int numFloats = 3 * numArrows;
            if (tmpLocations == null || numFloats > tmpLocations.capacity()) {
                tmpLocations = BufferUtils.createFloatBuffer((int)numFloats);
            }
            if (tmpVelocities == null || numFloats > tmpVelocities.capacity()) {
                tmpVelocities = BufferUtils.createFloatBuffer((int)numFloats);
            }
            if (this.countClustersToVisualize() > 0) {
                this.body.copyClusterCenters(tmpLocations);
                this.body.copyClusterVelocities(tmpVelocities);
            } else {
                this.body.copyLocations(tmpLocations);
                this.body.copyVelocities(tmpVelocities);
            }
            for (int arrowIndex = 0; arrowIndex < numArrows; ++arrowIndex) {
                int startPosition = 3 * arrowIndex;
                Geometry geometry = this.velocityGeometries[arrowIndex];
                MyBuffer.get((FloatBuffer)tmpLocations, (int)startPosition, (Vector3f)tmpVector);
                tmpVector.subtractLocal(tmpCenter);
                geometry.setLocalTranslation(tmpVector);
                Mesh mesh3 = geometry.getMesh();
                Arrow arrow = (Arrow)mesh3;
                MyBuffer.get((FloatBuffer)tmpVelocities, (int)startPosition, (Vector3f)tmpVector);
                arrow.setArrowExtent(tmpVector);
            }
        }
        this.applyPhysicsTransform(tmpCenter, rotateIdentity);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            assert (this.spatial == null);
            spatial.setCullHint(Spatial.CullHint.Never);
            Node node = (Node)spatial;
            if (this.clustersGeometry != null) {
                node.attachChild((Spatial)this.clustersGeometry);
            }
            if (this.facesGeometry != null) {
                node.attachChild((Spatial)this.facesGeometry);
            }
            if (this.linksGeometry != null) {
                node.attachChild((Spatial)this.linksGeometry);
            }
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            if (this.clustersGeometry != null) {
                node.detachChild((Spatial)this.clustersGeometry);
            }
            if (this.facesGeometry != null) {
                node.detachChild((Spatial)this.facesGeometry);
            }
            if (this.linksGeometry != null) {
                node.detachChild((Spatial)this.linksGeometry);
            }
        }
        super.setSpatial(spatial);
    }

    private boolean areVelocitiesSized() {
        int correctNumArrows;
        int numArrows = 0;
        if (this.velocityGeometries != null) {
            numArrows = this.velocityGeometries.length;
        }
        boolean result = numArrows == (correctNumArrows = this.countVelocitiesToVisualize());
        return result;
    }

    private int countClustersToVisualize() {
        SoftDebugAppState sda = (SoftDebugAppState)this.debugAppState;
        BulletDebugAppState.DebugAppStateFilter filter = sda.getClusterFilter();
        int result = 0;
        if (filter != null && filter.displayObject(this.body)) {
            result = this.body.countClusters();
        }
        return result;
    }

    private static int countElements(Geometry geometry) {
        int result = 0;
        if (geometry != null) {
            result = geometry.getMesh().getTriangleCount();
        }
        return result;
    }

    private int countVelocitiesToVisualize() {
        SoftDebugAppState sda = (SoftDebugAppState)this.debugAppState;
        BulletDebugAppState.DebugAppStateFilter filter = sda.getConfiguration().getVelocityVectorFilter();
        int result = 0;
        if (filter != null && filter.displayObject(this.body) && (result = this.countClustersToVisualize()) == 0) {
            result = this.body.countNodes();
        }
        return result;
    }

    private static int countVertices(Geometry geometry) {
        int result = 0;
        if (geometry != null) {
            result = geometry.getMesh().getVertexCount();
        }
        return result;
    }

    private Geometry createClustersGeometry() {
        Geometry result = null;
        int numClustersToVisualize = this.countClustersToVisualize();
        if (numClustersToVisualize > 0) {
            Mesh mesh = SoftBodyDebugControl.createPointsMesh(numClustersToVisualize);
            result = new Geometry(this.body + " clusters", mesh);
            result.setShadowMode(RenderQueue.ShadowMode.Off);
            SoftDebugAppState sda = (SoftDebugAppState)this.debugAppState;
            Material material = sda.getClusterMaterial();
            result.setMaterial(material);
        }
        return result;
    }

    private Geometry createFacesGeometry() {
        Geometry result = null;
        if (this.body.countFaces() > 0) {
            Mesh mesh = this.createFacesMesh();
            result = new Geometry(this.body + " faces", mesh);
            Material material = this.body.getDebugMaterial();
            if (material == null) {
                SoftDebugAppState sda = (SoftDebugAppState)this.debugAppState;
                int numSides = this.body.debugNumSides();
                material = sda.getFaceMaterial(numSides);
            }
            result.setMaterial(material);
        }
        return result;
    }

    private Mesh createFacesMesh() {
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Index, 3, this.body.copyFaces(null));
        DebugMeshInitListener listener = this.body.debugMeshInitListener();
        MeshNormals option = this.body.debugMeshNormals();
        if (listener == null) {
            int numNodes = this.body.countNodes();
            int numFloats = 3 * numNodes;
            FloatBuffer pos = BufferUtils.createFloatBuffer((int)numFloats);
            mesh.setBuffer(VertexBuffer.Type.Position, 3, pos);
            if (option != MeshNormals.None) {
                FloatBuffer norm = BufferUtils.createFloatBuffer((int)numFloats);
                mesh.setBuffer(VertexBuffer.Type.Normal, 3, norm);
            }
        } else {
            FloatBuffer pos = this.body.copyLocations(null);
            mesh.setBuffer(VertexBuffer.Type.Position, 3, pos);
            if (option != MeshNormals.None) {
                FloatBuffer norm = this.body.copyNormals(null);
                mesh.setBuffer(VertexBuffer.Type.Normal, 3, norm);
            }
            mesh.updateBound();
            listener.debugMeshInit(mesh);
        }
        mesh.setMode(Mesh.Mode.Triangles);
        mesh.setStreamed();
        return mesh;
    }

    private Geometry createLinksGeometry() {
        Geometry result = null;
        if (this.body.countFaces() == 0 && this.body.countLinks() > 0) {
            Mesh mesh = this.createLinksMesh();
            result = new Geometry(this.body + " links", mesh);
            SoftDebugAppState sda = (SoftDebugAppState)this.debugAppState;
            Material material = sda.getLinkMaterial();
            result.setMaterial(material);
        }
        return result;
    }

    private Mesh createLinksMesh() {
        Mesh result = new Mesh();
        result.setBuffer(VertexBuffer.Type.Index, 2, this.body.copyLinks(null));
        int numFloats = 3 * this.body.countNodes();
        FloatBuffer locations = BufferUtils.createFloatBuffer((int)numFloats);
        result.setBuffer(VertexBuffer.Type.Position, 3, locations);
        result.setMode(Mesh.Mode.Lines);
        result.setStreamed();
        return result;
    }

    private Geometry createPinsGeometry() {
        Geometry result = null;
        int numNodesToVisualize = this.body.countPinnedNodes();
        if (numNodesToVisualize > 0) {
            Mesh mesh = SoftBodyDebugControl.createPointsMesh(numNodesToVisualize);
            result = new Geometry(this.body + " pins", mesh);
            result.setShadowMode(RenderQueue.ShadowMode.Off);
            SoftDebugAppState sda = (SoftDebugAppState)this.debugAppState;
            Material material = sda.getPinMaterial();
            result.setMaterial(material);
        }
        return result;
    }

    private static Mesh createPointsMesh(int numPoints) {
        assert (numPoints > 0) : numPoints;
        Mesh result = new Mesh();
        int numFloats = 3 * numPoints;
        FloatBuffer centers = BufferUtils.createFloatBuffer((int)numFloats);
        result.setBuffer(VertexBuffer.Type.Position, 3, centers);
        result.setMode(Mesh.Mode.Points);
        result.setStreamed();
        return result;
    }

    private Geometry[] createVelocityGeometries() {
        Geometry[] result = null;
        int numGeometries = this.countVelocitiesToVisualize();
        if (numGeometries > 0) {
            result = new Geometry[numGeometries];
            for (int geomI = 0; geomI < numGeometries; ++geomI) {
                Geometry geometry;
                Arrow mesh = new Arrow(tmpVector);
                String name = String.format("velocity of %s[%d]", this.body, geomI);
                result[geomI] = geometry = new Geometry(name, (Mesh)mesh);
                Material material = this.debugAppState.getVelocityVectorMaterial();
                geometry.setMaterial(material);
                geometry.setShadowMode(RenderQueue.ShadowMode.Off);
            }
        }
        return result;
    }

    private boolean isClustersGeometrySized() {
        int correctNumVertices = this.countClustersToVisualize();
        boolean result = SoftBodyDebugControl.countVertices(this.clustersGeometry) == correctNumVertices;
        return result;
    }

    private boolean isFacesGeometrySized() {
        int correctNumTriangles = this.body.countFaces();
        int correctNumVertices = correctNumTriangles == 0 ? 0 : this.body.countNodes();
        boolean result = SoftBodyDebugControl.countElements(this.facesGeometry) == correctNumTriangles && SoftBodyDebugControl.countVertices(this.facesGeometry) == correctNumVertices;
        return result;
    }

    private boolean isLinksGeometrySized() {
        int correctNumLines = 0;
        int correctNumVertices = 0;
        if (this.body.countFaces() == 0 && this.body.countLinks() > 0) {
            correctNumLines = this.body.countLinks();
            correctNumVertices = this.body.countNodes();
        }
        boolean result = SoftBodyDebugControl.countElements(this.linksGeometry) == correctNumLines && SoftBodyDebugControl.countVertices(this.linksGeometry) == correctNumVertices;
        return result;
    }

    private boolean isPinsGeometrySized() {
        int correctNumVertices = this.body.countPinnedNodes();
        boolean result = SoftBodyDebugControl.countVertices(this.pinsGeometry) == correctNumVertices;
        return result;
    }
}

