/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSoftSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.DebugConfiguration;
import com.jme3.bullet.debug.SoftBodyDebugControl;
import com.jme3.bullet.debug.WindVelocityDebugControl;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyAsset;

public class SoftDebugAppState
extends BulletDebugAppState {
    private static final ColorRGBA whiteColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Logger logger2 = Logger.getLogger(SoftDebugAppState.class.getName());
    private BulletDebugAppState.DebugAppStateFilter clusterFilter;
    private BulletDebugAppState.DebugAppStateFilter windVelocityFilter;
    private HashMap<PhysicsSoftBody, Node> softBodies = new HashMap(64);
    private Material anchorMaterial;
    private Material clusterMaterial;
    private Material linkMaterial;
    private Material pinMaterial;
    private Material windVelocityMaterial;
    private final Material[] faceMaterials = new Material[3];

    public SoftDebugAppState(DebugConfiguration config) {
        super(config);
    }

    Material getAnchorMaterial() {
        assert (this.anchorMaterial != null);
        return this.anchorMaterial;
    }

    BulletDebugAppState.DebugAppStateFilter getClusterFilter() {
        return this.clusterFilter;
    }

    Material getClusterMaterial() {
        assert (this.clusterMaterial != null);
        return this.clusterMaterial;
    }

    Material getFaceMaterial(int numSides) {
        Material result = this.faceMaterials[numSides];
        assert (result != null);
        return result;
    }

    Material getLinkMaterial() {
        assert (this.linkMaterial != null);
        return this.linkMaterial;
    }

    Material getPinMaterial() {
        assert (this.pinMaterial != null);
        return this.pinMaterial;
    }

    Material getWindVelocityMaterial() {
        assert (this.windVelocityMaterial != null);
        return this.windVelocityMaterial;
    }

    public void setClusterFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.clusterFilter = filter;
    }

    public void setWindVelocityFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.windVelocityFilter = filter;
    }

    @Override
    protected void setupMaterials(AssetManager am) {
        assert (am != null);
        super.setupMaterials(am);
        this.anchorMaterial = this.createWireMaterial(am, ColorRGBA.Green, "anchorMaterial", 1);
        String matDefPath = "MatDefs/wireframe/multicolor2.j3md";
        this.clusterMaterial = new Material(am, matDefPath);
        ColorRGBA clusterColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
        this.clusterMaterial.setColor("Color", clusterColor);
        float shapeSize = 10.0f;
        this.clusterMaterial.setFloat("PointSize", shapeSize);
        this.clusterMaterial.setName("clusterMaterial");
        String shapePath = "Textures/shapes/lozenge.png";
        boolean mipmaps = false;
        Texture shapeTexture = MyAsset.loadTexture((AssetManager)am, (String)shapePath, (boolean)mipmaps);
        this.clusterMaterial.setTexture("PointShape", shapeTexture);
        RenderState renderState = this.clusterMaterial.getAdditionalRenderState();
        renderState.setBlendMode(RenderState.BlendMode.Alpha);
        renderState.setDepthTest(false);
        this.faceMaterials[0] = MyAsset.createInvisibleMaterial((AssetManager)am);
        this.faceMaterials[1] = this.createWireMaterial(am, ColorRGBA.Red, "debug red ss", 1);
        this.faceMaterials[2] = this.createWireMaterial(am, ColorRGBA.Red, "debug red ds", 2);
        this.linkMaterial = this.createWireMaterial(am, ColorRGBA.Orange, "linkMaterial", 1);
        this.pinMaterial = new Material(am, matDefPath);
        ColorRGBA pinColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
        this.pinMaterial.setColor("Color", pinColor);
        shapeSize = 24.0f;
        this.pinMaterial.setFloat("PointSize", shapeSize);
        this.pinMaterial.setName("pinMaterial");
        shapePath = "Textures/shapes/pin.png";
        mipmaps = false;
        shapeTexture = MyAsset.loadTexture((AssetManager)am, (String)shapePath, (boolean)mipmaps);
        this.pinMaterial.setTexture("PointShape", shapeTexture);
        renderState = this.pinMaterial.getAdditionalRenderState();
        renderState.setBlendMode(RenderState.BlendMode.Alpha);
        renderState.setDepthTest(false);
        this.windVelocityMaterial = this.createWireMaterial(am, whiteColor, "wind velocity", 2);
    }

    @Override
    protected void updateVelocities() {
        super.updateVelocities();
        this.updateWindVelocities();
    }

    @Override
    protected void updateShapes() {
        super.updateShapes();
        this.updateSoftBodies();
    }

    private void updateSoftBodies() {
        HashMap<PhysicsSoftBody, Node> oldMap = this.softBodies;
        this.softBodies = new HashMap(oldMap.size());
        DebugConfiguration config = this.getConfiguration();
        PhysicsSoftSpace pSpace = (PhysicsSoftSpace)config.getSpace();
        Collection<PhysicsSoftBody> list = pSpace.getSoftBodyList();
        for (PhysicsSoftBody softBody : list) {
            Node node = oldMap.remove(softBody);
            if (node == null) {
                node = new Node(softBody.toString());
                this.attachChild((Spatial)node);
            }
            this.softBodies.put(softBody, node);
        }
        for (Node node : oldMap.values()) {
            node.removeFromParent();
        }
        BulletDebugAppState.DebugAppStateFilter filter = this.getConfiguration().getFilter();
        for (Map.Entry<PhysicsSoftBody, Node> entry : this.softBodies.entrySet()) {
            PhysicsSoftBody softBody = entry.getKey();
            boolean displayShape = filter == null || filter.displayObject(softBody);
            Node node = entry.getValue();
            Object control = node.getControl(SoftBodyDebugControl.class);
            if (control == null && displayShape) {
                logger.log(Level.FINE, "Create new SoftBodyDebugControl");
                control = new SoftBodyDebugControl(this, softBody);
                node.addControl(control);
            } else if (control != null && !displayShape) {
                node.removeControl(control);
            }
            this.updateAxes(node, displayShape);
        }
    }

    private void updateWindVelocities() {
        if (this.windVelocityFilter == null) {
            return;
        }
        HashMap<PhysicsCollisionObject, Node> pcoMap = this.getPcoMap();
        for (Map.Entry entry : pcoMap.entrySet()) {
            PhysicsCollisionObject pco = (PhysicsCollisionObject)entry.getKey();
            boolean display = pco instanceof PhysicsSoftBody && this.windVelocityFilter.displayObject(pco);
            Node transformedNode = (Node)entry.getValue();
            Node parent = transformedNode.getParent();
            Object control = parent.getControl(WindVelocityDebugControl.class);
            if (control == null && display) {
                logger.log(Level.FINE, "Create new WindVelocityDebugControl");
                control = new WindVelocityDebugControl(this, pco);
                parent.addControl(control);
                continue;
            }
            if (control == null || display) continue;
            parent.removeControl(control);
        }
    }
}

