/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.SoftDebugAppState;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.util.logging.Logger;

class WindVelocityDebugControl
extends AbstractPhysicsDebugControl {
    static final Logger logger = Logger.getLogger(WindVelocityDebugControl.class.getName());
    private final Geometry geom;
    private final PhysicsSoftBody softBody;
    private final Vector3f tmpCenter = new Vector3f();
    private static final Vector3f tmpExtent = new Vector3f();

    WindVelocityDebugControl(BulletDebugAppState debugAppState, PhysicsCollisionObject pco) {
        super(debugAppState);
        this.softBody = (PhysicsSoftBody)pco;
        this.softBody.windVelocity(tmpExtent);
        Arrow mesh = new Arrow(tmpExtent);
        this.geom = new Geometry("wind velocity of " + this.softBody, (Mesh)mesh);
        this.softBody.getPhysicsLocation(this.tmpCenter);
        this.geom.setLocalTranslation(this.tmpCenter);
        SoftDebugAppState sda = (SoftDebugAppState)debugAppState;
        Material material = sda.getWindVelocityMaterial();
        this.geom.setMaterial(material);
        this.geom.setShadowMode(RenderQueue.ShadowMode.Off);
    }

    protected void controlUpdate(float tpf) {
        this.softBody.getPhysicsLocation(this.tmpCenter);
        this.geom.setLocalTranslation(this.tmpCenter);
        Mesh mesh = this.geom.getMesh();
        Arrow arrow = (Arrow)mesh;
        this.softBody.windVelocity(tmpExtent);
        arrow.setArrowExtent(tmpExtent);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.geom);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.geom);
        }
        super.setSpatial(spatial);
    }
}

