/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;

public class ConeJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(ConeJoint.class.getName());
    private static final String tagAngularOnly = "angularOnly";
    private static final String tagRotA = "rotA";
    private static final String tagRotB = "rotB";
    private static final String tagSwingSpan1 = "swingSpan1";
    private static final String tagSwingSpan2 = "swingSpan2";
    private static final String tagTwistSpan = "twistSpan";
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private Matrix3f rotA;
    private Matrix3f rotB;
    private float swingSpan1 = 1.0E30f;
    private float swingSpan2 = 1.0E30f;
    private float twistSpan = 1.0E30f;
    private boolean angularOnly = false;

    protected ConeJoint() {
    }

    public ConeJoint(PhysicsRigidBody rigidBodyA, Vector3f pivotInA, Matrix3f rotInA) {
        super(rigidBodyA, JointEnd.A, pivotInA, translateIdentity);
        this.rotB = this.rotA = rotInA.clone();
        this.createJoint();
    }

    public ConeJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public ConeJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.rotA = rotInA.clone();
        this.rotB = rotInB.clone();
        this.createJoint();
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                ConeJoint.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                ConeJoint.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public float getSwingSpan1() {
        return this.swingSpan1;
    }

    public float getSwingSpan2() {
        return this.swingSpan2;
    }

    public float getTwistSpan() {
        return this.twistSpan;
    }

    public boolean isAngularOnly() {
        return this.angularOnly;
    }

    public void setAngularOnly(boolean value) {
        long constraintId = this.nativeId();
        this.angularOnly = value;
        ConeJoint.setAngularOnly(constraintId, value);
    }

    public void setLimit(float swingSpan1, float swingSpan2, float twistSpan) {
        long constraintId = this.nativeId();
        this.swingSpan1 = swingSpan1;
        this.swingSpan2 = swingSpan2;
        this.twistSpan = twistSpan;
        ConeJoint.setLimit(constraintId, swingSpan1, swingSpan2, twistSpan);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        ConeJoint old = (ConeJoint)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.rotA = (Matrix3f)cloner.clone((Object)this.rotA);
        this.rotB = (Matrix3f)cloner.clone((Object)this.rotB);
        this.createJoint();
        this.copyConstraintProperties(old);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.rotA = (Matrix3f)capsule.readSavable(tagRotA, (Savable)new Matrix3f());
        this.rotB = (Matrix3f)capsule.readSavable(tagRotB, (Savable)new Matrix3f());
        this.angularOnly = capsule.readBoolean(tagAngularOnly, false);
        this.swingSpan1 = capsule.readFloat(tagSwingSpan1, 1.0E30f);
        this.swingSpan2 = capsule.readFloat(tagSwingSpan2, 1.0E30f);
        this.twistSpan = capsule.readFloat(tagTwistSpan, 1.0E30f);
        this.createJoint();
        this.readConstraintProperties(capsule);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.rotA, tagRotA, null);
        capsule.write((Savable)this.rotB, tagRotB, null);
        capsule.write(this.angularOnly, tagAngularOnly, false);
        capsule.write(this.swingSpan1, tagSwingSpan1, 1.0E30f);
        capsule.write(this.swingSpan2, tagSwingSpan2, 1.0E30f);
        capsule.write(this.twistSpan, tagTwistSpan, 1.0E30f);
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        long aId = a.nativeId();
        assert (this.pivotA != null);
        assert (this.rotA != null);
        PhysicsRigidBody b = this.getBodyB();
        if (b == null) {
            constraintId = ConeJoint.createJoint1(aId, this.pivotA, this.rotA);
        } else {
            assert (this.pivotB != null);
            assert (this.rotB != null);
            long bId = b.nativeId();
            constraintId = ConeJoint.createJoint(aId, bId, this.pivotA, this.rotA, this.pivotB, this.rotB);
        }
        assert (ConeJoint.getConstraintType(constraintId) == 5);
        this.setNativeId(constraintId);
        this.setLimit(this.swingSpan1, this.swingSpan2, this.twistSpan);
        this.setAngularOnly(this.angularOnly);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Matrix3f var5, Vector3f var6, Matrix3f var7);

    private static native long createJoint1(long var0, Vector3f var2, Matrix3f var3);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native void setAngularOnly(long var0, boolean var2);

    private static native void setLimit(long var0, float var2, float var3, float var4);
}

