/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public abstract class Constraint
extends PhysicsJoint {
    public static final Logger logger15 = Logger.getLogger(Constraint.class.getName());
    private static final String tagBreakingImpulse = "breakingImpulseThreshold";
    private static final String tagIsCollision = "isCollisionBetweenLinkedBodies";
    private static final String tagIsEnabled = "isEnabled";
    private static final String tagIsFeedback = "isFeedback";
    private static final String tagNumIterations = "numIterations";
    private static final String tagPivotA = "pivotA";
    private static final String tagPivotB = "pivotB";
    protected Vector3f pivotA;
    protected Vector3f pivotB;

    protected Constraint() {
    }

    protected Constraint(PhysicsRigidBody body, JointEnd bodyEnd, Vector3f pivotInBody) {
        Validate.nonNull((Object)body, (String)"body");
        Validate.nonNull((Object)((Object)bodyEnd), (String)"body end");
        Validate.nonNull((Object)pivotInBody, (String)"pivot in body");
        switch (bodyEnd) {
            case A: {
                this.setBodyA(body);
                this.pivotA = pivotInBody.clone();
                this.pivotB = null;
                break;
            }
            case B: {
                this.setBodyB(body);
                this.pivotA = null;
                this.pivotB = pivotInBody.clone();
                break;
            }
            default: {
                String message = "body end = " + (Object)((Object)bodyEnd);
                throw new IllegalArgumentException(message);
            }
        }
        body.addJoint(this);
    }

    protected Constraint(PhysicsRigidBody body, JointEnd bodyEnd, Vector3f pivotInBody, Vector3f pivotInWorld) {
        Validate.nonNull((Object)body, (String)"body");
        Validate.nonNull((Object)((Object)bodyEnd), (String)"body end");
        Validate.finite((Vector3f)pivotInBody, (String)"pivot in body");
        Validate.finite((Vector3f)pivotInWorld, (String)"pivot in world");
        switch (bodyEnd) {
            case A: {
                this.setBodyA(body);
                this.pivotA = pivotInBody.clone();
                this.pivotB = pivotInWorld.clone();
                break;
            }
            case B: {
                this.setBodyB(body);
                this.pivotA = pivotInWorld.clone();
                this.pivotB = pivotInBody.clone();
                break;
            }
            default: {
                String message = "body end = " + (Object)((Object)bodyEnd);
                throw new IllegalArgumentException(message);
            }
        }
        body.addJoint(this);
    }

    protected Constraint(PhysicsBody bodyA, PhysicsBody bodyB, Vector3f pivotInA, Vector3f pivotInB) {
        Validate.nonNull((Object)bodyA, (String)"body A");
        Validate.nonNull((Object)bodyB, (String)"body B");
        if (bodyA == bodyB) {
            throw new IllegalArgumentException("The jointed bodies must be distinct.");
        }
        this.setBodyA(bodyA);
        this.setBodyB(bodyB);
        this.pivotA = pivotInA.clone();
        this.pivotB = pivotInB.clone();
        bodyA.addJoint(this);
        bodyB.addJoint(this);
    }

    public float getAppliedImpulse() {
        if (!this.isFeedback()) {
            throw new IllegalStateException("Feedback is not enabled.");
        }
        long constraintId = this.nativeId();
        float result = Constraint.getAppliedImpulse(constraintId);
        assert (result >= 0.0f) : result;
        return result;
    }

    public float getBreakingImpulseThreshold() {
        long constraintId = this.nativeId();
        float result = Constraint.getBreakingImpulseThreshold(constraintId);
        return result;
    }

    public int getOverrideIterations() {
        long constraintId = this.nativeId();
        int result = Constraint.getOverrideIterations(constraintId);
        return result;
    }

    public Vector3f getPivot(JointEnd end, Vector3f storeResult) {
        Vector3f result;
        Validate.nonNull((Object)((Object)end), (String)"end");
        switch (end) {
            case A: {
                result = this.getPivotA(storeResult);
                break;
            }
            case B: {
                result = this.getPivotB(storeResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("end = " + (Object)((Object)end));
            }
        }
        return result;
    }

    public Vector3f getPivotA(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (this.getBodyA() == null) {
            throw new IllegalArgumentException("No body at the A end.");
        }
        result.set(this.pivotA);
        return result;
    }

    public Vector3f getPivotB(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (this.getBodyB() == null) {
            throw new IllegalArgumentException("No body at the B end.");
        }
        result.set(this.pivotB);
        return result;
    }

    public boolean isCollisionBetweenLinkedBodies() {
        boolean result = true;
        if (this.countEnds() == 2) {
            PhysicsRigidBody b;
            PhysicsRigidBody a = this.getBodyA();
            result = !a.ignores(b = this.getBodyB());
        }
        return result;
    }

    public boolean isFeedback() {
        long constraintId = this.nativeId();
        boolean result = Constraint.needsFeedback(constraintId);
        return result;
    }

    public void overrideIterations(int numIterations) {
        Validate.inRange((int)numIterations, (String)"number of iterations", (int)-1, (int)Integer.MAX_VALUE);
        long constraintId = this.nativeId();
        Constraint.overrideIterations(constraintId, numIterations);
    }

    public void setBreakingImpulseThreshold(float desiredThreshold) {
        long constraintId = this.nativeId();
        Constraint.setBreakingImpulseThreshold(constraintId, desiredThreshold);
    }

    public void setCollisionBetweenLinkedBodies(boolean allow) {
        if (this.countEnds() < 2) {
            String msg = "Can't configure collisions between linked bodies for a single-ended constraint!";
            throw new IllegalArgumentException(msg);
        }
        PhysicsRigidBody a = this.getBodyA();
        PhysicsRigidBody b = this.getBodyB();
        if (allow) {
            a.removeFromIgnoreList(b);
        } else {
            a.addToIgnoreList(b);
        }
        assert (this.isCollisionBetweenLinkedBodies() == allow);
    }

    public void setEnabled(boolean enable) {
        long constraintId = this.nativeId();
        Constraint.setEnabled(constraintId, enable);
    }

    public void setFeedback(boolean enable) {
        long constraintId = this.nativeId();
        Constraint.enableFeedback(constraintId, enable);
    }

    protected final void copyConstraintProperties(Constraint old) {
        assert (old.hasAssignedNativeObject());
        assert (old.nativeId() != this.nativeId());
        float bit = old.getBreakingImpulseThreshold();
        this.setBreakingImpulseThreshold(bit);
        boolean enableConstraint = old.isEnabled();
        this.setEnabled(enableConstraint);
        boolean enableFeedback = old.isFeedback();
        this.setFeedback(enableFeedback);
        int numIterations = old.getOverrideIterations();
        this.overrideIterations(numIterations);
    }

    protected static final native int getConstraintType(long var0);

    protected final void readConstraintProperties(InputCapsule capsule) throws IOException {
        float breakingImpulse = capsule.readFloat(tagBreakingImpulse, Float.MAX_VALUE);
        this.setBreakingImpulseThreshold(breakingImpulse);
        if (this.countEnds() == 2) {
            boolean isCollision = capsule.readBoolean(tagIsCollision, true);
            this.setCollisionBetweenLinkedBodies(isCollision);
        }
        boolean isEnabled = capsule.readBoolean(tagIsEnabled, true);
        this.setEnabled(isEnabled);
        boolean isFeedback = capsule.readBoolean(tagIsFeedback, false);
        this.setFeedback(isFeedback);
        int numIterations = capsule.readInt(tagNumIterations, -1);
        this.overrideIterations(numIterations);
    }

    protected void setPivotInA(Vector3f location) {
        Validate.nonNull((Object)location, (String)"location");
        this.pivotA.set(location);
    }

    protected void setPivotInB(Vector3f location) {
        Validate.nonNull((Object)location, (String)"location");
        this.pivotB.set(location);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        Constraint old = (Constraint)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.pivotA = (Vector3f)cloner.clone((Object)this.pivotA);
        this.pivotB = (Vector3f)cloner.clone((Object)this.pivotB);
    }

    @Override
    public PhysicsRigidBody getBodyA() {
        PhysicsBody a = super.getBodyA();
        PhysicsRigidBody result = null;
        if (a instanceof PhysicsRigidBody) {
            result = (PhysicsRigidBody)a;
        }
        return result;
    }

    @Override
    public PhysicsRigidBody getBodyB() {
        PhysicsBody b = super.getBodyB();
        PhysicsRigidBody result = null;
        if (b instanceof PhysicsRigidBody) {
            result = (PhysicsRigidBody)b;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        long constraintId = this.nativeId();
        boolean result = Constraint.isEnabled(constraintId);
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.pivotA = (Vector3f)capsule.readSavable(tagPivotA, null);
        this.pivotB = (Vector3f)capsule.readSavable(tagPivotB, null);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.pivotA, tagPivotA, null);
        capsule.write((Savable)this.pivotB, tagPivotB, null);
        capsule.write(this.getBreakingImpulseThreshold(), tagBreakingImpulse, Float.MAX_VALUE);
        capsule.write(this.isCollisionBetweenLinkedBodies(), tagIsCollision, true);
        capsule.write(this.isEnabled(), tagIsEnabled, true);
        capsule.write(this.isFeedback(), tagIsFeedback, false);
        capsule.write(this.getOverrideIterations(), tagNumIterations, -1);
    }

    private static void freeNativeObject(long constraintId) {
        assert (constraintId != 0L);
        Constraint.finalizeNative(constraintId);
    }

    private static native void enableFeedback(long var0, boolean var2);

    private static native void finalizeNative(long var0);

    private static native float getAppliedImpulse(long var0);

    private static native float getBreakingImpulseThreshold(long var0);

    private static native int getOverrideIterations(long var0);

    private static native boolean isEnabled(long var0);

    private static native boolean needsFeedback(long var0);

    private static native void overrideIterations(long var0, int var2);

    private static native void setBreakingImpulseThreshold(long var0, float var2);

    private static native void setEnabled(long var0, boolean var2);
}

